/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.GuiTitlable;

public class MsisdnActivatePanel
extends BGUPanel {
    private static final String PHONE_REGEX = "^7\\d{10}$";
    private final JTextField msisdn = new JTextField();
    private final JButton activate = new JButton("\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    private final BGUList<GuiTitlable> msisdnList = new BGUList();
    private MegafonService megafonService;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.msisdnList.setCellRenderer((ListCellRenderer)new MsisdnListRenderer());
        GridBagConstraints gbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0);
        this.add(new JLabel("MSISDN"), gbc);
        this.add(this.msisdn, gbc);
        this.add(this.activate, gbc);
        this.add(new JLabel("\u041d\u043e\u043c\u0435\u0440\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043d\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044e"), gbc);
        gbc.weighty = 1.0;
        this.add(new JScrollPane((Component)this.msisdnList), gbc);
        this.activate.addActionListener(e -> this.activate());
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            ArrayList<GuiTitlable> data = new ArrayList<GuiTitlable>();
            JSONArray arr = new JSONArray(this.getMegafonService().getMsisdnListInActivateProcess());
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject n = arr.optJSONObject(i);
                data.add(() -> n.optString("msisdn") + " => " + n.optString("status"));
            }
            this.msisdnList.setData(data);
        });
    }

    private void activate() {
        String msisdn = this.msisdn.getText();
        if (Utils.isBlankString((String)msisdn) || !this.checkMsisdn(msisdn)) {
            BGToolTip.showErrorMessage((JComponent)this.msisdn, (String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u043e\u043c\u0435\u0440 \u0438\u043b\u0438 \u043d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442!");
            return;
        }
        try {
            this.getMegafonService().activateMsisdn(msisdn);
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.performAction("refresh");
    }

    private boolean checkMsisdn(String msisdn) {
        return !Utils.isBlankString((String)msisdn) && msisdn.length() == 10 && msisdn.matches(PHONE_REGEX);
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private final class MsisdnListRenderer
    implements ListCellRenderer<GuiTitlable> {
        private static final Font FONT = new Font("Serif", 1, 24);

        public MsisdnListRenderer() {
            MsisdnActivatePanel.this.setLayout(new GridBagLayout());
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GuiTitlable> list, GuiTitlable value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = new JLabel(value.getGuiTitle());
            l.setFont(FONT);
            l.setForeground(value.getGuiTitle().contains("\u0410\u043a\u0442\u0438\u0432\u0435\u043d") ? Color.GREEN : Color.RED);
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)l, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            p.setBackground(isSelected ? new Color(128, 128, 255) : Color.WHITE);
            return p;
        }
    }
}

