/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import ru.bitel.bgbilling.plugins.bonus.common.bean.AbstractBonusBalanceBean;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class BonusPayment
extends AbstractBonusBalanceBean {
    private Date dateFrom = new Date();
    private Date dateTo;
    private String comment;
    private String datePeriod;

    public BonusPayment() {
    }

    public BonusPayment(int id, int typeId, Date date, BigDecimal sum, Date dateFrom, Date dateTo) {
        super(id, typeId, date, sum);
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        String dateToString = TimeUtils.formatTimestamp((Timestamp)TimeUtils.convertDateToTimestamp((Date)dateTo), (String)"dd.MM.yyyy");
        String dateFromString = TimeUtils.formatTimestamp((Timestamp)TimeUtils.convertDateToTimestamp((Date)dateFrom), (String)"dd.MM.yyyy");
        this.datePeriod = dateFromString + " - " + dateToString;
    }

    public BonusPayment(int id, int typeId, Date date, BigDecimal sum, Period period, String comment) {
        this(id, typeId, date, sum, period.getDateFrom(), period.getDateTo());
        this.comment = comment;
    }

    public BonusPayment(int id, int typeId, Date date, BigDecimal sum, Period period) {
        this(id, typeId, date, sum, period.getDateFrom(), period.getDateTo());
    }

    public BonusPayment(int id, int typeId, String typeTitle, Date date, BigDecimal sum, Date dateFrom, Date dateTo) {
        this(id, typeId, date, sum, dateFrom, dateTo);
        this.typeTitle = typeTitle;
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    @XmlAttribute
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @XmlAttribute
    public String getDatePeriod() {
        return this.datePeriod;
    }

    public void setDatePeriod(String datePeriod) {
        this.datePeriod = datePeriod;
    }
}

