/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import ru.bitel.bgbilling.apps.inet.accounting.detail.FlowDetailMaker;
import ru.bitel.bgbilling.apps.inet.accounting.detail.PeriodValue;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowAnalyzer;
import ru.bitel.bgbilling.kernel.network.flow.FlowArray;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.localize.Localizer;
import ru.bitel.common.reports.Charts;
import ru.bitel.common.sql.ConnectionSet;

public class MonthFlowDetailMaker
extends FlowDetailMaker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendDetailImpl(DefaultServerSetup setup, ConnectionSet connectionSet, InetDetailCreateEvent task, List<FlowDetailMaker.FlowDetailEntry> entries, StringBuilder messageBody, String subject) throws Exception {
        File file;
        boolean email = Utils.notBlankString((String)task.getEmail());
        if (email) {
            file = File.createTempFile("accounting_detail_month", ".zip.tmp");
        } else {
            File dir = new File(setup.get("detail.dir", "data"), "detail");
            dir.mkdirs();
            file = new File(dir, task.getInetServId() + "_" + task.getInetServTitle() + "_" + TimeUtils.format((Date)task.getTimeFrom(), (String)"yyyyMMdd") + "-" + TimeUtils.format((Date)task.getTimeTo(), (String)"yyyyMMdd") + ".zip.tmp");
        }
        try {
            this.sendDetailImpl0(setup, connectionSet, task, entries, messageBody, subject, file, email);
        }
        finally {
            if (email) {
                file.delete();
            }
        }
    }

    protected void sendDetailImpl0(DefaultServerSetup setup, ConnectionSet connectionSet, InetDetailCreateEvent task, List<FlowDetailMaker.FlowDetailEntry> entries, StringBuilder messageBody, String subject, File file, boolean email) throws Exception {
        FileOutputStream bos = new FileOutputStream(file);
        ZipOutputStream zos = new ZipOutputStream(bos);
        zos.setLevel(setup.getInt("accounting.detail.compression.level", -1));
        zos.putNextEntry(new ZipEntry("detail.csv"));
        PrintStream csvReport = new PrintStream((OutputStream)zos, false, "UTF-8");
        csvReport.append("\u0412\u0440\u0435\u043c\u044f;\u0421 \u0430\u0434\u0440\u0435\u0441\u0430;\u0421 \u043f\u043e\u0440\u0442\u0430;\u041d\u0430 \u0430\u0434\u0440\u0435\u0441;\u041d\u0430 \u043f\u043e\u0440\u0442;\u0411\u0430\u0439\u0442;\u0421 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0430;\u041d\u0430 \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        for (FlowDetailMaker.FlowDetailEntry entry : entries) {
            for (FlowArray<IPDataLogUtils.FlowDetail> f : entry.newFlowDetailIterable()) {
                int size = f.size;
                for (int i = 0; i < size; ++i) {
                    IPDataLogUtils.FlowDetail detail = ((IPDataLogUtils.FlowDetail[])f.array)[i];
                    this.printToCsv(csvReport, (Data)detail, dateFormat);
                }
            }
        }
        csvReport.flush();
        zos.closeEntry();
        if (!email) {
            zos.putNextEntry(new ZipEntry("info.txt"));
            PrintStream info = new PrintStream((OutputStream)zos, false, "UTF-8");
            info.println(subject);
            info.println();
            info.print(messageBody);
            info.flush();
            zos.closeEntry();
        }
        zos.flush();
        zos.close();
        zos = null;
        bos.flush();
        bos.close();
        bos = null;
        if (email) {
            this.sendDetailMail(setup, task, messageBody, subject, file);
        } else {
            file.renameTo(new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 4)));
        }
    }

    private void sendDetailMail(DefaultServerSetup setup, InetDetailCreateEvent task, StringBuilder messageBody, String subject, final File file) throws BGException {
        String fileName = "detail.zip";
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart attach = new MimeBodyPart();
        try {
            DataSource ds = new DataSource(){

                public String getContentType() {
                    return "application/zip";
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(file);
                }

                public String getName() {
                    return "detail.zip";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }
            };
            attach.setDataHandler(new DataHandler(ds));
            attach.setFileName("detail.zip");
            multipart.addBodyPart((BodyPart)attach);
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
        this.sendDetailMail(setup, task, subject, messageBody, attach);
    }

    protected void writeChart(SortedMap<Long, PeriodValue> periodValues, OutputStream outputStream, TimeUnit timeUnit) throws IOException {
        TimeSeries outputSeries;
        TimeSeries inputSeries;
        switch (timeUnit) {
            case MINUTES: {
                inputSeries = new TimeSeries((Comparable)((Object)"\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                outputSeries = new TimeSeries((Comparable)((Object)"\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                for (Map.Entry<Long, PeriodValue> e : periodValues.entrySet()) {
                    long millis = timeUnit.toMillis(e.getKey());
                    PeriodValue periodValue = e.getValue();
                    Minute timePeriod = new Minute(new Date(millis));
                    inputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.input / 1024.0);
                    outputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.output / 1024.0);
                }
                break;
            }
            default: {
                inputSeries = new TimeSeries((Comparable)((Object)"\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                outputSeries = new TimeSeries((Comparable)((Object)"\u0418\u0441\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0442\u0440\u0430\u0444\u0438\u043a (\u041a\u0411/\u043c\u0438\u043d)"));
                for (Map.Entry<Long, PeriodValue> e : periodValues.entrySet()) {
                    long millis = timeUnit.toMillis(e.getKey());
                    PeriodValue periodValue = e.getValue();
                    Day timePeriod = new Day(new Date(millis));
                    inputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.input / 1024.0);
                    outputSeries.add((RegularTimePeriod)timePeriod, (double)periodValue.output / 1024.0);
                }
            }
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(inputSeries);
        dataset.addSeries(outputSeries);
        ChartUtils.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)Charts.createTimeSeriesChart((XYItemRenderer)new XYStepRenderer(), (XYDataset)dataset), (int)832, (int)275, (ChartRenderingInfo)new ChartRenderingInfo(), (boolean)true, (int)0);
        inputSeries.clear();
        outputSeries.clear();
    }

    protected void writeInfo(XMLStreamWriter w, FlowAnalyzer analyzer, InetDetailCreateEvent task, ParameterMap params, boolean analyze) throws Exception {
        w.writeStartElement("div");
        w.writeAttribute("class", "info");
        if (analyze) {
            w.writeCharacters("\u0420\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0435 \u0442\u0440\u0430\u0444\u0438\u043a\u0430 \u043f\u043e IP-\u0430\u0434\u0440\u0435\u0441\u0430\u043c, \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430\u043c \u0438 \u043f\u043e\u0440\u0442\u0430\u043c, \u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043a\u0438\u043b\u043e\u0431\u0430\u0439\u0442\u0430\u0445.");
            w.writeEmptyElement("br");
            w.writeCharacters("HTTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 www \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("SMTP - \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043f\u043e\u0447\u0442\u044b");
            w.writeEmptyElement("br");
            w.writeCharacters("POP3/IMAP - \u043f\u0440\u0438\u0435\u043c \u043f\u043e\u0447\u0442\u044b");
            w.writeEmptyElement("br");
            w.writeCharacters("FTP - \u0442\u0440\u0430\u0444\u0438\u043a \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u043d\u044b\u0439 \u043f\u0440\u0438 \u0440\u0430\u0431\u043e\u0442\u0435 \u0441 ftp \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("UDP named - \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u043b\u0443\u0447\u0430\u0435\u043c\u044b\u0439 \u0432 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u0435 \u043f\u0440\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0439 \u0438\u043c\u0435\u043d \u0445\u043e\u0441\u0442\u043e\u0432 \u0432 ip \u0430\u0434\u0440\u0435\u0441 \u0438\u043b\u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e, \u043e\u0447\u0435\u043d\u044c \u0431\u043e\u043b\u044c\u0448\u043e\u0439 \u0442\u0440\u0430\u0444\u0438\u043a \u043f\u043e \u044d\u0442\u043e\u043c\u0443 \u0441\u0435\u0440\u0432\u0438\u0441\u0443 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0435\u043d \u043f\u0440\u0438 \u0437\u0430\u0440\u0430\u0436\u0435\u043d\u0438\u0438 \u0432\u0438\u0440\u0443\u0441\u0430\u043c\u0438 \u043c\u0430\u0448\u0438\u043d \u0432 \u043b\u043e\u043aa\u043b\u044c\u043d\u043e\u0439 \u0441\u0435\u0442\u0438");
            w.writeEmptyElement("br");
            w.writeCharacters("\u0414\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044b \u0432 \u043e\u0442\u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u043c \u043f\u043e \u0443\u043c\u0435\u043d\u044c\u0448\u0435\u043d\u0438\u044e \u043f\u043e\u0440\u044f\u0434\u043a\u0435");
        } else {
            w.writeCharacters("\u0421\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u043d\u043e\u0433\u043e IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0434\u043b\u044f \u0430\u043d\u0430\u043b\u0438\u0437\u0430 \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043f\u043e IP-\u0430\u0434\u0440\u0435\u0441\u0430\u043c, \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b\u0430\u043c \u0438 \u043f\u043e\u0440\u0442\u0430\u043c.");
        }
        w.writeEndElement();
    }

    protected void writeTable(XMLStreamWriter w, FlowAnalyzer analyzer, InetDetailCreateEvent task, ParameterMap params) throws Exception {
        w.writeStartElement("table");
        w.writeAttribute("width", "100%");
        w.writeAttribute("cellpadding", "0");
        w.writeAttribute("cellspacing", "0");
        w.writeAttribute("border", "0");
        w.writeAttribute("class", "data");
        w.writeStartElement("thead");
        w.writeStartElement("tr");
        MonthFlowDetailMaker.writeTDWithClass(w, "IP", "2", "1", "line");
        MonthFlowDetailMaker.writeTDWithClass(w, "\u0412\u0441\u0435\u0433\u043e", "1", "2", "line");
        MonthFlowDetailMaker.writeTDWithClass(w, "TCP/UDP/ICMP/\u0414\u0440\u0443\u0433\u043e\u0435", "1", "2", "line");
        MonthFlowDetailMaker.writeTDWithClass(w, "TCP: HTTP", "1", "2", "line");
        MonthFlowDetailMaker.writeTDWithClass(w, "TCP: SMTP/POP3/IMAP/FTP", "1", "2", "line");
        MonthFlowDetailMaker.writeTDWithClass(w, "UDP named", "1", "2", "line");
        w.writeEndElement();
        w.writeStartElement("tr");
        MonthFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0412\u0445.");
        MonthFlowDetailMaker.writeTD(w, "\u0418\u0441\u0445.");
        w.writeEndElement();
        w.writeEndElement();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator(Localizer.getDecimalFormatSymbols().getDecimalSeparator());
        DecimalFormat df = new DecimalFormat("########0.00", dfs);
        double divisor = 1024.0;
        int count = 0;
        int maxResolve = params.getInt("ipn.collector.detail.hostresolve", 5);
        w.writeStartElement("tbody");
        for (FlowAnalyzer.FlowAnalizerEntry f : analyzer.get()) {
            w.writeStartElement("tr");
            if (count++ < maxResolve) {
                String host = InetAddress.getByAddress(f.ip.address).getHostName();
                String ip = f.ip.toString();
                if (!ip.equals(host)) {
                    w.writeStartElement("td");
                    w.writeAttribute("rowspan", "4");
                    w.writeAttribute("class", "line");
                    w.writeCharacters(ip);
                    w.writeEmptyElement("br");
                    w.writeCharacters(host);
                    w.writeEndElement();
                } else {
                    MonthFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
                }
            } else {
                MonthFlowDetailMaker.writeTDWithClass(w, f.ip.toString(), "4", "line");
            }
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctets() / 1024.0), "4", "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctets() / 1024.0), "4", "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcp() / 1024.0), "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcp() / 1024.0), "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpHttp() / 1024.0), "4", "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpHttp() / 1024.0), "4", "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsTcpSmtp() / 1024.0), "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsTcpSmtp() / 1024.0), "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.input.getOctetsUdpNamed() / 1024.0), "4", "line");
            MonthFlowDetailMaker.writeTDWithClass(w, df.format((double)f.output.getOctetsUdpNamed() / 1024.0), "4", "line");
            w.writeEndElement();
            w.writeStartElement("tr");
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsUdp() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsUdp() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpPop3() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpPop3() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsIcmp() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsIcmp() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpImap() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpImap() / 1024.0));
            w.writeEndElement();
            w.writeStartElement("tr");
            MonthFlowDetailMaker.writeTD(w, df.format((double)(f.input.getOctets() - f.input.getOctetsIcmp() - f.input.getOctetsTcp() - f.input.getOctetsUdp()) / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)(f.output.getOctets() - f.output.getOctetsIcmp() - f.output.getOctetsTcp() - f.output.getOctetsUdp()) / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.input.getOctetsTcpFtp() / 1024.0));
            MonthFlowDetailMaker.writeTD(w, df.format((double)f.output.getOctetsTcpFtp() / 1024.0));
            w.writeEndElement();
        }
        w.writeEndElement();
        w.writeEndElement();
    }

    protected void writeHTMLHead(XMLStreamWriter w, String title) throws XMLStreamException {
        w.writeStartElement("title");
        w.writeCharacters(title);
        w.writeEndElement();
        w.writeStartElement("meta");
        w.writeAttribute("http-equiv", "Content-Type");
        w.writeAttribute("content", "text/html; charset=UTF-8");
        w.writeEndElement();
    }

    protected void writeHTMLStyle(XMLStreamWriter w) throws XMLStreamException {
        w.writeStartElement("style");
        w.writeCharacters("tbody td.line {border-top-style: solid; border-top-width: 1px; border-top-color: #000000;}\n");
        w.writeCharacters("table.data td {font-family: sansserif; font-size: 8.0px;}\n");
        w.writeCharacters("table.data thead td {font-weight: bold; padding: 1px;}\n");
        w.writeCharacters("div.plot {text-align: center;}\n");
        w.writeCharacters("div.body {margin:0 auto; width: 842px;}\n");
        w.writeCharacters("div.title {text-align: center; font-family: sansserif; font-size: 12.0px; font-weight: bold; margin-top: 20px;}\n");
        w.writeCharacters("div#plot_title, div#data_title {font-size: 11.0px}\n");
        w.writeCharacters("div.info {font-size: 8.0px}\n");
        w.writeCharacters("table.data {margin-top: 10px; border-bottom: solid 1px;}\n");
        w.writeEndElement();
    }

    private static final void writeTD(XMLStreamWriter w, String data) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String rowspan, String colspan, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("rowspan", rowspan);
        w.writeAttribute("colspan", colspan);
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }

    private static final void writeTDWithClass(XMLStreamWriter w, String data, String clazz) throws XMLStreamException {
        w.writeStartElement("td");
        w.writeAttribute("class", clazz);
        w.writeCharacters(data);
        w.writeEndElement();
    }
}

