/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.driver.zshtrih;

import java.io.UnsupportedEncodingException;
import jssc.SerialPortException;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zshtrih.PrinterShtrihErrorException;
import ru.bitel.bgbilling.apps.cashcheck.frk.driver.zshtrih.PrinterStatus;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.PrinterConnectException;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGByteBuffer;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.DeviceSerialPort;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.SerialParameters;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;

public class ShtrihFRKPrinter
extends DeviceSerialPort {
    private static final byte SS_ENQ = 5;
    private static final byte SS_STX = 2;
    private static final byte SS_ACK = 6;
    private static final byte SS_NAK = 21;
    private BGByteBuffer bPassword = null;
    private int oneByteTimeout = 100;
    private Logger logTrace;

    public ShtrihFRKPrinter(SerialParameters portParam, int oneByteTimeout, long pass, Logger logTrace) {
        super(portParam);
        this.oneByteTimeout = oneByteTimeout;
        this.bPassword = ShtrihFRKPrinter.encodeNumber(pass, 4);
        this.logTrace = logTrace;
    }

    private static BGByteBuffer encodeString(String string, int bytes) {
        byte[] msgbytesLEN = new byte[bytes];
        if (string != null) {
            byte[] msgbytes = null;
            try {
                msgbytes = string.getBytes("windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            System.arraycopy(msgbytes, 0, msgbytesLEN, 0, Math.min(bytes, msgbytes.length));
        }
        return new BGByteBuffer(msgbytesLEN, bytes);
    }

    private static BGByteBuffer encodeNumber(long number, int bytes) {
        if (number < 0L) {
            long summan = 1L;
            for (int i = 0; i < bytes; ++i) {
                summan *= 256L;
            }
            number += summan;
        }
        BGByteBuffer ret = new BGByteBuffer();
        for (int n = 0; n < bytes; ++n) {
            if (number > 0L) {
                byte number1 = (byte)(number % 256L);
                ret.pushEnd(number1);
                number /= 256L;
                continue;
            }
            ret.pushEnd((byte)0);
        }
        return ret;
    }

    private static long decodeNumber(byte[] buffer, int offset, int bytes) {
        long mul = 1L;
        long num = 0L;
        for (int i = offset; i < offset + bytes; ++i) {
            num += (long)BGByteBuffer.byte2int(buffer[i]) * mul;
            mul *= 256L;
        }
        return num;
    }

    private BGByteBuffer _sendCommand(BGByteBuffer buffer) throws PrinterShtrihErrorException, PrinterConnectException {
        try {
            BGByteBuffer packcmd = new BGByteBuffer(buffer);
            byte l = (byte)packcmd.getBytes().length;
            packcmd.pushBegin(l);
            packcmd.pushEnd(packcmd.getLRC());
            packcmd.pushBegin((byte)2);
            this.$trace("SEND: " + packcmd.toString());
            this._send(packcmd);
            this._setTimeout(this.oneByteTimeout * 2);
            int b = -1;
            b = this._recv();
            if (b == -1) {
                throw new PrinterConnectException("echo error: no answer to the command posted");
            }
            if (b == 6) {
                this._setTimeout(60000);
                BGByteBuffer stx = this._readSTX();
                if (stx != null) {
                    this._send((byte)6);
                    byte cod = stx.popBeginByte();
                    if (cod != buffer.getBytes()[0]) {
                        throw new PrinterConnectException("protocol error: not equals code from ask and reply");
                    }
                    byte berr = stx.popBeginByte();
                    if (berr != 0) {
                        throw new PrinterShtrihErrorException(BGByteBuffer.byte2int(berr));
                    }
                    return stx;
                }
            }
        }
        catch (SerialPortException e) {
            throw new PrinterConnectException(e.toString());
        }
        return null;
    }

    private BGByteBuffer _readSTX() throws SerialPortException {
        int b = -1;
        b = this._recv();
        if (b == -1) {
            return null;
        }
        if (b != 2) {
            this.$trace("_readSTX: error: STX=0x" + new BGByteBuffer((byte)b));
            return null;
        }
        int len = -1;
        len = this._recv();
        if (len == -1) {
            return null;
        }
        BGByteBuffer body = this._recv(len);
        if (body == null || body.getBytes().length != len) {
            this.$trace("_readSTX: error: body=" + body + ", len=" + len);
            return null;
        }
        int lrc = -1;
        lrc = this._recv();
        if (lrc == -1) {
            return null;
        }
        BGByteBuffer stxpack = new BGByteBuffer();
        stxpack.pushEnd((byte)len);
        stxpack.pushEnd(body);
        byte ks = stxpack.getLRC();
        this.$trace("RECV: " + new BGByteBuffer(stxpack).pushEnd((byte)lrc).pushBegin((byte)2));
        if (ks == (byte)lrc) {
            stxpack.popBeginByte();
            return stxpack;
        }
        this.$trace("_readSTX: error LRC");
        return null;
    }

    public String getName() throws PrinterConnectException, PrinterShtrihErrorException {
        BGByteBuffer reply;
        String name = null;
        if (this._reset() && (reply = this._sendCommand(new BGByteBuffer(-4))) != null) {
            byte type = reply.popBeginByte();
            byte subtype = reply.popBeginByte();
            byte pver = reply.popBeginByte();
            byte subpver = reply.popBeginByte();
            byte model = reply.popBeginByte();
            byte lang = reply.popBeginByte();
            String devicename = null;
            try {
                devicename = new String(reply.getBytes(), "windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            name = devicename + " (";
            name = type == 0 && subtype == 0 ? name + "\u0442\u0438\u043f:\u041a\u041a\u041c/\u0424\u0420" : name + "\u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e-\u0432\u043e: \u0442\u0438\u043f " + type + "." + subtype;
            name = name + ", \u043c\u043e\u0434\u0435\u043b\u044c:" + model;
            name = name + ", \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b:" + pver + "." + subpver;
            name = name + ", \u044f\u0437\u044b\u043a:" + lang + (lang == 0 ? "(RU)" : "");
            name = name + ")";
        }
        return name;
    }

    public PrinterStatus getStatusShort() throws PrinterConnectException, PrinterShtrihErrorException {
        PrinterStatus ps = null;
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(16);
            cmd.pushEnd(this.bPassword);
            BGByteBuffer reply = this._sendCommand(cmd);
            if (reply != null) {
                ps = new PrinterStatus();
                ps.operatorNum = reply.getBytes()[0];
                ps.rulonOpJournal = Utils.testBit((byte)reply.getBytes()[1], (int)0);
                ps.rulonVoucherTape = Utils.testBit((byte)reply.getBytes()[1], (int)1);
                ps.haveEKLZ = Utils.testBit((byte)reply.getBytes()[1], (int)5);
                ps.paperOpJournal = Utils.testBit((byte)reply.getBytes()[1], (int)6);
                ps.paperVoucherTape = Utils.testBit((byte)reply.getBytes()[1], (int)7);
                ps.leverPrintheadControlTape = Utils.testBit((byte)reply.getBytes()[2], (int)0);
                ps.leverPrintheadVoucherTape = Utils.testBit((byte)reply.getBytes()[2], (int)1);
                ps.coverCorpsFR = Utils.testBit((byte)reply.getBytes()[2], (int)2);
                ps.moneyBox = Utils.testBit((byte)reply.getBytes()[2], (int)3);
                ps.filledEKLZ = Utils.testBit((byte)reply.getBytes()[2], (int)6);
                ps.mode = reply.getBytes()[3];
                ps.submode = reply.getBytes()[4];
                ps.operationCount = reply.getBytes()[10] * 256 + reply.getBytes()[5];
                ps.voltageBackupBattery = Float.valueOf((float)BGByteBuffer.byte2int(reply.getBytes()[6]) / 51.0f);
                ps.voltagePowerSource = Float.valueOf((float)BGByteBuffer.byte2int(reply.getBytes()[7]) / 9.0f);
                ps.errorFP = reply.getBytes()[8];
                ps.errorEKLZ = reply.getBytes()[9];
            }
        }
        return ps;
    }

    void printLine(String string, boolean control) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(23);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(control ? (byte)3 : 2);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(string, 40));
        this._sendCommand(cmd);
    }

    void cut() throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(37);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)1);
        this._sendCommand(cmd);
    }

    private void runline(int lines, boolean check, boolean control) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(41);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd((byte)((check ? 2 : 0) | (control ? 1 : 0)));
        cmd.pushEnd((byte)lines);
        this._sendCommand(cmd);
    }

    public void _waitToNoPrint(int timeout, int numtry) throws PrinterShtrihErrorException, PrinterConnectException {
        if (numtry > 0) {
            PrinterStatus ps = null;
            for (int i = 0; i < numtry; ++i) {
                ps = this.getStatusShort();
                if (ps.submode != 4 && ps.submode != 5) {
                    return;
                }
                try {
                    Thread.sleep(timeout);
                    continue;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            throw new PrinterConnectException("too many wait to substatus with noprint (last mode " + ps.modeNumString() + ", submode " + ps.submode + ")");
        }
    }

    public void sale(long number, long price, int roomDivision, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(-128);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(number, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(price, 5));
        cmd.pushEnd((byte)roomDivision);
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        this._sendCommand(cmd);
    }

    public void saleback(long number, long price, int roomDivision, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(-126);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(number, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(price, 5));
        cmd.pushEnd((byte)roomDivision);
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        this._sendCommand(cmd);
    }

    public long closeCheck(long summa, long summa2, long summa3, long summa4, int discount, String text, int tax1, int tax2, int tax3, int tax4) throws PrinterShtrihErrorException, PrinterConnectException {
        long submit = 0L;
        BGByteBuffer cmd = new BGByteBuffer(-123);
        cmd.pushEnd(this.bPassword);
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa2, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa3, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(summa4, 5));
        cmd.pushEnd(ShtrihFRKPrinter.encodeNumber(discount, 2));
        cmd.pushEnd((byte)tax1);
        cmd.pushEnd((byte)tax2);
        cmd.pushEnd((byte)tax3);
        cmd.pushEnd((byte)tax4);
        cmd.pushEnd(ShtrihFRKPrinter.encodeString(text, 40));
        BGByteBuffer reply = this._sendCommand(cmd);
        if (reply != null) {
            submit = ShtrihFRKPrinter.decodeNumber(reply.getBytes(), 1, 5);
        }
        return submit;
    }

    public void buzzer() throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer cmd = new BGByteBuffer(19);
        cmd.pushEnd(this.bPassword);
        this._sendCommand(cmd);
    }

    public void xreport() throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(64);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public void zreport() throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(65);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public void divreport() throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(66);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public void repeatDoc() throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(-116);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public BGByteBuffer pureCmd(String hexDump) throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            return this._sendCommand(new BGByteBuffer(hexDump));
        }
        return null;
    }

    public void continuePrint() throws PrinterConnectException, PrinterShtrihErrorException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(-80);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public void cancelCheck() throws PrinterShtrihErrorException, PrinterConnectException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(-120);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    public void openDay() throws PrinterShtrihErrorException, PrinterConnectException {
        if (this._reset()) {
            BGByteBuffer cmd = new BGByteBuffer(-32);
            cmd.pushEnd(this.bPassword);
            this._sendCommand(cmd);
        }
    }

    private boolean _reset() throws PrinterConnectException {
        try {
            for (int i = 0; i < 10; ++i) {
                try {
                    Thread.sleep(this.oneByteTimeout * 2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this._send((byte)5);
                this.$trace("_reset: send ENQ (" + i + ")");
                this._setTimeout(10000);
                int b = -1;
                b = this._recv();
                if (b == -1) {
                    throw new PrinterConnectException("reset: there was no reaction to ENQ. (\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043b\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440)");
                }
                if (b == 21) {
                    this.$trace("_reset: getted NAK (" + i + ")");
                    return true;
                }
                if (b == 6) {
                    this.$trace("_reset: getted ACK (" + i + ")");
                    BGByteBuffer stx = this._readSTX();
                    this.$trace("_reset: STX message= " + stx + " (" + i + ")");
                    if (stx != null) {
                        this.$trace("_reset: send ACK (" + i + ")");
                        this._send((byte)6);
                        continue;
                    }
                    this.$trace("_reset: send NAK (" + i + ")");
                    this._send((byte)21);
                    continue;
                }
                this.$trace("_reset: unknown response (not NAK or ACK) (" + i + ")");
                this._setTimeout(1000);
                this.$trace("_reset: read garbage midden: " + BGByteBuffer.toString((byte)b) + "... (" + i + ")");
                BGByteBuffer buf = this._recv_all();
                this.$trace(buf.toString());
            }
            throw new PrinterConnectException("reset: ENQ incorrect response to the 10 attempts.");
        }
        catch (SerialPortException e) {
            throw new PrinterConnectException(e.toString());
        }
    }

    public boolean open() throws PrinterConnectException {
        try {
            super._open();
            if (!this._reset()) {
                this.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.close();
            if (e instanceof PrinterConnectException) {
                throw (PrinterConnectException)e;
            }
            throw new PrinterConnectException(e.toString());
        }
        return true;
    }

    public void close() {
        try {
            super._close();
        }
        catch (SerialPortException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String _touch() {
        Object message = null;
        boolean isPrinterValid = false;
        try {
            this._open();
            this._send((byte)5);
            this._setTimeout(100);
            int b = this._recv();
            if (b == -1) {
                message = "no reaction";
            } else if (b == 21) {
                message = "OK reaction";
                isPrinterValid = true;
            } else if (b == 6) {
                BGByteBuffer stx = this._readSTX();
                if (stx != null) {
                    this._send((byte)6);
                    message = "ACK reaction, readed STX: " + stx.toString();
                } else {
                    this._send((byte)21);
                    message = "ACK reaction, but error read STX";
                }
                isPrinterValid = true;
            } else {
                BGByteBuffer bufrecv = new BGByteBuffer((byte)b);
                this._setTimeout(100);
                BGByteBuffer buf = this._recv_all();
                bufrecv.pushEnd(buf);
                message = "garbage midden: '" + bufrecv.toString() + "'";
                isPrinterValid = true;
            }
            if (isPrinterValid) {
                try {
                    message = (String)message + "; name: " + this.getName();
                }
                catch (Throwable e) {
                    message = (String)message + "; error get name: " + BGException.printStackTraceToString((Throwable)e);
                }
            }
        }
        catch (Throwable e) {
            message = "device touch error: " + e.toString();
        }
        finally {
            try {
                this._close();
            }
            catch (Throwable e) {
                this.logTrace.error("error close port", e);
            }
        }
        return message;
    }

    private void $trace(String message) {
        if (this.logTrace != null) {
            this.logTrace.trace("shtrih-driver: " + message);
        }
    }
}

