/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.GateSelectPanel;
import ru.bitel.bgbilling.modules.ipn.client.GateTreeTableNode;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class VlanGateSelectPanel
extends GateSelectPanel {
    private int vlanId = -1;
    private JTextField vlanText;
    private JCheckBox vlanAvto;

    public VlanGateSelectPanel(String actionName) {
        super(actionName);
    }

    @Override
    protected JPanel getAdditionalPanel() {
        this.vlanText = new JTextField();
        this.vlanText.setSize(300, 12);
        this.vlanAvto = new JCheckBox();
        this.vlanAvto.addActionListener(e -> this.vlanAvto_actionPerformed(e));
        BGPanel panelVlan = new BGPanel((LayoutManager)new GridBagLayout());
        panelVlan.add((Component)this.vlanText, (Object)new GridBagConstraints(0, 0, 1, 1, 0.1, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        panelVlan.add((Component)this.vlanAvto, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panelVlan.add((Component)new JLabel("\u0430\u0432\u0442\u043e"), (Object)new GridBagConstraints(2, 0, 1, 1, 0.1, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        return panelVlan;
    }

    @Override
    public void setData() throws Exception {
        super.setData();
        this.vlanAvto.setSelected(true);
        this.vlanText.setText("vlan");
        this.vlanText.setEditable(false);
        this.vlanId = -1;
    }

    @Override
    protected void okPressed() {
        GateTreeTableNode gateNode = (GateTreeTableNode)this.model.getSelectedNode();
        if (this.vlanAvto.isSelected()) {
            super.okPressed();
        } else {
            if (this.vlanText == null || Utils.isEmptyString((String)this.vlanText.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u043e\u043c\u0435\u0440 VLAN");
                return;
            }
            this.vlanId = Utils.parseInt((String)this.vlanText.getText());
            if (this.vlanId > 4096 || this.vlanId < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 VLAN (1-4096)");
                return;
            }
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("GetUsedVlan");
            request.setModuleId(this.getModuleId());
            request.setAttribute("gid", gateNode.id);
            request.setAttribute("vlanId", this.vlanId);
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                String vl = XMLUtils.getAttribute((Element)XMLUtils.getElement((Document)doc, (String)"vlan"), (String)"vl");
                if (vl.equals("1")) {
                    ClientUtils.showErrorMessageDialog((String)"\u042d\u0442\u043e\u0442 VLAN \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
                    return;
                }
                this.vlanId = Utils.parseInt((String)this.vlanText.getText());
                super.okPressed();
            }
        }
    }

    private void vlanAvto_actionPerformed(ActionEvent e) {
        if (this.vlanAvto.isSelected()) {
            this.vlanText.setText("vlan");
            this.vlanText.setEditable(false);
            this.vlanId = -1;
        } else {
            this.vlanText.setText("");
            this.vlanText.setEditable(true);
        }
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public void setVlanId(int vlanId) {
        this.vlanId = vlanId;
    }
}

