/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionRuntime;

public class IpResourceDynSubscriptionDao
extends BGLogger {
    private final Connection con;
    private final int moduleId;
    private String tableName;
    private static final ExecutorService SERVICE = Executors.newFixedThreadPool(1);

    public IpResourceDynSubscriptionDao(Connection con, int moduleId) {
        this.con = con;
        this.moduleId = moduleId;
        this.tableName = ServerUtils.getModuleTableName("inv_ip_resource_subscription_dyn", moduleId);
    }

    private static void createTable(Connection con, String tableName) throws SQLException {
        try (Statement stmt = con.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS `" + tableName + "` (\t\t  `id` bigint NOT NULL AUTO_INCREMENT,\t\t  `ipResourceId` int(11) NOT NULL,\t\t  `address` varbinary(24) NOT NULL,\t\t  `timeFrom` datetime NOT NULL,\t\t  `timeTo` datetime,\t\t  `subscriberId` int(11) NOT NULL,\t\t  `subscriberType` int(11) NOT NULL,\t\t  `subscriberTitle` varchar(150) NOT NULL,\t\t  PRIMARY KEY (`id`),\t\t  KEY `ip` (`ipResourceId`,`address`) ,\t\t  KEY `period` (`timeFrom`,`timeTo`) ,\t\t  KEY `subscriber` (`subscriberId`))");
        }
    }

    public long occupie(int ipResourceId, long connectionId, byte[] address, Date timeFrom, int subscriberType, int subscriberId, String subscriberTitle) throws BGException {
        try {
            if (!ServerUtils.tableExists(this.con, this.tableName)) {
                IpResourceDynSubscriptionDao.checkTables(this.con, this.moduleId);
            }
            PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (ipResourceId, connectionId, address, timeFrom, subscriberType, subscriberId, subscriberTitle) VALUES (?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setInt(1, ipResourceId);
            ps.setLong(2, connectionId);
            ps.setBytes(3, address);
            ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)timeFrom));
            ps.setInt(5, subscriberType);
            ps.setInt(6, subscriberId);
            ps.setString(7, subscriberTitle);
            ps.executeUpdate();
            long id = ServerUtils.lastInsertLongId(ps);
            ps.close();
            return id;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public long free(int ipResourceId, long connectionId, byte[] address, Date timeTo, int subscriberType, int subscriberId) throws BGException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("free: connectionId= " + connectionId + "; address=" + IpAddress.toString((byte[])address));
        }
        if (connectionId % 100L == 0L) {
            SERVICE.execute(new Runnable(){

                @Override
                public void run() {
                    Connection con = Setup.getSetup().getDBConnectionFromPool();
                    try {
                        con.setAutoCommit(false);
                        IpResourceDynSubscriptionDao.this.getLogger().debug("Move old from inv_ip_resource_subscription_dyn_" + IpResourceDynSubscriptionDao.this.moduleId);
                        IpResourceDynSubscriptionDao.this.move(con, IpResourceDynSubscriptionDao.this.moduleId, IpResourceDynSubscriptionDao.this.tableName);
                        con.commit();
                        IpResourceDynSubscriptionDao.this.getLogger().debug("End move old from inv_ip_resource_subscription_dyn_" + IpResourceDynSubscriptionDao.this.moduleId);
                    }
                    catch (SQLException ex) {
                        BGLogger.error(ex);
                    }
                    finally {
                        ServerUtils.closeConnection(con);
                    }
                }
            });
        }
        String querySelect = "SELECT id FROM " + this.tableName + " WHERE connectionId=? AND subscriberId=? AND subscriberType=? AND ipResourceId=? AND timeTo IS NULL AND address=?";
        String queryUpdate = "UPDATE " + this.tableName + " SET timeTo=? WHERE id=?";
        long subscriptionId = 0L;
        try (PreparedStatement psSelect = this.con.prepareStatement(querySelect);
             PreparedStatement psUpdate = this.con.prepareStatement(queryUpdate);){
            int index = 1;
            psSelect.setLong(index++, connectionId);
            psSelect.setInt(index++, subscriberId);
            psSelect.setInt(index++, subscriberType);
            psSelect.setInt(index++, ipResourceId);
            psSelect.setBytes(index++, address);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    subscriptionId = rs.getLong(1);
                }
            }
            if (subscriptionId > 0L) {
                psUpdate.setTimestamp(1, TimeUtils.convertDateToTimestamp((Date)timeTo));
                psUpdate.setLong(2, subscriptionId);
                psUpdate.executeUpdate();
            } else {
                this.getLogger().info("Records not found for connectionId: " + connectionId + " and ipResourceId: " + ipResourceId);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("free: return subscriptionId=" + subscriptionId);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return subscriptionId;
    }

    public List<IpResourceSubscriptionRuntime> listRuntime(int ipResourceId) throws BGException {
        ArrayList<IpResourceSubscriptionRuntime> result = new ArrayList<IpResourceSubscriptionRuntime>(100);
        String query = "SELECT id, address FROM " + this.tableName + " WHERE ipResourceId=? AND timeTo IS NULL";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, ipResourceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    IpResourceSubscriptionRuntime subscription = new IpResourceSubscriptionRuntime(rs.getInt(1), rs.getBytes(2), null);
                    result.add(subscription);
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public static void checkTables(Connection con, int moduleId) {
        try {
            String tableName = ServerUtils.getModuleTableName("inv_ip_resource_subscription_dyn", moduleId);
            if (ServerUtils.tableExists(con, tableName)) {
                return;
            }
            Statement stmt = con.createStatement();
            stmt.executeUpdate("CREATE TABLE `" + tableName + "` ( `id` bigint(11) NOT NULL AUTO_INCREMENT, `ipResourceId` int(11) NOT NULL, `connectionId` bigint NOT NULL, `address` varbinary(24) NOT NULL, `timeFrom` datetime NOT NULL, `timeTo` datetime DEFAULT NULL, `subscriberId` int(11) NOT NULL, `subscriberType` int(11) NOT NULL, `subscriberTitle` varchar(150) NOT NULL, PRIMARY KEY (`id`), KEY `connectionId` (`connectionId`), KEY `ip` (`ipResourceId`,`address`), KEY `period` (`timeFrom`,`timeTo`), KEY `subscriber` (`subscriberId`) ) AUTO_INCREMENT=2");
            stmt.executeUpdate("INSERT INTO " + tableName + " (ipResourceId, connectionId, address, timeFrom, timeTo, subscriberId, subscriberType, subscriberTitle) SELECT c.ipResourceId, c.id, c.ipAddress, c.connectionStart, NULL, s.contractId, -1, s.contractId FROM inet_connection_" + moduleId + " as c LEFT JOIN inet_serv_" + moduleId + " as s ON s.id=c.servId WHERE c.status IN (1,2) AND s.id IS NOT NULL AND ( s.ipResourceId<=0 OR s.ipResourceId!=c.ipResourceId OR (s.addressFrom!=c.ipAddress AND (s.addressTo IS NULL OR (s.addressFrom>c.ipAddress OR s.addressTo<c.ipAddress)) ) )");
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }

    private void move(Connection con, int moduleId, String coreTableName) throws SQLException {
        int num = 0;
        int count = 0;
        HashMap<String, PreparedStatement> map = new HashMap<String, PreparedStatement>();
        PreparedStatement deletePs = con.prepareStatement("DELETE FROM " + coreTableName + " WHERE id=?");
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT id, timeFrom FROM " + coreTableName + " WHERE timeTo IS NOT NULL ORDER BY id DESC");
        while (rs.next()) {
            PreparedStatement ps;
            if (num++ == 0) continue;
            long id = rs.getLong(1);
            Date timeFrom = TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp(2));
            String tableName = ServerUtils.getModuleMonthTableName("inv_ip_resource_subscription_dyn", timeFrom, moduleId);
            if (!ServerUtils.tableExists(con, tableName)) {
                IpResourceDynSubscriptionDao.createTable(con, tableName);
                con.commit();
            }
            if ((ps = (PreparedStatement)map.get(tableName)) == null) {
                ps = con.prepareStatement("INSERT INTO " + tableName + " (ipResourceId, address, timeFrom, timeTo, subscriberId, subscriberType, subscriberTitle) SELECT ipResourceId, address, timeFrom, timeTo, subscriberId, subscriberType, subscriberTitle FROM " + coreTableName + " WHERE id=?");
                map.put(tableName, ps);
            }
            ps.setLong(1, id);
            if (ps.executeUpdate() > 0) {
                deletePs.setLong(1, id);
                deletePs.executeUpdate();
            }
            con.commit();
            ++count;
            Thread.yield();
        }
        rs.close();
        this.getLogger().info("Moved " + count + " old IP-resource subscription records");
        stmt.close();
        deletePs.close();
        for (PreparedStatement ps : map.values()) {
            ps.close();
        }
    }
}

