/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.bean.IpAddr;
import ru.bitel.bgbilling.modules.dialup.server.bean.LoginIpManager;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class StaticAddressMonitor
extends Thread {
    private static final Logger log = LogManager.getLogger();
    private volatile Map<Integer, List<IpAddr>> ipAddrMap;
    public volatile Set<Long> currentStaticAddressSet;
    private final DialUpRadiusProcessor processor;
    private final int moduleId;

    public StaticAddressMonitor(DialUpRadiusProcessor processor, int moduleId) {
        this.processor = processor;
        this.moduleId = moduleId;
        this.load();
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    GregorianCalendar nextDay = new GregorianCalendar();
                    ((Calendar)nextDay).add(6, 1);
                    TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)nextDay);
                    nextDay.set(13, 10);
                    StaticAddressMonitor.sleep(nextDay.getTimeInMillis() - System.currentTimeMillis());
                    Set<Long> prevAddressSet = this.currentStaticAddressSet;
                    this.load();
                    HashSet<Long> newStaticAddressSet = new HashSet<Long>(CollectionUtils.subtract(this.currentStaticAddressSet, prevAddressSet));
                    this.killSessionWithAddresses(newStaticAddressSet);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void load() {
        log.info("Reload static addresses..");
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            this.ipAddrMap = new LoginIpManager(con, this.moduleId).getRealtimeAddressMap();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        this.currentStaticAddressSet = this.getActiveAddressSet(this.ipAddrMap, new Date());
    }

    public List<Long> getActiveAddressList(int loginId, Date date, String realm) {
        ArrayList<Long> result = new ArrayList<Long>();
        this.loadActiveAddresses(loginId, date, realm, result);
        return result;
    }

    public void addrSetChanged(int loginId, List<IpAddr> newAddrList) {
        Date curdate = new Date();
        Set<Long> oldAddrSet = this.getActiveAddressSet(loginId, curdate, null);
        this.ipAddrMap.put(loginId, newAddrList);
        Set<Long> newAddrSet = this.getActiveAddressSet(loginId, curdate, null);
        this.processAddressSetChange(oldAddrSet, newAddrSet);
        this.currentStaticAddressSet = this.getActiveAddressSet(this.ipAddrMap, curdate);
    }

    private void processAddressSetChange(Set<Long> oldAddrSet, Set<Long> newAddrSet) {
        Collection newStaticAddressSet = CollectionUtils.subtract(newAddrSet, oldAddrSet);
        this.killSessionWithAddresses(new HashSet<Long>(newStaticAddressSet));
    }

    private void killSessionWithAddresses(final Set<Long> newStaticAddressSet) {
        log.info("Killing sessions with addresses: " + Utils.toString(newStaticAddressSet));
        if (newStaticAddressSet.size() > 0) {
            this.processor.processConnections(new DialUpRadiusProcessor.ConnectionIterator(){

                public boolean processConnection(DialUpNas nas, DialUpNasConnection con) {
                    NasConnection.Status status = con.getStatus();
                    if (status == NasConnection.Status.waiting || status == NasConnection.Status.stopped) {
                        return true;
                    }
                    if (newStaticAddressSet.contains(((DialUpSessionRealtime)con.getSession()).getIpAddress())) {
                        con.kill(nas);
                    }
                    return true;
                }
            });
        }
    }

    private Set<Long> getActiveAddressSet(Map<Integer, List<IpAddr>> addrMap, Date date) {
        HashSet<Long> result = new HashSet<Long>(addrMap.size() * 2);
        for (List<IpAddr> addrList : addrMap.values()) {
            result.addAll(this.getActiveAddressSet(addrList, date, null));
        }
        return result;
    }

    private Set<Long> getActiveAddressSet(int loginId, Date date, String realm) {
        HashSet<Long> result = new HashSet<Long>();
        this.loadActiveAddresses(loginId, date, realm, result);
        return result;
    }

    private void loadActiveAddresses(int loginId, Date date, String realm, Collection<Long> result) {
        List<IpAddr> addrList = this.ipAddrMap.get(loginId);
        if (addrList != null) {
            result.addAll(this.getActiveAddressSet(addrList, date, realm));
        }
    }

    private Set<Long> getActiveAddressSet(List<IpAddr> addrList, Date date, String realm) {
        HashSet<Long> result = new HashSet<Long>(addrList.size());
        for (IpAddr addr : addrList) {
            if (!TimeUtils.dateInRange((Date)date, (Date)addr.date1, (Date)addr.date2) || realm != null && !Utils.isBlankString((String)addr.realm) && !realm.equals(addr.realm)) continue;
            result.add(addr.ipAddr);
        }
        return result;
    }
}

