/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.client.load;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.fias.client.load.LoadManager;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.House;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasHouseService;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

public class LoadPanelHouse
extends JPanel {
    private JList<House> houseCompare = new JList();
    private BGTextField oldHouseTitle = new BGTextField();
    private BGButton commitHouse = null;
    private BGButton ignoreHouse = null;
    private House oldHouse = null;
    private LoadManager parentPanel;
    private JCheckBox addHouse = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0432\u0441\u0435 \u0434\u043e\u043c\u0430");

    public LoadPanelHouse(LoadManager parentPanel) {
        this.parentPanel = parentPanel;
        this.oldHouseTitle = new BGTextField();
        this.oldHouseTitle.setEditable(false);
        this.houseCompare = new JList();
        this.houseCompare.setModel(new DefaultListModel());
        this.houseCompare.setSelectionMode(0);
        this.commitHouse = new BGButton("\u041f\u0440\u0438\u043d\u044f\u0442\u044c \u0434\u043e\u043c");
        this.commitHouse.setActionCommand("commit");
        this.commitHouse.addActionListener(e -> this.netxHouse(e));
        this.ignoreHouse = new BGButton("\u041f\u0440\u043e\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u0434\u043e\u043c");
        this.ignoreHouse.setActionCommand("ignore");
        this.ignoreHouse.addActionListener(e -> this.netxHouse(e));
        BGButton startHouse = new BGButton("\u0421\u0442\u0430\u0440\u0442");
        startHouse.setActionCommand("start");
        startHouse.addActionListener(e -> {
            try {
                this.getNextHouse(null, true);
            }
            catch (BGMessageException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        JScrollPane scrollPanel = new JScrollPane(this.houseCompare);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.addHouse, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)startHouse, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.commitHouse, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.oldHouseTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)scrollPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.ignoreHouse, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void getNextHouse(House house, boolean start) throws BGMessageException, BGException {
        List houseList;
        while (true) {
            this.oldHouseTitle.setText("\u0418\u0434\u0435\u0442 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430....");
            this.houseCompare.setListData((House[])new House[0]);
            Result result = ((FiasHouseService)((ClientContext)this.parentPanel.getContext()).getPort(FiasHouseService.class)).startHouseSync(house, start, this.addHouse.isSelected());
            if (Utils.maskNull((String)((String)result.getAttribute("endOfStreet"))).equals("true")) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u0441\u0435 \u0434\u043e\u043c\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u044b ", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                return;
            }
            houseList = result.getList();
            this.oldHouse = (House)result.getAttribute("house");
            if (this.oldHouse != null) break;
            house = null;
            start = true;
        }
        start = false;
        if (houseList.size() != 0) {
            this.oldHouseTitle.setText(this.oldHouse.getBGTitle());
            this.houseCompare.setListData(new Vector(houseList));
            this.houseCompare.setSelectedIndex(0);
        } else if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043c " + this.oldHouse.getBGTitle() + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0424\u0418\u0410\u0421", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1) == 1) {
            this.getNextHouse(null, false);
        } else {
            this.ignoreHouse.doClick();
        }
    }

    private void netxHouse(ActionEvent actionEvent) {
        try {
            if (actionEvent.getActionCommand().equals("ignore")) {
                this.oldHouse.setHousenum("-1");
                this.oldHouse.setBuildnum("-1");
                this.oldHouse.setHouseguid("-1");
                this.oldHouse.setAoguid("-1");
                this.oldHouse.setStrucnum("-1");
            } else {
                House newHouse = this.houseCompare.getSelectedValue();
                if (newHouse == null) {
                    JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u0434\u043e\u043c\u0430 " + this.oldHouse.getBGTitle() + " ", "\u041f\u0440\u0435\u0434\u0443\u043f\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435", 1);
                    return;
                }
                this.oldHouse.setHouse(newHouse);
            }
            this.getNextHouse(this.oldHouse, false);
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }
}

