/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.server.datalog;

import java.io.IOException;
import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.base.server.datalog.BGDataLog;
import ru.bitel.bgbilling.kernel.base.server.datalog.DataLogWriter;

public class BGDataLogWriter<D extends BGDataLog<D>>
extends DataLogWriter<D> {
    protected final int chunkSize;
    protected final boolean compressed;
    protected final int dataLogId;
    protected int currentChunkId = 0;
    private final boolean writeIndex;
    private final ByteBuffer indexBuffer = ByteBuffer.allocate(12);
    protected int lastDataLength = 0;
    private static final byte[] nill = new byte[512];

    protected BGDataLogWriter(D dataLog) {
        super(dataLog, null);
        this.chunkSize = ((BGDataLog)dataLog).chunkSize;
        this.compressed = ((BGDataLog)dataLog).compressed;
        this.dataLogId = ((BGDataLog)dataLog).id;
        boolean bl = this.writeIndex = ((BGDataLog)dataLog).dataFileChannel != null;
        if (this.chunkSize > 0) {
            this.nextChunk();
        }
    }

    @Override
    protected ByteBuffer createBuffer(D dataLog, ByteBuffer readBuffer) {
        ByteBuffer buffer = ((BGDataLog)dataLog).compressed ? ByteBuffer.allocate(((BGDataLog)dataLog).writeBufferSize) : ByteBuffer.allocateDirect(((BGDataLog)dataLog).writeBufferSize);
        return buffer;
    }

    protected void nextChunk() {
        this.currentChunkId = ((BGDataLog)this.dataLog).chunkIdSequence.incrementAndGet();
        this.writeChunkHeader();
    }

    protected void writeChunkHeader() {
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(0);
        this.writeBuffer.putInt(this.chunkSize);
    }

    @Override
    public void flush() throws IOException {
        if (this.chunkSize > 0) {
            int i;
            int length = this.writeBuffer.position() - 16;
            this.writeBuffer.putInt(0, length);
            this.writeBuffer.putInt(4, this.currentChunkId);
            this.lastDataLength = length;
            for (int remaining = this.writeBuffer.remaining(); remaining > 0; remaining -= i) {
                i = Math.min(nill.length, remaining);
                this.writeBuffer.put(nill, 0, i);
            }
            this.writeBuffer(this.writeBuffer);
            if (this.writeIndex) {
                int chunkId = this.currentChunkId;
                long position = ((BGDataLog)this.dataLog).fileChannelPosition;
                this.indexBuffer.putInt(0, chunkId);
                this.indexBuffer.putLong(4, position);
                this.indexBuffer.rewind();
                ((BGDataLog)this.dataLog).fileChannel.write(this.indexBuffer);
            }
        } else {
            this.writeBuffer(this.writeBuffer);
        }
    }

    public void writeRecord(ByteBuffer byteBuffer, long time, int[] positionArray) throws IOException {
        int position;
        assert (this.writeBuffer.capacity() >= byteBuffer.remaining());
        if (this.writeBuffer.remaining() >= byteBuffer.remaining() + 8) {
            position = this.writeBuffer.position();
            this.writeBuffer.putLong(time);
            this.writeBuffer.put(byteBuffer);
        } else {
            this.flush();
            if (this.chunkSize > 0) {
                this.nextChunk();
            }
            position = this.writeBuffer.position();
            this.writeBuffer.putLong(time);
            this.writeBuffer.put(byteBuffer);
        }
        positionArray[0] = this.dataLogId;
        positionArray[1] = this.currentChunkId;
        positionArray[2] = position;
    }
}

