package ru.bitel.bgbilling.modules.inet.dyn.ip.handler;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServTypeIPMode;
import ru.bitel.bgbilling.modules.inet.server.ip.AbstractInetServIpHandler;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpData;
import ru.bitel.bgbilling.modules.inet.server.ip.InetServIpHandler;

public class SimpleIPv6Handler
    extends AbstractInetServIpHandler
    implements InetServIpHandler
{
    @Override
    public void checkAddress( InetServ inetServ, InetServType servType )
        throws BGMessageException
    {
        // проверка на ввод Framed-IPv6-Address
        // if ( inetServ.getFramedIPv6Address() == null )
        // {
        //      throw new BGMessageException( "Не указан Framed-IPv6-Address" );
        // }
        InetServTypeIPMode iPv6Mode = getIPv6Mode( servType );
        if ( iPv6Mode.isSelectStatic() && !iPv6Mode.isSelectNo() )
        {
            // проверка на ввод Framed-IPv6-Prefix
            if ( inetServ.getFramedIPv6Prefix() == null )
            {
                throw new BGMessageException( "Не указан Framed-IPv6-Prefix" );
            }

            // проверка на ввод Delegated-IPv6-Prefix
            if ( inetServ.getDelegatedIPv6Prefix() == null )
            {
                throw new BGMessageException( "Не указан Delegated-IPv6-Prefix" );
            }
        }
    }
    
    @Override
    public void setAddress( InetServ newInetServ, InetServType servType, InetServ oldInetServ, int subscriberId, String subscriberTitle )
        throws BGException
    {
    	try
    	{
            // FramedIPv6Prefix
            subscriptionFramedIPv6Prefix( oldInetServ, newInetServ, subscriberId, subscriberTitle );
            // DelegatedIPv6Prefix
            subscriptionDelegatedIPv6Prefix( oldInetServ, newInetServ, subscriberId, subscriberTitle );
    	}
		catch ( Exception ex )
		{
			throw new BGException( ex );
		}
    }
    
    @Override
    public boolean setRadiusIp( InetServIpData inetServIpData, RadiusPacket request, RadiusPacket response )
    {
        InetServ inetServ = inetServIpData.getInetServ();
        RadiusListenerWorker<?> radiusListenerWorker = inetServIpData.getRadiusListenerWorker();
        
        // установка Framed-IPv6-Address
//        final byte[] framedAddress = inetServ.getFramedIPv6Address();
//        if ( framedAddress != null )
//        {
//            setFramedIPAddress( radiusListenerWorker, response, inetServ.getFramedIPv6AddressResourceId(), framedAddress );
//        }

        // установка Framed-IPv6-Prefix
        final byte[] framedPrefix = inetServ.getFramedIPv6Prefix();
        if ( framedPrefix != null )
        {
            setFramedIPv6Prefix( radiusListenerWorker, response, inetServ.getFramedIPv6PrefixResourceId(), framedPrefix, inetServ.getFramedIPv6PrefixLength() );
        }

        // установка Delegated-IPv6-Prefix
        final byte[] delegatedPrefix = inetServ.getDelegatedIPv6Prefix();
        if ( delegatedPrefix != null )
        {
            setDelegatedIPv6Prefix( radiusListenerWorker, response, inetServ.getDelegatedIPv6PrefixResourceId(), delegatedPrefix, inetServ.getDelegatedIPv6PrefixLength() );
        }

        return true;
    }
}
