/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;

public class ContractStatusList2
extends AbstractPeriodItemSet<StatusPeriod> {
    public ContractStatusList2(List<ContractStatus> periodList, Calendar utilCalendar) {
        super(StatusPeriod.class, (AbstractPeriodItemSet.PeriodItem[])ContractStatusList2.convert(periodList, utilCalendar));
    }

    private static StatusPeriod[] convert(List<ContractStatus> periodList, Calendar utilCalendar) {
        int size = periodList.size();
        StatusPeriod[] result = new StatusPeriod[size];
        for (int i = 0; i < size; ++i) {
            ContractStatus period = periodList.get(i);
            result[i] = new StatusPeriod(period.getId(), TimeUtils.convertDateToMillisFrom((Calendar)utilCalendar, (Date)period.getDateFrom()), TimeUtils.convertDateToMillisTo((Calendar)utilCalendar, (Date)period.getDateTo()), period.getStatus());
        }
        return result;
    }

    private ContractStatusList2(StatusPeriod[] entries) {
        super(StatusPeriod.class, (AbstractPeriodItemSet.PeriodItem[])entries);
    }

    protected boolean isCoincide(StatusPeriod item, StatusPeriod other) {
        return other.id == item.id;
    }

    public ContractStatusList2 update(int id, long millisFrom, long millisTo, int status) {
        return new ContractStatusList2((StatusPeriod[])super.update((AbstractPeriodItemSet.PeriodItem)new StatusPeriod(id, millisFrom, millisTo, status)));
    }

    public ContractStatusList2 remove(int id, long millisFrom, long millisTo, int status) {
        return new ContractStatusList2((StatusPeriod[])super.remove((AbstractPeriodItemSet.PeriodItem)new StatusPeriod(id, millisFrom, millisTo, status)));
    }

    static class StatusPeriod
    extends AbstractPeriodItemSet.PeriodItem {
        public final int status;

        public StatusPeriod(int id, long timeFrom, long timeTo, int status) {
            super(id, timeFrom, timeTo);
            this.status = status;
        }
    }
}

