/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.renderer;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class DatetimeTableCellRenderer
extends DefaultTableCellRenderer {
    public static final String DATE_FORMAT_DDMMYYYY = "dd.MM.yyyy";
    public static final String DATE_FORMAT_DDMMYYYY_HHMMSS = "dd.MM.yyyy HH:mm:ss";
    private DateFormat formatterDateTime = null;
    private DateTimeFormatter dateTimeFormatter = null;

    public DatetimeTableCellRenderer() {
        this(DATE_FORMAT_DDMMYYYY_HHMMSS, 0);
    }

    public DatetimeTableCellRenderer(String pattern) {
        this(pattern, 0);
    }

    public DatetimeTableCellRenderer(String pattern, int horizontalAlignment) {
        this.formatterDateTime = new SimpleDateFormat(pattern);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        this.setHorizontalAlignment(horizontalAlignment);
    }

    public static TableCellRenderer DEFAULT_DDMMYYYY_HHMMSS() {
        return new DatetimeTableCellRenderer();
    }

    public static DatetimeTableCellRenderer DEFAULT_DDMMYYYY_HHMMSS_LEFT() {
        return new DatetimeTableCellRenderer(DATE_FORMAT_DDMMYYYY_HHMMSS, 2);
    }

    public static DatetimeTableCellRenderer DEFAULT_DDMMYYYY() {
        return new DatetimeTableCellRenderer(DATE_FORMAT_DDMMYYYY);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Date) {
            this.setText(value == null ? "" : this.formatterDateTime.format(value));
        } else if (value instanceof LocalDate) {
            this.setText(value == null ? "" : ((LocalDate)value).format(this.dateTimeFormatter));
        } else if (value instanceof LocalDateTime) {
            this.setText(value == null ? "" : ((LocalDateTime)value).format(this.dateTimeFormatter));
        } else {
            super.setValue(value);
        }
    }
}

