/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractGroup;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractGroupDao;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService")
public class ContractGroupServiceImpl
extends AbstractService
implements ContractGroupService {
    private Directory<ContractGroup> groupDirectory;

    @PostConstruct
    void init() throws Exception {
        this.groupDirectory = this.context.getDirectory(ContractGroup.class, 0);
    }

    @Override
    public List<ContractGroup> contractGroupList(boolean all, String order) throws Exception {
        if (all) {
            return this.groupDirectory.list();
        }
        try (ContractGroupDao groupDao = new ContractGroupDao(this.getConnection());){
            List<ContractGroup> list = groupDao.list(all, order);
            return list;
        }
    }

    @Override
    public void contractGroupUpdate(ContractGroup contractGroup) throws Exception {
        this.groupDirectory.update(contractGroup);
    }

    @Override
    public ContractGroup contractGroupGet(int id) throws Exception {
        return this.groupDirectory.get(id);
    }

    @Override
    public void contractGroupDelete(Set<Integer> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            throw new BGIllegalArgumentException();
        }
        try (ContractGroupDao groupDao = new ContractGroupDao(this.getConnection());){
            for (Integer id : ids) {
                groupDao.delete(id);
            }
        }
    }
}

