/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.server.bean.pattern;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.UnsupportedFileFormatException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.ODFNotOfficeXmlFileException;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEm;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextEffect;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTUnderline;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.AbstractDocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentPatternUtils;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentProcessor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.TableDataExtractor;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.TableDataExtractorFactory;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class DocxDocumentProcessor
extends AbstractDocumentProcessor
implements DocumentProcessor {
    private List<String> columnNamesAndOrder = new ArrayList<String>();

    public DocxDocumentProcessor(Connection con, Document document, DocumentPattern pattern, Map<String, Object> varData, Map<String, List<Map<String, String>>> tableData) {
        this.tableData = tableData;
        this.variableData = varData;
        this.document = document;
        this.con = con;
        this.pattern = pattern;
    }

    @Override
    public File process(FileInputStream patternFile) throws BGException {
        File tempDocumentFile;
        block26: {
            tempDocumentFile = new File(Setup.getSetup().getTempDirPath() + "tmp" + this.document.getContractId() + ".docx");
            try (XWPFDocument doc = new XWPFDocument((InputStream)patternFile);){
                List tableList;
                this.getLogger().debug("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 DOCX-\u0448\u0430\u0431\u043b\u043e\u043d\u0430");
                List paragraphList = doc.getParagraphs();
                this.getLogger().debug("\t\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u0430\u0431\u0437\u0430\u0446\u0435\u0432 ({} \u0448\u0442)", (Object)paragraphList.size());
                this.iterateOverParagraphList(paragraphList);
                List footerList = doc.getFooterList();
                this.getLogger().debug("\t\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043a\u043e\u043b\u043e\u043d\u0442\u0438\u0442\u0443\u043b\u043e\u0432 ({} \u0448\u0442)", (Object)footerList.size());
                for (Object xwpfFooter : footerList) {
                    paragraphList = xwpfFooter.getListParagraph();
                    this.iterateOverParagraphList(paragraphList);
                    tableList = xwpfFooter.getTables();
                    this.processDocxTables(tableList);
                }
                List headerList = doc.getHeaderList();
                for (XWPFHeader xwpfHeader : headerList) {
                    paragraphList = xwpfHeader.getListParagraph();
                    this.iterateOverParagraphList(paragraphList);
                    tableList = xwpfHeader.getTables();
                    this.processDocxTables(tableList);
                }
                List patternTableList = this.pattern.getTableList();
                List documentTableList = doc.getTables();
                this.getLogger().debug("\t\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0442\u0430\u0431\u043b\u0438\u0446 ({} \u0448\u0442)", (Object)patternTableList.size());
                for (DocumentTable docTable : patternTableList) {
                    XWPFTable xwpfTable = this.getTableByIdentifier(documentTableList, docTable.getIdentifier());
                    if (xwpfTable == null) continue;
                    this.columnNamesAndOrder.clear();
                    DocumentTableExtractMethod method = docTable.getExtractMethod();
                    List<Object> rowList = (ArrayList)this.tableData.get(docTable.getIdentifier());
                    if (rowList == null) {
                        rowList = new ArrayList();
                    }
                    switch (method) {
                        case SQL: {
                            String query = DocumentPatternUtils.insertPatternPart(docTable.getValue(), "cid", String.valueOf(this.document.getContractId()));
                            rowList = this.runTableSQL(query);
                            break;
                        }
                        case DYNCLASS: {
                            TableDataExtractor extractor = TableDataExtractorFactory.getTableDataExtractor(docTable.getValue());
                            if (extractor == null) break;
                            rowList = extractor.extractData(this.con, this.document.getContractId(), rowList);
                            break;
                        }
                    }
                    if (rowList == null || rowList.size() <= 0) continue;
                    int patternRowPosition = xwpfTable.getRows().size() - 1;
                    XWPFTableRow patternRow = (XWPFTableRow)xwpfTable.getRows().get(patternRowPosition);
                    List patternRowCells = patternRow.getTableCells();
                    for (int i = 0; i < patternRowCells.size(); ++i) {
                        XWPFTableCell xWPFTableCell = (XWPFTableCell)patternRowCells.get(i);
                        if (Utils.notBlankString((String)xWPFTableCell.getText())) {
                            this.columnNamesAndOrder.add(xWPFTableCell.getText());
                            continue;
                        }
                        this.columnNamesAndOrder.add("col" + (i + 1));
                    }
                    for (Map map : rowList) {
                        XWPFTableRow row = xwpfTable.createRow();
                        for (int i = 0; i < this.columnNamesAndOrder.size(); ++i) {
                            XWPFTableCell cell = row.getCell(i);
                            String value = (String)map.get(this.columnNamesAndOrder.get(i));
                            CTText textElement = ((XWPFParagraph)cell.getParagraphs().get(0)).createRun().getCTR().addNewT();
                            if (value == null) continue;
                            textElement.setStringValue(value);
                        }
                        this.copyTableRowStyle(patternRow, row);
                    }
                    xwpfTable.removeRow(patternRowPosition);
                }
                this.getLogger().debug("\t\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0441\u0442\u0430\u043b\u044c\u043d\u044b\u0445 \u0442\u0430\u0431\u043b\u0438\u0446 ({} \u0448\u0442)", (Object)documentTableList.size());
                this.processDocxTables(documentTableList);
                if (!tempDocumentFile.createNewFile()) break block26;
                try (FileOutputStream fos = new FileOutputStream(tempDocumentFile);){
                    doc.write((OutputStream)fos);
                }
                this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b {}", (Object)tempDocumentFile.getName());
            }
            catch (ODFNotOfficeXmlFileException ex) {
                throw new BGException("\u0424\u043e\u0440\u043c\u0430\u0442 \u0444\u0430\u0439\u043b\u0430 ODF, \u0430 \u043d\u0435 docx: " + ex.toString(), (Throwable)ex);
            }
            catch (UnsupportedFileFormatException ex) {
                throw new BGException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u0439 \u0444\u043e\u0440\u043c\u0430\u0442: " + ex.toString(), (Throwable)ex);
            }
            catch (IOException | InvalidFormatException ex) {
                throw new BGException(ex);
            }
        }
        return tempDocumentFile;
    }

    private void processDocxTables(List<XWPFTable> tableList) throws IOException, InvalidFormatException {
        for (XWPFTable table : tableList) {
            List tableRows = table.getRows();
            for (XWPFTableRow xwpfTableRow : tableRows) {
                List rowCells = xwpfTableRow.getTableCells();
                for (XWPFTableCell xwpfTableCell : rowCells) {
                    List paragraphList = xwpfTableCell.getParagraphs();
                    this.iterateOverParagraphList(paragraphList);
                }
            }
        }
    }

    private XWPFTable getTableByIdentifier(List<XWPFTable> tableList, String id) {
        for (XWPFTable xwpfTable : tableList) {
            List tableRows = xwpfTable.getRows();
            for (XWPFTableRow xwpfTableRow : tableRows) {
                List rowCells = xwpfTableRow.getTableCells();
                for (XWPFTableCell xwpfTableCell : rowCells) {
                    if (!xwpfTableCell.getText().contains("{" + id + "}")) continue;
                    List paragraphList = xwpfTableCell.getParagraphs();
                    for (XWPFParagraph xwpfParagraph : paragraphList) {
                        String paragraphText = (xwpfParagraph = DocxDocumentProcessor.joinSomeRun(xwpfParagraph)).getText();
                        if (Utils.isBlankString((String)paragraphText)) continue;
                        List runList = xwpfParagraph.getRuns();
                        for (int i = runList.size() - 1; i >= 0; --i) {
                            XWPFRun run = (XWPFRun)runList.get(i);
                            List tElems = run.getCTR().getTList();
                            for (CTText ctText : tElems) {
                                String tText = ctText.getStringValue();
                                if (!tText.contains("{" + id + "}")) continue;
                                ctText.setStringValue(tText.replace("{" + id + "}", ""));
                                return xwpfTable;
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private List<Map<String, String>> runTableSQL(String query) throws BGException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            int columnCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                HashMap<CallSite, String> rowList = new HashMap<CallSite, String>();
                for (int i = 0; i < columnCount; ++i) {
                    rowList.put((CallSite)((Object)("col" + (i + 1))), rs.getString(i + 1));
                }
                result.add(rowList);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    private void copyTableRowStyle(XWPFTableRow fromRow, XWPFTableRow toRow) {
        int cellCount = fromRow.getTableCells().size();
        for (int i = 0; i < cellCount; ++i) {
            XWPFTableCell newRowCell = toRow.getCell(i);
            XWPFTableCell prevRowCell = fromRow.getCell(i);
            this.copyTableCellProperties(prevRowCell, newRowCell);
            this.copyTableCellTextStyles(prevRowCell, newRowCell);
            this.copyTableCellTextTracings(prevRowCell, newRowCell);
        }
    }

    private void copyTableCellTextTracings(XWPFTableCell prevCell, XWPFTableCell newCell) {
        CTRPr rpr;
        CTR ctr;
        XWPFRun lastRun;
        XWPFParagraph lastParagraph;
        CTTc cttc = prevCell.getCTTc();
        if (cttc != null && (lastParagraph = (XWPFParagraph)prevCell.getParagraphs().get(prevCell.getParagraphs().size() - 1)) != null && (lastRun = (XWPFRun)lastParagraph.getRuns().get(lastParagraph.getRuns().size() - 1)) != null && (ctr = lastRun.getCTR()) != null && (rpr = ctr.getRPr()) != null) {
            CTShd[] shd;
            CTOnOff[] shadow;
            CTTextEffect[] effect;
            CTColor[] color;
            CTOnOff[] cs;
            CTEm[] em;
            CTOnOff[] outline;
            CTUnderline[] u;
            CTOnOff[] strike;
            CTFonts[] rFonts;
            CTLanguage[] lang;
            CTOnOff[] caps;
            CTHpsMeasure[] kern;
            CTHpsMeasure[] szCs;
            CTHpsMeasure[] sz;
            CTOnOff[] emboss;
            CTOnOff[] bCs;
            CTOnOff[] b;
            CTOnOff[] iCs;
            CTRPr newCellRpr = ((XWPFRun)((XWPFParagraph)newCell.getParagraphs().get(0)).getRuns().get(0)).getCTR().addNewRPr();
            CTOnOff[] i = rpr.getIArray();
            if (i != null) {
                newCellRpr.setIArray(i);
            }
            if ((iCs = rpr.getICsArray()) != null) {
                newCellRpr.setICsArray(iCs);
            }
            if ((b = rpr.getBArray()) != null) {
                newCellRpr.setBArray(b);
            }
            if ((bCs = rpr.getBCsArray()) != null) {
                newCellRpr.setBCsArray(bCs);
            }
            if ((emboss = rpr.getEmbossArray()) != null) {
                newCellRpr.setEmbossArray(emboss);
            }
            if ((sz = rpr.getSzArray()) != null) {
                newCellRpr.setSzArray(sz);
            }
            if ((szCs = rpr.getSzCsArray()) != null) {
                newCellRpr.setSzCsArray(szCs);
            }
            if ((kern = rpr.getKernArray()) != null) {
                newCellRpr.setKernArray(kern);
            }
            if ((caps = rpr.getCapsArray()) != null) {
                newCellRpr.setCapsArray(caps);
            }
            if ((lang = rpr.getLangArray()) != null) {
                newCellRpr.setLangArray(lang);
            }
            if ((rFonts = rpr.getRFontsArray()) != null) {
                newCellRpr.setRFontsArray(rFonts);
            }
            if ((strike = rpr.getStrikeArray()) != null) {
                newCellRpr.setStrikeArray(strike);
            }
            if ((u = rpr.getUArray()) != null) {
                newCellRpr.setUArray(u);
            }
            if ((outline = rpr.getOutlineArray()) != null) {
                newCellRpr.setOutlineArray(outline);
            }
            if ((em = rpr.getEmArray()) != null) {
                newCellRpr.setEmArray(em);
            }
            if ((cs = rpr.getCsArray()) != null) {
                newCellRpr.setCsArray(cs);
            }
            if ((color = rpr.getColorArray()) != null) {
                newCellRpr.setColorArray(color);
            }
            if ((effect = rpr.getEffectArray()) != null) {
                newCellRpr.setEffectArray(effect);
            }
            if ((shadow = rpr.getShadowArray()) != null) {
                newCellRpr.setShadowArray(shadow);
            }
            if ((shd = rpr.getShdArray()) != null) {
                newCellRpr.setShdArray(shd);
            }
        }
    }

    private void copyTableCellTextStyles(XWPFTableCell prevCell, XWPFTableCell newCell) {
        CTP p;
        CTPPr ppr;
        XWPFParagraph lastParagraph;
        CTTc cttc = prevCell.getCTTc();
        if (cttc != null && (lastParagraph = (XWPFParagraph)prevCell.getParagraphs().get(prevCell.getParagraphs().size() - 1)) != null && (ppr = (p = lastParagraph.getCTP()).getPPr()) != null) {
            CTInd ind;
            CTOnOff contextualSpacing;
            CTSpacing spacing;
            CTShd shd;
            CTString style;
            CTPPr newCellPpr = ((XWPFParagraph)newCell.getParagraphs().get(0)).getCTP().addNewPPr();
            CTJc jc = ppr.getJc();
            if (jc != null) {
                newCellPpr.addNewJc().setVal(jc.getVal());
            }
            if ((style = ppr.getPStyle()) != null) {
                newCellPpr.addNewPStyle().setVal(style.getVal());
            }
            if ((shd = ppr.getShd()) != null) {
                newCellPpr.addNewShd().setVal(shd.getVal());
                newCellPpr.getShd().setFill(shd.getFill());
            }
            if ((spacing = ppr.getSpacing()) != null) {
                newCellPpr.addNewSpacing().setAfter(spacing.getAfter());
                newCellPpr.getSpacing().setBefore(spacing.getBefore());
            }
            if ((contextualSpacing = ppr.getContextualSpacing()) != null) {
                newCellPpr.setContextualSpacing(contextualSpacing);
            }
            if ((ind = ppr.getInd()) != null) {
                newCellPpr.setInd(ind);
            }
        }
    }

    private void copyTableCellProperties(XWPFTableCell prevCell, XWPFTableCell newCell) {
        CTTcPr tcPr;
        CTTc cttc = prevCell.getCTTc();
        if (cttc != null && (tcPr = cttc.getTcPr()) != null) {
            CTVMerge prevVMerge;
            CTVerticalJc prevVAlign;
            CTTcMar prevMars;
            CTTcBorders prevCellBorders = tcPr.getTcBorders();
            if (prevCellBorders != null) {
                CTTcBorders newCellBorders = newCell.getCTTc().addNewTcPr().addNewTcBorders();
                if (prevCellBorders.getRight() != null) {
                    newCellBorders.setRight(prevCellBorders.getRight());
                }
                if (prevCellBorders.getLeft() != null) {
                    newCellBorders.setLeft(prevCellBorders.getLeft());
                }
                if (prevCellBorders.getTop() != null) {
                    newCellBorders.setTop(prevCellBorders.getTop());
                }
                if (prevCellBorders.getBottom() != null) {
                    newCellBorders.setBottom(prevCellBorders.getBottom());
                }
            }
            if ((prevMars = tcPr.getTcMar()) != null) {
                CTTcMar newCellMars = newCell.getCTTc().getTcPr().addNewTcMar();
                if (prevMars.getTop() != null) {
                    newCellMars.setTop(prevMars.getTop());
                }
                if (prevMars.getBottom() != null) {
                    newCellMars.setBottom(prevMars.getBottom());
                }
                if (prevMars.getLeft() != null) {
                    newCellMars.setLeft(prevMars.getLeft());
                }
                if (prevMars.getRight() != null) {
                    newCellMars.setRight(prevMars.getRight());
                }
            }
            if ((prevVAlign = tcPr.getVAlign()) != null) {
                CTVerticalJc newVAlign = newCell.getCTTc().getTcPr().addNewVAlign();
                if (prevVAlign.getVal() != null) {
                    newVAlign.setVal(prevVAlign.getVal());
                }
            }
            if ((prevVMerge = tcPr.getVMerge()) != null) {
                CTVMerge newVMerge = newCell.getCTTc().getTcPr().addNewVMerge();
                if (prevVMerge.getVal() != null) {
                    newVMerge.setVal(prevVMerge.getVal());
                }
            }
        }
    }
}

