/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action;

import bitel.billing.server.call.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;

public class ActionContractInfo
extends ActionBase {
    @Override
    public void doAction() throws Exception {
        if (this.mid <= 0 || this.cid <= 0) {
            throw new BGIllegalArgumentException();
        }
        int objectId = this.getIntParameter("object_id", 0);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        StringBuilder buf = new StringBuilder();
        HashMap<Integer, Element> ids = new HashMap<Integer, Element>();
        String query = "SELECT id, login, date1, date2, session, status, comment FROM user_login_" + this.mid + " WHERE cid=? ";
        if (objectId > 0) {
            query = query + " AND object_id=" + objectId + " ";
        }
        query = query + "ORDER BY login, date1";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, this.cid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            int id = rs.getInt(1);
            Element element = this.createElement(data, "row");
            element.setAttribute("f0", String.valueOf(id));
            element.setAttribute("f1", rs.getString(2));
            element.setAttribute("f2", "");
            element.setAttribute("f3", TimeUtils.formatPeriod((Date)rs.getDate(3), (Date)rs.getDate(4)));
            element.setAttribute("f4", rs.getString(5).equals("0") ? "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : rs.getString(5));
            element.setAttribute("f5", rs.getInt(6) == 0 ? "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d" : "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d");
            element.setAttribute("f6", rs.getString(7));
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(id);
            ids.put(id, element);
        }
        rs.close();
        ps.close();
        this.getAliases(this.mid, buf, ids, "f2");
    }

    protected void getAliases(int mid, StringBuilder buf, HashMap<Integer, Element> ids, String column) throws SQLException {
        HashMap<Integer, StringBuilder> aliases = new HashMap<Integer, StringBuilder>();
        if (buf.length() > 0) {
            String query = "SELECT login_id, login_alias FROM user_alias_" + mid + " WHERE login_id IN ( " + buf.toString() + " ) ORDER BY login_alias";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Integer id = rs.getInt(1);
                buf = (StringBuilder)aliases.get(id);
                if (buf == null) {
                    buf = new StringBuilder();
                    aliases.put(id, buf);
                }
                buf.append(rs.getString(2));
                buf.append(" ");
            }
            rs.close();
            ps.close();
            for (Map.Entry e : aliases.entrySet()) {
                Integer id = (Integer)e.getKey();
                buf = (StringBuilder)e.getValue();
                Element element = ids.get(id);
                element.setAttribute(column, buf.toString().trim());
            }
        }
    }
}

