#!/bin/bash

cd ${0%${0##*/}}./..

. ./bin/setenv.sh

#JAVA_HOME=/opt/jre
#BGCASHCHECK_SERVER_DIR=/opt/BGCashcheckServer

if [ -z "$JAVA_HOME" ]; then
  echo "The JAVA_HOME environment variable is not defined"
  echo "This environment variable is needed to run this program"
  exit 1
fi

if [ -z "$BGCASHCHECK_SERVER_DIR" ]; then
  echo "The BGCASHCHECK_SERVER_DIR environment variable is not defined"
  echo "This environment variable is needed to run this program"
  exit 1
fi

if [ ! -e lib/app/kernel-server.jar ]
then
    echo "not updated?"
    exit 0
fi

PWD="$($(which pwd))"
NAME_SHORT=${PWD##*/}

APP_HOME=${BGCASHCHECK_SERVER_DIR}
CLASSPATH=${APP_HOME}:${APP_HOME}/lib/*:${APP_HOME}/lib/app/*:${APP_HOME}/lib/ext/*:${APP_HOME}/lib/custom/*
COMPAT_PARAMS="--add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util.regex=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED"
COMMON_PARAMS="-Dapp.name=$NAME_SHORT -Dnetworkaddress.cache.ttl=3600 -Djava.awt.headless=true -Djava.net.preferIPv4Stack=true ${COMPAT_PARAMS}"
LOG_PARAMS="-Dlog.dir.path=log/ -Dlog.prefix=$NAME_SHORT -Dlog4j.configurationFile=conf/log4j2.xml"
MEMORY=-Xmx256m

if [ "$1" = "start" ]; then
    nohup  ${JAVA_HOME}/bin/java ${COMMON_PARAMS} ${LOG_PARAMS} ${MEMORY} -cp ${CLASSPATH} ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer $@ > ${BGCASHCHECK_SERVER_DIR}/log/cashserver.out 2>&1 & echo $! > .run/${NAME_SHORT}.pid &
else
    #execute command
    ${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} ru.bitel.bgbilling.apps.cashcheck.frk.server.CmdTcpServer $@
fi
