/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.sms.smsaero;

import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Date;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;

public class SmsAeroV2
extends BGLogger {
    private String email;
    private String apiKey;
    private boolean SMSC_HTTP = false;

    public SmsAeroV2(String email, String apiKey) {
        this.email = email;
        this.apiKey = apiKey;
    }

    public String sendMsg(String number, String text, String sign, String callbackUrl, String callbackFormat, Date dateSend) throws IOException {
        StringBuilder url = new StringBuilder(this.SMSC_HTTP ? "http" : "https://gate.smsaero.ru/v2/sms/send?").append("number=" + URLEncoder.encode(number, "utf-8")).append("&text=" + URLEncoder.encode(text, "utf-8")).append("&sign=" + URLEncoder.encode(sign, "utf-8"));
        Optional.ofNullable(dateSend).ifPresent(a -> url.append("&dateSend=" + Long.toString(dateSend.getTime() / 1000L)));
        Optional.ofNullable(callbackUrl).ifPresent(a -> url.append("&callbackUrl=" + this.encode(callbackUrl)));
        Optional.ofNullable(callbackFormat).ifPresent(a -> url.append("&callbackFormat=" + a));
        String line = "";
        try {
            HttpClient httpClient = HttpClient.newBuilder().authenticator(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SmsAeroV2.this.email, SmsAeroV2.this.apiKey.toCharArray());
                }
            }).build();
            HttpRequest httpRequest = HttpRequest.newBuilder().GET().uri(URI.create(url.toString())).build();
            line = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        return line;
    }

    public void setUseHttp(boolean value) {
        this.SMSC_HTTP = value;
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "utf-8");
        }
        catch (Exception ex) {
            this.logError(ex);
            return "";
        }
    }
}

