/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableCellRenderer;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGScrollPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.function.Async;

public class InetOptionPanel
extends BGUPanel {
    private InetOptionTreeTablePanel model = new InetOptionTreeTablePanel();

    public InetOptionPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void jbInit() {
        BGUTreeTable table = new BGUTreeTable((BGTreeTableModel)this.model);
        table.setName("inetOption");
        this.setLayout(new GridBagLayout());
        this.add(BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)table)), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.7, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetOptionTree())));
        final HashSet cutSet = new HashSet();
        new AbstractBGUPanel.MenuAction("inetOption.cut", "\u0412\u044b\u0440\u0435\u0437\u0430\u0442\u044c", ClientUtils.getIcon((String)"cut")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                cutSet.clear();
                List selectedRows = InetOptionPanel.this.model.getSelectedRows();
                if (selectedRows == null) {
                    return;
                }
                for (InetOption d : selectedRows) {
                    cutSet.add(d.getId());
                }
            }
        };
        new AbstractBGUPanel.MenuAction("inetOption.paste", "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u044c", ClientUtils.getIcon((String)"paste")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetOption parent = (InetOption)InetOptionPanel.this.model.getSelectedRow();
                if (parent != null && cutSet.size() > 0) {
                    ((InetServService)((ClientContext)InetOptionPanel.this.getContext()).getWebService(InetServService.class)).inetOptionMove(parent.getId(), cutSet);
                    cutSet.clear();
                    InetOptionPanel.this.performAction("refresh");
                }
            }
        };
        new AbstractBGUPanel.MenuAction("inetOption.import", "\u0418\u043c\u043f\u043e\u0440\u0442", ClientUtils.getIcon((String)"import")){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                InetOptionPanel.this.model.optSelectedRow().ifPresentOrElse(option -> new InetOptionImportDialog("\u0418\u043c\u043f\u043e\u0440\u0442 \u043e\u043f\u0446\u0438\u0439", (InetOption)option).open(), () -> ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"));
            }
        };
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            InetOption current = new InetOption();
            InetOption parent = (InetOption)this.model.getSelectedRow();
            if (parent != null) {
                current.setParentId(parent.getId());
            }
            new InetOptionEditor("\u041d\u043e\u0432\u0430\u044f \u043e\u043f\u0446\u0438\u044f", current).open();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            InetOption current = (InetOption)this.model.getSelectedRow();
            if (current != null && current.getId() != 0) {
                current = ((InetServService)((ClientContext)this.getContext()).getWebService(InetServService.class)).inetOptionGet(current.getId());
                new InetOptionEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043e\u043f\u0446\u0438\u0438", current).open();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            InetOption current = (InetOption)this.model.getSelectedRow();
            if (current != null && current.getId() != 0 && BGSwingUtilites.confirmDelete((String)"\u043e\u043f\u0446\u0438\u044e", (Object)current)) {
                ((InetServService)((ClientContext)this.getContext()).getPort(InetServService.class)).inetOptionDelete(current.getId());
                this.performAction("refresh");
            }
        });
    }

    class InetOptionTreeTablePanel
    extends BGTreeTableModel<InetOption> {
        public InetOptionTreeTablePanel() {
            super(InetOptionTreeTablePanel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", InetOption.class, false);
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId(false);
        }

        public Object getValue(InetOption val, int column) throws Exception {
            switch (column) {
                case 0: {
                    return val;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class InetOptionEditor
    extends BGEditorDialog<InetOption> {
        private BGTextField title;
        private JCheckBox groupIntersection;
        private JTextArea comment;
        private BGConfigEditorPane config;

        public InetOptionEditor(String title, InetOption data) {
            super(title, (Object)data);
            this.title = new BGTextField(30);
            this.groupIntersection = new JCheckBox("\u041f\u0435\u0440\u0435\u0441\u0435\u0447\u0435\u043d\u0438\u0435 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
            this.comment = new JTextArea(7, 30);
            this.config = new BGConfigEditorPane();
        }

        public void doDialogPanel() {
            this.panel.add((Component)this.getBasePanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)this.getConfigPanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.title.setText(((InetOption)this.data).getTitle());
            this.groupIntersection.setSelected(((InetOption)this.data).isGroupIntersection());
            this.config.setText(((InetOption)this.data).getConfig());
            this.comment.setText(((InetOption)this.data).getComment());
        }

        private JPanel getBasePanel() {
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            panel.add((Component)this.groupIntersection, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getConfigPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)new BGScrollPane((Component)this.config, 400, 250), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
            return panel;
        }

        public boolean doApply() throws Exception {
            ((InetOption)this.data).setTitle(this.title.getText());
            ((InetOption)this.data).setGroupIntersection(this.groupIntersection.isSelected());
            ((InetOption)this.data).setConfig(this.config.getText());
            ((InetOption)this.data).setComment(this.comment.getText());
            int id = ((InetServService)((ClientContext)InetOptionPanel.this.getContext()).getWebService(InetServService.class)).inetOptionUpdate((InetOption)this.data);
            InetOptionPanel.this.performAction("refresh");
            InetOptionPanel.this.model.setSelectedRow(id);
            return true;
        }
    }

    class InetOptionImportDialog
    extends BGEditorDialog<InetOption> {
        private JTextArea importData;

        public InetOptionImportDialog(String title, InetOption data) {
            super(title, (Object)data);
            this.importData = new JTextArea(20, 50);
        }

        public void doDialogPanel() {
            this.importData.setMargin(new Insets(3, 3, 3, 3));
            JTextArea text = new JTextArea("<\u041e\u043f\u0446\u0438\u0438 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430, \u043f\u043e \u043e\u0434\u043d\u043e\u0439 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435:\n\u041d\u0410\u0417\u0412\u0410\u041d\u0418\u0415[<TAB>\u041f\u0410\u0420\u0410\u041c\u0415\u0422\u0420_\u041a\u041e\u041d\u0424\u0418\u0413\u0410_1[<TAB>...\u041f\u0410\u0420\u0410\u041c\u0415\u0422\u0420_\u041a\u041e\u041d\u0424\u0418\u0413\u0410_N]]", 2, 20);
            text.setMargin(new Insets(5, 5, 5, 5));
            text.setEditable(false);
            this.panel.add((Component)text, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new BGScrollPane((Component)this.importData, 800, 400), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.importData.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
                return false;
            }
            for (String optionImportData : this.importData.getText().split("\n")) {
                String[] a = optionImportData.split("\t");
                if (a.length <= 0) continue;
                InetOption inetOption = new InetOption();
                inetOption.setTitle(a[0]);
                inetOption.setComment("");
                inetOption.setParentId(((InetOption)this.data).getId());
                StringBuilder config = new StringBuilder();
                if (a.length > 1) {
                    for (int index = 1; index < a.length; ++index) {
                        if (config.length() > 0) {
                            config.append("\n");
                        }
                        config.append(a[index]);
                    }
                }
                inetOption.setConfig(config.toString());
                ((InetServService)((ClientContext)InetOptionPanel.this.getContext()).getWebService(InetServService.class)).inetOptionUpdate(inetOption);
            }
            InetOptionPanel.this.performAction("refresh");
            return true;
        }
    }
}

