/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.dynamic.common.service.DynamicCodeService;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.bgbilling.modules.botmanager.server.bots.RuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.TelegramRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.bots.VKRuntimeBot;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotDao;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotSessionsDao;
import ru.bitel.common.Utils;

public class BotManagement {
    private static final Logger logger = LogManager.getLogger();
    private int moduleId = 0;
    private final Map<String, RuntimeBot> runtimeBotMap = new HashMap<String, RuntimeBot>();
    private final Map<String, DialogProcessing> dialogProcessingClasses = new HashMap<String, DialogProcessing>();
    private static final Map<Integer, BotManagement> instanceMap = new HashMap<Integer, BotManagement>();

    public static void init(ServerContext serverContext, int moduleId) throws Exception {
        BotManagement botManagement = new BotManagement();
        botManagement.moduleId = moduleId;
        botManagement.loadBots(serverContext);
        botManagement.reloadDialogProcessing();
        instanceMap.put(moduleId, botManagement);
    }

    private void loadBots(ServerContext serverContext) throws Exception {
        this.runtimeBotMap.clear();
        try {
            BotDao botDao = new BotDao(serverContext.getConnection(), this.moduleId);
            BotSessionsDao sessionsDao = new BotSessionsDao(serverContext.getConnection(), this.moduleId);
            for (Bot bot : botDao.getBots()) {
                RuntimeBot runtimeBot2 = this.convertBotToRuntimeBot(bot);
                runtimeBot2.setBotData(botDao.getBotData(bot.getId()));
                runtimeBot2.getBotSessions().putAll(sessionsDao.getSessions(bot.getId()));
                this.runtimeBotMap.put(runtimeBot2.getToken(), runtimeBot2);
            }
        }
        catch (BGException e) {
            logger.error((Object)e);
        }
        this.runtimeBotMap.forEach((token, runtimeBot) -> {
            if (runtimeBot.getBotState() == 1) {
                runtimeBot.startBot();
            } else {
                runtimeBot.stopBot();
            }
        });
    }

    public RuntimeBot convertBotToRuntimeBot(Bot bot) throws Exception {
        return this.convertBotToRuntimeBot(bot, null);
    }

    public RuntimeBot convertBotToRuntimeBot(Bot bot, RuntimeBot runtime) throws Exception {
        if (runtime != null) {
            runtime.setBotId(bot.getId());
            runtime.setBotState(bot.getState());
            runtime.setToken(bot.getToken());
            return runtime;
        }
        RuntimeBot runtimeBot = null;
        switch (bot.getBotType()) {
            case TELEGRAM_BOT: {
                runtimeBot = new TelegramRuntimeBot(bot, this.moduleId);
                break;
            }
            case BK_BOT: {
                runtimeBot = new VKRuntimeBot(bot, this.moduleId);
            }
        }
        return runtimeBot;
    }

    public synchronized void commitUserBotData(RuntimeBot runtimeBot) throws Exception {
        new BotDao(runtimeBot.getServerContext().getConnection(), this.moduleId).updateBotData(runtimeBot.getBotId(), runtimeBot.getUserBotData());
    }

    public void reloadDialogProcessing() throws Exception {
        this.dialogProcessingClasses.clear();
        List classes = Utils.getClassList((String)"ru.bitel.bgbilling.modules.botmanager.server.bean.dialogprocessing");
        classes.removeIf(clazz -> !DialogProcessing.class.isAssignableFrom((Class<?>)clazz));
        classes.forEach(clazz -> {
            try {
                this.dialogProcessingClasses.put(clazz.getName(), (DialogProcessing)Utils.newInstance((String)clazz.getName(), DialogProcessing.class));
            }
            catch (BGException e) {
                logger.error((Object)e);
            }
        });
        this.getCustomProcessingFromDynCode().forEach(clazz -> this.dialogProcessingClasses.put(clazz.getClass().getName(), (DialogProcessing)clazz));
    }

    private List<DialogProcessing> getCustomProcessingFromDynCode() throws Exception {
        ArrayList<DialogProcessing> result = new ArrayList<DialogProcessing>();
        ServerContext serverContext = (ServerContext)ServerContext.get();
        List dynamicClasses = ((DynamicCodeService)serverContext.getService(DynamicCodeService.class, 0)).getDynamicClassesByInterface(DialogProcessing.class.getName());
        DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
        dynamicClasses.forEach(dynamicClass -> {
            try {
                DialogProcessing dialogProcessing = (DialogProcessing)dynamicClassManager.newInstance(DialogProcessing.class, dynamicClass.getClassName());
                if (dialogProcessing != null) {
                    result.add(dialogProcessing);
                }
            }
            catch (BGException ex) {
                logger.error((Object)ex);
            }
        });
        return result;
    }

    public void startBot(String token) throws BGException {
        this.getBotByToken(token).startBot();
    }

    public void stopBot(String token) throws BGException {
        this.getBotByToken(token).stopBot();
    }

    public void startAllBots() {
        this.runtimeBotMap.forEach((token, bot) -> bot.startBot());
    }

    public void stopAllBots() {
        this.runtimeBotMap.forEach((token, bot) -> bot.stopBot());
    }

    public synchronized void hotSwapBotData(Bot bot) throws Exception {
        RuntimeBot runtimeBot = this.runtimeBotMap.get(bot.getToken());
        if (runtimeBot == null) {
            runtimeBot = this.convertBotToRuntimeBot(bot);
            this.runtimeBotMap.put(bot.getToken(), runtimeBot);
            if (bot.getState() == 1) {
                runtimeBot.startBot();
            }
        } else {
            int oldState = runtimeBot.getBotState();
            runtimeBot = this.convertBotToRuntimeBot(bot, runtimeBot);
            this.runtimeBotMap.put(bot.getToken(), runtimeBot);
            if (runtimeBot.getBotState() != oldState) {
                if (runtimeBot.getBotState() == 1) {
                    runtimeBot.startBot();
                } else if (runtimeBot.getBotState() == 0) {
                    runtimeBot.stopBot();
                }
            }
        }
    }

    private RuntimeBot getBotByToken(String token) throws BGException {
        RuntimeBot runtimeBot = this.runtimeBotMap.get(token);
        if (runtimeBot == null) {
            throw new BGException("\u0411\u043e\u0442 \u0441 \u0442\u0430\u043a\u0438\u043c \u0442\u043e\u043a\u0435\u043d\u043e\u043c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0431\u043e\u0442\u043e\u0432");
        }
        return runtimeBot;
    }

    public static BotManagement getOrInitAndGet(ServerContext serverContext, int moduleId) {
        if (!instanceMap.containsKey(moduleId)) {
            try {
                BotManagement.init(serverContext, moduleId);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return instanceMap.get(moduleId);
    }

    public Map<String, RuntimeBot> getRuntimeBotMap() {
        return this.runtimeBotMap;
    }

    public RuntimeBot getBot(String token) {
        return this.runtimeBotMap.get(token);
    }

    public RuntimeBot getBot(int botId) throws NoSuchElementException {
        return this.runtimeBotMap.values().stream().filter(bot -> bot.getBotId() == botId).findFirst().orElseThrow(NoSuchElementException::new);
    }

    public Map<String, DialogProcessing> getDialogProcessingClasses() {
        return this.dialogProcessingClasses;
    }
}

