/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.tree.npay;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.tariff.server.tree.DefaultTariffTreeNode;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayServiceCost;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffContext;
import ru.bitel.bgbilling.modules.npay.server.tariff.NPayTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class MonthModeCostTariffTreeNode
extends DefaultTariffTreeNode<NPayTariffRequest, NPayTariffContext> {
    protected final BigDecimal cost;
    protected final String costMode;
    protected final int type;
    protected final int tariffVarId;

    public MonthModeCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.cost = parameterMap.getBigDecimal("cost", BigDecimal.ZERO);
        this.type = parameterMap.getInt("type", 0);
        this.costMode = parameterMap.get("costMode", "const");
        this.tariffVarId = parameterMap.getInt("tariffVarId", 0);
    }

    @Override
    protected int executeImpl(Long treeNodeId, NPayTariffRequest tariffRequest, NPayTariffContext tariffContext) {
        String value;
        BigDecimal inCost = this.cost;
        if (tariffRequest.getServiceObject().getCost() != null) {
            inCost = tariffRequest.getServiceObject().getCost();
        } else if ("var".equals(this.costMode) && (value = tariffRequest.getContractTariffVarValue(this.tariffVarId)) != null) {
            inCost = new BigDecimal(value);
        }
        BigDecimal outCost = BigDecimal.ZERO;
        int monthDays = tariffRequest.getAccountingMonthDays();
        int periodDays = ((NPayServiceCost)tariffRequest.serviceCost).getAccountingPeriodDays();
        BigDecimal monthAmount = ((NPayServiceCost)tariffRequest.serviceCost).monthAmount;
        BigDecimal periodAmount = ((NPayServiceCost)tariffRequest.serviceCost).periodAmount;
        MathContext mathContext = tariffContext.mc;
        boolean amount = monthAmount != null && periodAmount != null;
        switch (this.type) {
            case 0: {
                outCost = periodDays > 0 ? inCost : BigDecimal.ZERO;
                break;
            }
            case 1: {
                outCost = inCost.multiply(BigDecimal.valueOf(periodDays), mathContext).divide(BigDecimal.valueOf(monthDays), mathContext);
                break;
            }
            case 2: {
                outCost = amount ? inCost.multiply(periodAmount, mathContext).divide(monthAmount, mathContext) : BigDecimal.ZERO;
                break;
            }
            case 3: {
                BigDecimal costPropAmount;
                outCost = inCost.multiply(BigDecimal.valueOf(periodDays), mathContext).divide(BigDecimal.valueOf(monthDays), mathContext);
                if (!amount || (costPropAmount = inCost.multiply(periodAmount, mathContext).divide(monthAmount, mathContext)).compareTo(outCost) <= 0) break;
                outCost = costPropAmount;
                break;
            }
            case 4: {
                if (periodDays > 0) {
                    Calendar startMonth = TimeUtils.getStartMonth((Calendar)tariffContext.getCurrentDay());
                    startMonth = TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)startMonth);
                    Calendar endMonth = TimeUtils.getEndMonth((Calendar)tariffContext.getCurrentDay());
                    Calendar dateFrom = tariffRequest.tariffDateFrom;
                    Calendar dateTo = tariffRequest.tariffDateTo;
                    if (dateFrom == null || TimeUtils.dateBefore((Calendar)dateFrom, (Calendar)startMonth)) {
                        dateFrom = startMonth;
                    }
                    if (dateTo == null || TimeUtils.dateBefore((Calendar)endMonth, (Calendar)dateTo)) {
                        dateTo = endMonth;
                    }
                    int periodDaysTariff = dateTo.get(5) - dateFrom.get(5) + 1;
                    outCost = inCost.multiply(BigDecimal.valueOf(periodDaysTariff), mathContext).divide(BigDecimal.valueOf(monthDays), mathContext);
                    break;
                }
                outCost = BigDecimal.ZERO;
                break;
            }
            case 5: {
                if (periodDays > 0) {
                    LocalDate s1 = TimeUtils.convertDateToLocalDate((Date)((NPayServiceCost)tariffRequest.serviceCost).getDate1().getTime());
                    LocalDate s2 = TimeUtils.convertDateToLocalDate((Date)((NPayServiceCost)tariffRequest.serviceCost).getDate2().getTime());
                    LocalDate t1 = Optional.ofNullable(tariffRequest.tariffDateFrom).map(a -> TimeUtils.convertDateToLocalDate((Date)a.getTime())).orElse(s1.withDayOfMonth(1));
                    LocalDate t2 = Optional.ofNullable(tariffRequest.tariffDateTo).map(a -> TimeUtils.convertDateToLocalDate((Date)a.getTime())).orElse(s2.withDayOfMonth(s2.lengthOfMonth()));
                    t1 = t1.isBefore(s1) ? s1 : t1;
                    t2 = t2.isAfter(s2) ? s2 : t2;
                    int days = 0;
                    if (!s1.isAfter(t2) && !t1.isAfter(s2)) {
                        LocalDate p1 = s1.isBefore(t1) ? t1 : s1;
                        LocalDate p2 = s2.isAfter(t2) ? t2 : s2;
                        days = p2.getDayOfMonth() - p1.getDayOfMonth() + 1;
                    }
                    if (days > 0) {
                        outCost = inCost.multiply(BigDecimal.valueOf(days), mathContext).divide(BigDecimal.valueOf(monthDays), mathContext);
                        break;
                    }
                    outCost = BigDecimal.ZERO;
                    break;
                }
                outCost = BigDecimal.ZERO;
                break;
            }
            default: {
                outCost = BigDecimal.ZERO;
            }
        }
        ((NPayServiceCost)tariffRequest.serviceCost).setCost(outCost);
        return 1;
    }
}

