/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server;

import bitel.billing.server.ModuleBase;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedModuleEvent;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.ContractParamChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractStatusChangedEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractUpdateObjectEvent;
import ru.bitel.bgbilling.kernel.event.events.OnContractWrapEvent;
import ru.bitel.bgbilling.kernel.event.events.ServiceUpdateEvent;
import ru.bitel.bgbilling.kernel.event.events.VoiceLogProcessedEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCloseEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.sorm.server.event.AddContractToUploadEvent;
import ru.bitel.bgbilling.modules.sorm.server.upload.cdr.voice.VoiceCDRUploadImplementation;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadLogsTable;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class Module
extends ModuleBase {
    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.sorm.server"};
    }

    public void start(Connection con, BGModule module) throws BGException {
        SormEventListener el = new SormEventListener(module.getId());
        EventProcessor eventProcessor = EventProcessor.getInstance();
        eventProcessor.addListener((EventListener)el, ContractParamChangedEvent.class);
        eventProcessor.addListener((EventListener)el, ContractStatusChangedEvent.class);
        eventProcessor.addListener((EventListener)el, ServiceUpdateEvent.class);
        eventProcessor.addListener((EventListener)el, OnContractWrapEvent.class);
        eventProcessor.addListener((EventListener)el, ContractModifiedModuleEvent.class);
        eventProcessor.addListener((EventListener)el, ContractCloseEvent.class);
        eventProcessor.addListener((EventListener)el, AddContractToUploadEvent.class);
        eventProcessor.addListener((EventListener)el, ContractUpdateObjectEvent.class);
        eventProcessor.addListener((EventListener)new VoiceCDRUploadImplementation(module.getId()), VoiceLogProcessedEvent.class);
        try {
            eventProcessor.addListener((EventListener)el, Class.forName("ru.bitel.bgbilling.modules.inet.server.event.InetServModifiedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)el, Class.forName("ru.bitel.bgbilling.modules.voice.common.event.VoiceAccountModifiedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)el, Class.forName("ru.bitel.bgbilling.modules.phone.server.event.ClientItemChangedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            eventProcessor.addListener((EventListener)el, Class.forName("ru.bitel.bgbilling.modules.npay.server.event.ContractNpayChangedEvent"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private final class SormEventListener
    implements EventListener<Event> {
        private final int moduleId;

        SormEventListener(int moduleId) {
            this.moduleId = moduleId;
        }

        public void notify(Event event, EventListenerContext ctx) throws BGException {
            if (event instanceof ContractModifiedModuleEvent) {
                ContractModifiedModuleEvent modifiedModuleEvent = (ContractModifiedModuleEvent)event;
                if (modifiedModuleEvent.getModifiedModuleType().equals((Object)ContractModifiedModuleEvent.ModifiedModuleType.ADDED) && modifiedModuleEvent.getModuleId() == this.moduleId) {
                    this.putChangedContractOnSormTaskTable(event);
                }
            } else {
                this.putChangedContractOnSormTaskTable(event);
            }
        }

        private void putChangedContractOnSormTaskTable(Event event) throws BGException {
            int contractId = event.getContractId();
            String eventClassName = event.getClass().getName();
            ServerContext serverContext = (ServerContext)ServerContext.get();
            Connection con = serverContext.getConnection();
            if (!this.checkValidContractDate(contractId, con)) {
                return;
            }
            if (contractId > 0 && SormUtils.contractHasModule(con, this.moduleId, contractId)) {
                Module.this.getLogger().debug("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + contractId + " \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0443 \u0437\u0430\u0434\u0430\u0447 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u043d\u0430 \u0421\u041e\u0420\u041c. \u0421\u043e\u0431\u044b\u0442\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: " + eventClassName);
                String tableName = SormUploadLogsTable.getSormChangedContractTable(this.moduleId);
                try (PreparedStatement ps = con.prepareStatement("INSERT IGNORE INTO " + tableName + " (date, eventClass, contractId) VALUES(?,?,?)");){
                    ps.setTimestamp(1, TimeUtils.convertCalendarToTimestamp((Calendar)event.getTime()));
                    ps.setString(2, eventClassName);
                    ps.setInt(3, contractId);
                    ServerUtils.checkTable((Connection)con, (String)tableName, (String)SormUploadLogsTable.getSormChangedContractTableCreateQuery(this.moduleId));
                    ps.executeUpdate();
                }
                catch (SQLException ex) {
                    Module.this.logError(ex);
                }
            }
        }

        private boolean checkValidContractDate(int contractId, Connection connection) throws BGException {
            boolean result = true;
            try (Statement st = connection.createStatement();
                 ResultSet rs = st.executeQuery("SELECT date2 FROM contract WHERE id=" + contractId);){
                if (rs.next()) {
                    result = SormUtils.checkThreeYearsAgo(TimeUtils.convertSqlDateToDate((Date)rs.getDate(1)));
                }
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
            return result;
        }
    }
}

