/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class WebStatusChangeRules {
    private static final int FROM_CURDATE = 1;
    private static final int FROM_NEXTDAY = 2;
    private final Set<StatusChange> changeSet = new HashSet<StatusChange>();

    public WebStatusChangeRules(Preferences setup) {
        StringTokenizer tokens = new StringTokenizer(setup.get("web.allow.status.change", "0:4:tomorrow;4:0:curdate"), ";");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            String[] pair = token.split("\\:");
            if (pair.length != 3) continue;
            this.changeSet.add(new StatusChange(Utils.parseInt((String)pair[0]), Utils.parseInt((String)pair[1]), pair[2]));
        }
    }

    public Set<Integer> getChangeableStatusIds() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (StatusChange change : this.changeSet) {
            result.add(change.from);
        }
        return result;
    }

    public boolean isStatusChangeAllow(int fromStatus, int toStatus) {
        for (StatusChange change : this.changeSet) {
            if (change.from != fromStatus || change.to != toStatus) continue;
            return true;
        }
        return false;
    }

    public Date getFromStatusChangeDate(int statusId) {
        for (StatusChange change : this.changeSet) {
            if (change.from != statusId) continue;
            if (change.changeTime == 1) {
                return new Date();
            }
            return TimeUtils.getNextDay((Date)new Date());
        }
        return null;
    }

    private static class StatusChange {
        public final int from;
        public final int to;
        public final int changeTime;

        public StatusChange(int from, int to, String changeTime) {
            this.from = from;
            this.to = to;
            this.changeTime = "curdate".equals(changeTime) ? 1 : ("tomorrow".equals(changeTime) ? 2 : 2);
        }
    }
}

