/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.ModTreeNode;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class CheckingTreeListener
extends MouseAdapter {
    public JTree tree;

    public CheckingTreeListener(JTree tree) {
        this.tree = tree;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int y;
        int x = e.getX();
        int row = this.tree.getRowForLocation(x, y = e.getY());
        TreePath path = this.tree.getPathForRow(row);
        if (path != null) {
            ModTreeNode node = (ModTreeNode)this.tree.getLastSelectedPathComponent();
            if (!node.isEn() || "1".equals(node.getAttribute("type"))) {
                return;
            }
            boolean isSelected = !node.isSel();
            node.setSel(isSelected);
            if (isSelected && node.getChildCount() != 0) {
                this.selNodes(node);
            }
            if (isSelected) {
                CheckingTreeListener.selParentNodes(node);
            } else {
                this.clearParentNodes(node);
            }
            this.tree.repaint();
        }
    }

    public void selNodes(ModTreeNode mainNode) {
        mainNode.setSel(true);
        if (mainNode.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < mainNode.getChildCount(); ++i) {
            this.selNodes((ModTreeNode)mainNode.getChildAt(i));
        }
    }

    public static final void selParentNodes(ModTreeNode mainNode) {
        ModTreeNode child;
        boolean allSel = true;
        if (mainNode.getParent() == null) {
            return;
        }
        if (mainNode.getParent().getChildCount() > 0 && !(child = (ModTreeNode)mainNode.getParent().getChildAt(0)).isSel()) {
            allSel = false;
        }
        if (allSel) {
            ModTreeNode parentNode = (ModTreeNode)mainNode.getParent();
            parentNode.setSel(true);
            CheckingTreeListener.selParentNodes(parentNode);
        }
    }

    private void clearParentNodes(ModTreeNode mainNode) {
        if (mainNode.getParent() == null) {
            return;
        }
        ModTreeNode parentNode = (ModTreeNode)mainNode.getParent();
        parentNode.setSel(false);
        this.clearParentNodes(parentNode);
    }
}

