/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import ru.bitel.common.ParameterMap;

public class Distribution {
    private final String[] subsystems;
    private final Address[] urls;

    public Distribution(ParameterMap params) {
        params = params.sub("system.");
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> e : params.entrySet()) {
            list.add(e);
        }
        Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o2.getKey().compareTo(o1.getKey());
            }
        });
        this.subsystems = new String[list.size()];
        this.urls = new Address[list.size()];
        int i = 0;
        for (Map.Entry entry : list) {
            this.subsystems[i] = (String)entry.getKey();
            this.urls[i] = new Address((String)entry.getValue(), 0);
            ++i;
        }
    }

    public Address getAddress(String context) {
        int size = this.subsystems.length;
        for (int i = 0; i < size; ++i) {
            if (!context.startsWith(this.subsystems[i])) continue;
            return this.urls[i];
        }
        return null;
    }

    public static class Address {
        public final String url;
        public final int moduleId;

        Address(String url, int moduleId) {
            this.url = url;
            this.moduleId = moduleId;
        }
    }
}

