/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.tariff;

import java.math.BigDecimal;
import java.util.Calendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.base.phone.tariff.server.AbstractPhoneServiceCost;
import ru.bitel.bgbilling.modules.phone.server.LogRecord;
import ru.bitel.bgbilling.modules.phone.server.tariff.PhoneTariffContext;

public class PhoneServiceCost
extends AbstractPhoneServiceCost {
    private static final Logger logger = LogManager.getLogger();
    private static final BigDecimal minute = BigDecimal.valueOf(60.0);
    private BigDecimal sessionCost;
    private int roundSessionTime;

    public PhoneServiceCost(int serviceId, Calendar serviceStart, Calendar serviceEnd, Calendar date1, Calendar date2, long amount) {
        super(serviceId, serviceStart, serviceEnd, date1, date2, amount);
    }

    public PhoneServiceCost newCost() {
        return new PhoneServiceCost(this.serviceId, this.serviceStart, this.serviceEnd, this.date1, this.date2, this.amount);
    }

    public void setTypeAndSourceDefault() {
        if (this.costType == -1) {
            this.costType = 1;
        }
        if (this.costSource == -1) {
            this.costSource = 1;
        }
    }

    public void calculateTimeAndCost(LogRecord record, int sessionTime, BigDecimal callCost, PhoneTariffContext tariffContext) {
        this.sessionCost = this.cost;
        this.roundSessionTime = sessionTime;
        if (this.config != null) {
            this.roundSessionTime = this.config.getRoundTime(sessionTime);
            if (logger.isDebugEnabled()) {
                logger.debug("Session time after round " + this.roundSessionTime);
            }
        }
        if (this.costSource == 2 && callCost != null) {
            this.sessionCost = this.cost = callCost;
        }
        if (!(this.addCost == null || this.addCost.nonZero && this.roundSessionTime <= 0)) {
            if (this.addCost.minuteCost) {
                this.cost = this.cost.add(this.addCost.cost, tariffContext.mc);
                if (this.costType == 1) {
                    this.sessionCost = this.cost.multiply(BigDecimal.valueOf(this.roundSessionTime), tariffContext.mc).divide(minute, tariffContext.mc);
                }
            } else {
                if (this.costType == 1) {
                    this.sessionCost = this.cost.multiply(BigDecimal.valueOf(this.roundSessionTime), tariffContext.mc).divide(minute, tariffContext.mc);
                }
                this.sessionCost = this.sessionCost.add(this.addCost.cost, tariffContext.mc);
            }
        } else if (this.costType == 1) {
            this.sessionCost = this.cost.multiply(BigDecimal.valueOf(this.roundSessionTime), tariffContext.mc).divide(minute, tariffContext.mc);
        }
        if (this.config != null) {
            this.sessionCost = this.config.roundCost(this.sessionCost, 2);
        }
    }

    public BigDecimal getSessionCost() {
        return this.sessionCost;
    }

    public int getRoundSessionTime() {
        return this.roundSessionTime;
    }
}

