/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.apps.voice.accounting.recalculate.VoiceRecalculator;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceDestinationDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.GeoCodeManager;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceGeographicCodeDao;
import ru.bitel.bgbilling.modules.voice.server.bean.range.VoiceGeographicRangeDao;
import ru.bitel.bgbilling.modules.voice.server.event.GeoCodeUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.task.VoiceBalanceSetter;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceService")
public class VoiceServiceImpl
extends AbstractService
implements VoiceService {
    private VoiceDestinationDao voiceDestinationDao;
    private VoiceGeographicCodeDao voiceGeographicCodeDao;
    private VoiceGeographicRangeDao voiceGeographicRangeDao;

    @PostConstruct
    private void init() {
        this.voiceDestinationDao = new VoiceDestinationDao(this.getConnection(), this.moduleId);
        this.voiceGeographicCodeDao = new VoiceGeographicCodeDao(this.getConnection(), this.moduleId);
        this.voiceGeographicRangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<VoiceDestination> voiceDestinationList(int operator, String title, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        this.voiceDestinationDao.searchDestination((SearchResult<VoiceDestination>)searchResult, operator, title, true);
        return searchResult;
    }

    public List<IdTitle> voiceDestinationTitles(List<Integer> destIds) throws Exception {
        return this.voiceDestinationDao.list(destIds);
    }

    public VoiceDestination voiceDestinationGet(int id) throws Exception {
        return (VoiceDestination)this.voiceDestinationDao.get(id);
    }

    public int voiceDestinationUpdate(VoiceDestination destination) throws Exception {
        this.voiceDestinationDao.update(destination);
        return destination.getId();
    }

    public int voiceDestinationDelete(List<Integer> idSet) throws Exception {
        return this.voiceDestinationDao.delete(idSet);
    }

    public void voiceDestinationReplace(int sourceDestinationId, int targetDestinationId) throws Exception {
        this.voiceGeographicCodeDao.replaceDestination(sourceDestinationId, targetDestinationId);
    }

    public String getGeographicCodeTree(int operatorId) throws Exception {
        GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);
        List<VoiceGeographicCode> codeList = codeDao.list(-1, operatorId);
        return Base64.getEncoder().encodeToString(this.listToTreeRoot(codeList));
    }

    public List<IdTitle> voiceGeographicCodeTitles(int operatorId) throws Exception {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).list(-1, operatorId).stream().map(a -> new IdTitle(a.getId(), a.getCode() + " - " + a.getDestinationTitle())).toList();
    }

    public int updateGeographicCode(VoiceGeographicCode code) throws Exception {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).updateGeographicCode(code);
    }

    public int deleteGeographicCode(List<Integer> codes) throws Exception {
        EventProcessor.getInstance().publishAfterCommit((Event)new GeoCodeUpdateEvent(this.moduleId, this.userId));
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).delete(codes);
    }

    public String importGeographicCode(int operatorId, boolean addNew, boolean updateExist, String importContent) throws Exception {
        return new GeoCodeManager(this.getConnection(), this.moduleId, this.userId).importGeographicCode(operatorId, addNew, updateExist, importContent);
    }

    public void deleteAllGeographicCode(int operatorId) throws Exception {
        GeoCodeManager codeDao = new GeoCodeManager(this.getConnection(), this.moduleId, this.userId);
        codeDao.delete(codeDao.list(-1, operatorId).stream().map(item -> item.getId()).toList());
    }

    private byte[] listToTreeRoot(List<VoiceGeographicCode> codeList) throws Exception {
        VoiceUtils.fillParents(codeList);
        VoiceGeographicCode root = new VoiceGeographicCode(0, "\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
        root = (VoiceGeographicCode)TreeUtils.tree(codeList, (Node)root);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(root);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public List<VoiceGeographicCode> voiceGeographicCodeByDestinationId(int destinationId) throws Exception {
        return this.voiceGeographicCodeDao.getVoiceGeographicCodeByDestinationId(destinationId);
    }

    public void calculate(Date dateFrom, Date dateTo, Set<Integer> contractIds, long groupMask, String email, String comment) throws Exception {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceRecalculator(dateFrom, dateTo, contractIds, groupMask, email, comment, this.moduleId));
    }

    public void setBalance(Date month, String email, Set<Integer> contractIds) throws Exception {
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new VoiceBalanceSetter(this.moduleId, month, email, contractIds));
    }

    public String voiceGeographicRangeList(int operatorId) throws Exception {
        List<VoiceGeographicRange> list = this.voiceGeographicRangeDao.list(operatorId);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(list);
                oos.flush();
                string = Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
    }

    public VoiceGeographicRange voiceGeographicRangeGet(int id) throws Exception {
        return null;
    }

    public int voiceGeographicRangeUpdate(VoiceGeographicRange range) throws Exception {
        this.voiceGeographicRangeDao.update(range);
        return range.getId();
    }

    public void voiceGeographicRangeDelete(List<Integer> ids) throws Exception {
        for (int id : ids) {
            this.voiceGeographicRangeDao.delete(id);
        }
    }

    public String voiceGeographicRangeImport(int operatorId, String importData, boolean addDestination) throws Exception {
        VoiceGeographicRangeDao rangeDao = new VoiceGeographicRangeDao(this.getConnection(), this.moduleId);
        Map<String, VoiceDestination> destinationMap = this.voiceDestinationDao.titleMap(operatorId);
        StringBuilder res = new StringBuilder();
        VoiceGeographicRange range = new VoiceGeographicRange();
        range.setOperatorId(operatorId);
        for (String data : importData.split("\n")) {
            range.setId(0);
            range.setMobileId("");
            String[] a = data.split("\t");
            VoiceDestination voiceDestination = destinationMap.get(a[2]);
            if (voiceDestination == null) {
                if (addDestination) {
                    voiceDestination = new VoiceDestination();
                    voiceDestination.setOperatorId(operatorId);
                    voiceDestination.setTitle(a[2]);
                    this.voiceDestinationDao.update(voiceDestination);
                    destinationMap.put(a[2], voiceDestination);
                } else {
                    res.append(data).append(" <== \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435\n");
                    continue;
                }
            }
            if (a.length > 2) {
                range.setRangeFrom(Utils.parseLong((String)a[0]));
                range.setRangeTo(Utils.parseLong((String)a[1]));
                range.setDestinationId(voiceDestination.getId());
            }
            if (a.length > 3) {
                range.setMobileId(a[4]);
            }
            if (range.getRangeFrom() > range.getRangeTo()) {
                res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f\n");
                continue;
            }
            if (range.getRangeFrom() < 10000000000L) {
                res.append(data).append(" <== \u043d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                continue;
            }
            if (range.getRangeTo() < 10000000000L) {
                res.append(data).append(" <== \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043c\u0435\u043d\u044c\u0448\u0435 11 \u0446\u0438\u0444\u0440\n");
                continue;
            }
            rangeDao.update(range);
        }
        return res.toString();
    }

    public List<VoiceGeographicRange> voiceGeographicRangeSearch(int operatorId, String txt) throws Exception {
        return this.voiceGeographicRangeDao.list(operatorId, txt);
    }

    public List<VoiceGeographicRange> voiceGeographicRanges(List<Integer> rangeIds) throws Exception {
        return this.voiceGeographicRangeDao.list(rangeIds);
    }
}

