/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.buyemoney.server.protocols.wm;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Arrays;
import ru.bitel.common.Utils;

public class WMSigner {
    private String wmid;
    private String pass;
    private byte[] kwm;

    public WMSigner(String wmid, String pass, byte[] kwm) {
        this.wmid = wmid;
        this.pass = pass;
        this.kwm = kwm;
        if (this.kwm.length != 164) {
            throw new IllegalArgumentException("KWM file not found or KWM data invalid");
        }
    }

    private byte[] _XOR(byte[] str, byte[] xor_str, int shift) {
        int str_len = str.length;
        int xor_len = xor_str.length;
        int k = 0;
        for (int i = shift; i < str_len; ++i) {
            str[i] = (byte)(str[i] ^ xor_str[k]);
            if (++k < xor_len) continue;
            k = 0;
        }
        return str;
    }

    private KeyData SecureKeyByIDPW(String wmid, String pass, KeyData key_data, boolean half) throws NoSuchAlgorithmException {
        int pass_len = pass.length() >> (half ? 1 : 0);
        String idpw = wmid + pass.substring(0, pass_len);
        byte[] digest = Utils.getMD4Digest((byte[])idpw.getBytes());
        KeyData result = key_data.clone();
        result.buf = this._XOR(result.buf, digest, 6);
        return result;
    }

    private int Init(byte[] content, KeyData key_data, SignKeys keys) throws NoSuchAlgorithmException {
        if (content.length < 24) {
            return 1;
        }
        if ((long)(content.length - 8) < key_data.len) {
            return -1;
        }
        byte[] crc_cont = new byte[24 + key_data.buf.length];
        ByteBuffer bb = ByteBuffer.wrap(crc_cont);
        bb.put(WMSigner.dumpUS(key_data.reserved));
        bb.put(WMSigner.dumpUS(key_data.signflag));
        byte[] zero = new byte[16];
        bb.put(zero);
        bb.put(WMSigner.dumpUI(key_data.len));
        bb.put(key_data.buf);
        byte[] digest = Utils.getMD4Digest((byte[])crc_cont);
        if (!Arrays.equals(digest, key_data.crc)) {
            return -1;
        }
        int tmp_ek_base = WMSigner.makeUS(key_data.buf[4], key_data.buf[5]);
        keys.ekey = Arrays.copyOfRange(key_data.buf, 6, 6 + tmp_ek_base);
        int tmp_nk_base = WMSigner.makeUS(key_data.buf[6 + tmp_ek_base + 0], key_data.buf[6 + tmp_ek_base + 1]);
        keys.nkey = Arrays.copyOfRange(key_data.buf, 6 + tmp_ek_base + 2, 6 + tmp_ek_base + 2 + tmp_nk_base);
        return 0;
    }

    public String Sign(String data) throws NoSuchAlgorithmException, SignatureException, UnsupportedEncodingException {
        return Utils.bytesToHexString((byte[])this.Sign(data.getBytes("windows-1251"))).toLowerCase();
    }

    public byte[] Sign(byte[] data) throws NoSuchAlgorithmException, SignatureException {
        KeyData key_data = new KeyData();
        key_data.reserved = WMSigner.makeUS(this.kwm[0], this.kwm[1]);
        key_data.signflag = WMSigner.makeUS(this.kwm[2], this.kwm[3]);
        key_data.crc = new byte[16];
        System.arraycopy(this.kwm, 4, key_data.crc, 0, 16);
        key_data.len = WMSigner.makeUI(this.kwm[20], this.kwm[21], this.kwm[22], this.kwm[23]);
        key_data.buf = new byte[140];
        System.arraycopy(this.kwm, 24, key_data.buf, 0, 140);
        SignKeys sign_keys = new SignKeys();
        KeyData key_test = this.SecureKeyByIDPW(this.wmid, this.pass, key_data, true);
        key_test.signflag = 0;
        if (this.Init(this.kwm, key_test, sign_keys) != 0) {
            key_test = this.SecureKeyByIDPW(this.wmid, this.pass, key_data, false);
            key_test.signflag = 0;
            if (this.Init(this.kwm, key_test, sign_keys) != 0) {
                throw new SignatureException("Checksum failed. KWM password invalid.");
            }
        }
        int USHORT_BYTES = 2;
        int VALUE_BYTES = 56;
        int HASH_LEN = 16;
        byte[] lenbytes = WMSigner.dumpUS(56);
        byte[] digest = Utils.getMD4Digest((byte[])data);
        byte[] rndBuffer = new byte[38];
        byte[] to_encrypt = new byte[56];
        System.arraycopy(lenbytes, 0, to_encrypt, 0, 2);
        System.arraycopy(digest, 0, to_encrypt, 2, 16);
        System.arraycopy(rndBuffer, 0, to_encrypt, 18, 38);
        BigInteger m = new BigInteger(this.revertArray(to_encrypt));
        BigInteger e = new BigInteger(this.revertArray(sign_keys.ekey));
        BigInteger n = new BigInteger(this.revertArray(sign_keys.nkey));
        BigInteger a = m.modPow(e, n);
        return this._shortunswap(a.toByteArray());
    }

    private byte[] _shortunswap(byte[] input) {
        byte[] output = new byte[input.length + input.length % 2];
        for (int i = 0; i < input.length; ++i) {
            output[i % 2 == 0 ? i + 1 : i - 1] = input[input.length - 1 - i];
        }
        return output;
    }

    private byte[] revertArray(byte[] input) {
        byte[] output = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            output[i] = input[input.length - 1 - i];
        }
        return output;
    }

    private static int makeUS(byte byte0, byte byte1) {
        return 0xFF & (short)byte0 | 0xFF00 & (short)byte1 << 8;
    }

    private static byte[] dumpUS(int us) {
        byte byte0 = (byte)(us & 0xFF);
        byte byte1 = (byte)(us >> 8 & 0xFF);
        return new byte[]{byte0, byte1};
    }

    private static long makeUI(byte byte0, byte byte1, byte byte2, byte byte3) {
        return 0xFF & byte0 | 0xFF00 & byte1 << 8 | 0xFF0000 & byte2 << 16 | 0xFF000000 & byte3 << 24;
    }

    private static byte[] dumpUI(long ui) {
        byte byte0 = (byte)(ui & 0xFFL);
        byte byte1 = (byte)(ui >> 8 & 0xFFL);
        byte byte2 = (byte)(ui >> 16 & 0xFFL);
        byte byte3 = (byte)(ui >> 24 & 0xFFL);
        return new byte[]{byte0, byte1, byte2, byte3};
    }

    private static class KeyData {
        int reserved;
        int signflag;
        byte[] crc;
        long len;
        byte[] buf;

        private KeyData() {
        }

        protected KeyData clone() {
            KeyData new_this = new KeyData();
            new_this.reserved = this.reserved;
            new_this.signflag = this.signflag;
            if (this.crc != null) {
                new_this.crc = new byte[this.crc.length];
                System.arraycopy(this.crc, 0, new_this.crc, 0, this.crc.length);
            }
            new_this.len = this.len;
            if (this.buf != null) {
                new_this.buf = new byte[this.buf.length];
                System.arraycopy(this.buf, 0, new_this.buf, 0, this.buf.length);
            }
            return new_this;
        }
    }

    private static class SignKeys {
        byte[] ekey;
        byte[] nkey;

        private SignKeys() {
        }
    }
}

