/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.common.TimeUtils;

public class VoiceSessionDao
extends VoiceSessionLogDao {
    private PreparedStatement insertSessionPS;
    private PreparedStatement updateSessionPS;
    public static final String TABLE_VOICE_SESSION = "voice_session";

    public VoiceSessionDao(Connection con, int mid) {
        super(con, mid, TABLE_VOICE_SESSION);
    }

    public void insertSession(VoiceSession session) throws BGException {
        try {
            if (this.insertSessionPS == null) {
                String query = "INSERT INTO  tableName " + this.getFieldPart();
                this.insertSessionPS = this.con.prepareStatement(query);
            }
            this.setPsParams(session, this.insertSessionPS, 1);
            this.insertSessionPS.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateSession(VoiceSession session) throws BGException {
        try {
            if (this.updateSessionPS == null) {
                String query = "UPDATE  " + this.tableName + " SET sessionCost = ?, lastActive = ?, sessionTime = ?, sessionTimeRound = ?, sessionStop = ?  WHERE id =  ?";
                this.updateSessionPS = this.con.prepareStatement(query);
            }
            int idx = 1;
            this.updateSessionPS.setBigDecimal(idx++, session.getSessionCost());
            this.updateSessionPS.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getLastActive()));
            this.updateSessionPS.setLong(idx++, session.getSessionTime());
            this.updateSessionPS.setLong(idx++, session.getRoundedSessionTime());
            this.updateSessionPS.setTimestamp(idx++, TimeUtils.convertDateToTimestamp((Date)session.getSessionStop()));
            this.updateSessionPS.setLong(idx++, session.getId());
            this.updateSessionPS.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void close() throws BGException {
        try {
            if (this.insertSessionPS != null) {
                this.insertSessionPS.close();
            }
            if (this.updateSessionPS != null) {
                this.updateSessionPS.close();
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

