/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.tariff.range;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.range.VoiceRuntimeRangeManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class VoiceRangeManager
extends VoiceRuntimeRangeManager {
    protected Date month;
    protected int day;
    protected String detailTableName;

    public VoiceRangeManager(int moduleId, Date month, int day) throws BGException {
        super(moduleId, false);
        this.month = month;
        this.day = day;
        this.tablename = ServerUtils.getModuleTableName((String)"voice_tariff_traffic_range", (int)moduleId);
        this.detailTableName = ServerUtils.getModuleMonthTableName((String)"voice_tariff_traffic_range_detail", (Date)this.month, (int)moduleId);
    }

    public TrafficRange getRangedTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        TrafficRange range = this.getPrevMonthTraffic(workerContext, contractId, treeNodeId, key);
        try {
            String query = "SELECT SUM(amount) FROM " + this.detailTableName + " WHERE contractId=? AND treeNodeId=? AND rangeKey=? AND day<?";
            ResultSet rs = workerContext.getPSCache().execute(query, new Object[]{contractId, treeNodeId, key, this.day});
            if (rs.next()) {
                range.amount += rs.getLong(1);
            }
            return range;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private TrafficRange getPrevMonthTraffic(TariffWorkerContext workerContext, int contractId, long treeNodeId, long key) throws BGException {
        try {
            int yy = TimeUtils.convertDateToCalendar((Date)this.month).get(1);
            int mm = TimeUtils.convertDateToCalendar((Date)this.month).get(2) + 1;
            String query = "SELECT counter, amount, maxAmount  FROM " + this.tablename + " WHERE contractId=? AND treeNodeId=? AND rangeKey=?  AND  ( (yy < ? ) or ( yy = ? AND mm < ? ) )  ORDER BY yy DESC, mm DESC LIMIT 1";
            TrafficRange rangeTraffic = new TrafficRange(0, 0L, 0L);
            try (ResultSet rs = workerContext.getPSCache().execute(query, new Object[]{contractId, treeNodeId, key, yy, yy, mm});){
                if (rs.next()) {
                    rangeTraffic = new TrafficRange(rs.getInt(1), rs.getLong(2), rs.getLong(3));
                }
            }
            return rangeTraffic;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

