/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.voiceip.server.bean.FindMode;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;

public class FindModeManager
extends BGLogger {
    private Map<Integer, FindMode> modeMap = new TreeMap<Integer, FindMode>();

    public FindModeManager(ParameterMap setup) {
        TreeMap<String, FindMode> tmpModeMap = new TreeMap<String, FindMode>();
        for (Map.Entry entry : setup.sub("findmode.").entrySet()) {
            FindMode fm;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("findmode key={}; value={}", entry.getKey(), entry.getValue());
            }
            String[] code_param = ((String)entry.getKey()).split("\\.");
            String id = code_param[0];
            String param = code_param[1];
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("findmode code_param.length={}; id={}; param={}", new Object[]{code_param, id, param});
            }
            if ((fm = (FindMode)tmpModeMap.get(id)) == null) {
                fm = new FindMode();
                fm.setId(Utils.parseInt((String)id, (int)-1));
                tmpModeMap.put(id, fm);
            }
            if (param.equals("title")) {
                fm.setTitle((String)entry.getValue());
            } else if (param.equals("value")) {
                fm.setValue((String)entry.getValue());
            }
            if (!this.getLogger().isDebugEnabled()) continue;
            this.getLogger().debug("FindMode={}", (Object)fm);
        }
        for (Map.Entry entry : tmpModeMap.entrySet()) {
            FindMode mode = (FindMode)entry.getValue();
            if (!Utils.notBlankString((String)mode.getTitle()) || !Utils.notBlankString((String)mode.getValue()) || mode.getId() < 0) continue;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("add modeMap={}", (Object)mode);
            }
            this.modeMap.put(mode.getId(), mode);
        }
    }

    public Map<Integer, FindMode> getModeMap() {
        return this.modeMap;
    }

    public List<FindMode> getModeList() {
        ArrayList<FindMode> result = new ArrayList<FindMode>(this.modeMap.size());
        result.addAll(this.modeMap.values());
        return result;
    }
}

