/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeRecalculateManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.common.TimeUtils;

public abstract class RangeRecalculateDayManager
extends RangeRecalculateManager {
    protected PreparedStatement selectSumRangeTraffsPS;

    public RangeRecalculateDayManager(Connection con, Date dateFrom, Date dateTo, int moduleId, RangeManager manager) throws SQLException {
        super(con, dateFrom, dateTo, moduleId, manager);
    }

    @Override
    public void flushContract(int contractId) throws SQLException, BGException {
        TariffWorkerContext workerContext = (TariffWorkerContext)ServerContext.get();
        if (this.selectSumRangeTraffsPS == null) {
            String query = "SELECT SUM(amount), treeNodeId, rangeKey  FROM " + this.trafficRangeDetailTableName + " WHERE contractId = ?  GROUP BY treeNodeId, rangeKey";
            this.selectSumRangeTraffsPS = this.con.prepareStatement(query);
        }
        int idx = 1;
        this.selectSumRangeTraffsPS.setInt(idx++, contractId);
        ResultSet rs = this.selectSumRangeTraffsPS.executeQuery();
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        while (rs.next()) {
            long amount = rs.getLong(1);
            long treeNodeId = rs.getLong(2);
            long rangeKey = rs.getLong(3);
            this.updateRangeFromDetail(contractId, workerContext, affectedKeys, affectedNodes, amount, treeNodeId, rangeKey);
        }
        rs.close();
        this.deleteInvalidRangeTraffs(contractId, affectedKeys, affectedNodes);
    }

    protected void updateRangeFromDetail(int contractId, TariffWorkerContext workerContext, Set<Long> affectedKeys, Set<Long> affectedNodes, long amount, long treeNodeId, long rangeKey) throws BGException, SQLException {
        TrafficRangeEntry trafficRangeEntry = this.manager.getRangedTrafficEntry(contractId);
        TrafficRangeKey key = new TrafficRangeKey(treeNodeId, rangeKey);
        long maxAmount = this.getMaxAmount(contractId, workerContext, treeNodeId, trafficRangeEntry, key);
        TrafficRange prevRange = this.manager.getPrevMonthTraffic(TimeUtils.getStartMonth(this.dateFrom), workerContext, contractId, treeNodeId, rangeKey);
        TrafficRange value = new TrafficRange(0, amount += prevRange.amount, maxAmount);
        this.updateRangeTraffic(contractId, key, value);
        affectedKeys.add(key.getKey());
        affectedNodes.add(key.getTreeNodeId());
    }

    private long getMaxAmount(int contractId, TariffWorkerContext workerContext, long treeNodeId, TrafficRangeEntry trafficRangeEntry, TrafficRangeKey key) throws BGException {
        long maxAmount = 0L;
        TrafficRange monthValue = new TrafficRange(0, 0L, 0L);
        if (trafficRangeEntry != null && (monthValue = trafficRangeEntry.getTarfficRange(key)) == null) {
            monthValue = this.manager.getCurrentRangedTraffic(workerContext, contractId, treeNodeId, key.getKey());
            maxAmount = monthValue.maxAmount;
        }
        return maxAmount;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.selectSumRangeTraffsPS != null) {
            this.selectSumRangeTraffsPS.close();
        }
    }
}

