/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.convert;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ConvertLog {
    private Setup setup;
    private int mid;

    public static void main(String[] args) {
        if (args.length > 0) {
            new ConvertLog(args[0]);
        } else {
            System.out.println("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 mid");
        }
    }

    public ConvertLog(String midStr) {
        Connection con = null;
        try {
            this.mid = Utils.parseInt((String)midStr);
            if (this.mid == 0) {
                System.out.println("mid \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439");
                return;
            }
            this.setup = new Setup("data", "data");
            Setup.setSetup((Setup)this.setup);
            this.setup.initConnectionPool();
            con = this.setup.getDBConnection();
            this.convert(con);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ServerUtils.closeConnection(con);
        }
    }

    private void convert(Connection con) throws SQLException {
        ArrayList<Integer> errorList = new ArrayList<Integer>();
        int count = 0;
        System.out.println("start convert log agent for DrWeb...");
        String query = "SELECT id FROM drweb_contract_agent_log_" + this.mid + " WHERE tariff_id = 0 group by id ";
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(query);
        PreparedStatement psSelect = con.prepareStatement("SELECT tariff_id FROM drweb_contract_agent_" + this.mid + " WHERE id = ?");
        query = "UPDATE drweb_contract_agent_log_" + this.mid + " SET tariff_id=? WHERE id = ? AND  tariff_id = 0";
        PreparedStatement psUpdate = con.prepareStatement(query);
        while (rs.next()) {
            ++count;
            int id = rs.getInt("id");
            psSelect.setInt(1, id);
            ResultSet rsSelect = psSelect.executeQuery();
            if (rsSelect.next()) {
                int tariffId = rsSelect.getInt("tariff_id");
                psUpdate.setInt(1, tariffId);
                psUpdate.setInt(2, id);
                psUpdate.executeUpdate();
                continue;
            }
            System.out.println("error find tariff_id for agent => " + id);
            errorList.add(id);
        }
        System.out.println("stop convert agent for DrWeb...Ok");
        System.out.println("all agents => " + count);
        System.out.println("convert => " + (count - errorList.size()));
        System.out.println("convert ERROR=> " + errorList.size());
        System.out.print("error id  => ");
        Iterator iterator = errorList.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            System.out.print(id + ",");
        }
        System.out.println("");
        System.out.println("exit");
    }
}

