/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.fias.common.bean.Constant;
import ru.bitel.bgbilling.plugins.fias.common.bean.Region;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.AddressObj;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class FiasUtil {
    static Connection con = null;

    public static BGPluginServer getPlugin() {
        return BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.fias");
    }

    public static Path getFiasPath(String suffix) throws BGMessageException {
        BGPluginServer plugin = FiasUtil.getPlugin();
        Object pathStr = plugin.getSetup().get("file.path");
        if (pathStr == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043a\u0430\u0442\u0430\u043b\u043e\u0433 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438");
        }
        pathStr = (String)pathStr + suffix;
        Path dir = Paths.get((String)pathStr, new String[0]);
        return dir;
    }

    public static Connection getFiasConnection() throws BGException {
        try {
            if (con != null && con.isValid(1)) {
                return con;
            }
            BGPluginServer plugin = FiasUtil.getPlugin();
            String db_driver = plugin.getSetup().get("db.driver");
            String db_url = plugin.getSetup().get("db.url");
            String db_user = plugin.getSetup().get("db.user");
            String db_pswd = plugin.getSetup().get("db.pswd");
            Class.forName(db_driver);
            System.out.println("Connecting to database...");
            con = DriverManager.getConnection(db_url, db_user, db_pswd);
            return con;
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u0430 \u0441\u0432\u044f\u0437\u044c \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u043b\u044f \u0437\u0430\u0433\u0440\u0430\u0443\u0437\u043a\u0438 \u0424\u0418\u0410\u0421");
        }
    }

    public static List<Region> getLoadedRegion() throws BGException {
        ArrayList<Region> regionList = new ArrayList<Region>();
        Connection con = FiasUtil.getFiasConnection();
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SHOW TABLES LIKE 'addrobj%'");
            while (rs.next()) {
                String region = rs.getString(1).substring(7);
                if (!ServerUtils.tableExists((Connection)con, (String)("house" + region))) continue;
                regionList.add(new Region(region, "[" + region + "]" + (String)Constant.stateCod.get(region)));
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        return regionList;
    }

    public static List<City> getRegionCity(String regionId, String cityTitle) throws BGMessageException, BGException {
        ArrayList<City> list = new ArrayList<City>();
        Connection con = FiasUtil.getFiasConnection();
        try {
            Statement st = con.createStatement();
            StringBuilder sb = new StringBuilder("SELECT  shortname,offname,plaincode,aoguid,aolevel, postalcode, parentguid, regioncode FROM addrobj" + regionId + " WHERE actstatus=1 AND aolevel IN (4,5,6) AND ( offname = '0000000'   ");
            for (String like : cityTitle.split(" ")) {
                sb.append(" OR (offname LIKE '%" + like + "%' OR formalname LIKE '%" + like + "%')");
            }
            sb.append(" ) ORDER BY offname ");
            ResultSet rs = st.executeQuery(sb.toString());
            while (rs.next()) {
                City city = FiasUtil.loadAddressFromRs(new City(), rs);
                list.add(city);
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
        return list;
    }

    private static <T extends AddressObj> T loadAddressFromRs(T obj, ResultSet rs) throws SQLException {
        String shortname = rs.getString("shortname");
        String offname = rs.getString("offname");
        obj.setShortname(shortname);
        obj.setOffname(offname);
        obj.setCode(rs.getString("plaincode"));
        obj.setAoguid(rs.getString("aoguid"));
        obj.setLevel(rs.getString("aolevel"));
        obj.setPostalcode(rs.getString("postalcode"));
        obj.setParentguid(rs.getString("parentguid"));
        obj.setRegion(rs.getString("regioncode"));
        return obj;
    }

    public static void createTempStreetTable(String regionId, City city, AddressLoadManager fm) throws BGException {
        Connection con = FiasUtil.getFiasConnection();
        try {
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT shortname,offname,plaincode,aoguid,aolevel, postalcode, parentguid FROM addrobj" + regionId + " WHERE actstatus =1  AND parentguid='" + city.getAoguid() + "'");
            ArrayList<Street> streets = new ArrayList<Street>();
            while (rs.next()) {
                String shortname = rs.getString(1);
                String offname = rs.getString(2);
                Street street = new Street();
                street.setShortname(shortname);
                street.setOffname(offname);
                street.setCode(rs.getString("plaincode"));
                street.setAoguid(rs.getString("aoguid"));
                street.setLevel(rs.getString("aolevel"));
                street.setPostalcode(rs.getString("postalcode"));
                street.setParentguid(rs.getString("parentguid"));
                street.setRegion(regionId);
                streets.add(street);
            }
            rs.close();
            st.close();
            fm.createTempStreetTable(streets);
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public static void setParentsForCity(City city) throws BGException {
        BGLogger logger = new BGLogger(FiasUtil.class);
        if (logger.getLogger().isDebugEnabled()) {
            logger.getLogger().debug("setParentForCity start:" + city.getBgTitle() + "[" + city.getAoguid() + "]");
        }
        Connection con = FiasUtil.getFiasConnection();
        try {
            PreparedStatement ps = con.prepareStatement("SELECT shortname,offname,plaincode,aoguid,aolevel, postalcode , parentguid, regioncode FROM addrobj" + city.getRegion() + " WHERE actstatus =1  AND aoguid=?");
            String parentguid = city.getParentguid();
            logger.getLogger().debug("parentguid=" + parentguid);
            ArrayList<City> parents = new ArrayList<City>();
            while (!Utils.isEmptyString((String)parentguid)) {
                ps.setString(1, parentguid);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    logger.getLogger().debug("load..");
                    City parent = FiasUtil.loadAddressFromRs(new City(), rs);
                    parents.add(parent);
                    parentguid = parent.getParentguid();
                } else {
                    logger.getLogger().debug("clear");
                    parentguid = "";
                }
                rs.close();
            }
            ps.close();
            logger.getLogger().debug("load " + parents.size() + " parents");
            city.setParents(parents);
        }
        catch (SQLException ex) {
            throw new BGException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private static <T extends AddressObj> void syncAddressObj(T address) throws BGException {
        BGLogger logger = new BGLogger(FiasUtil.class);
        if (logger.getLogger().isDebugEnabled()) {
            logger.getLogger().debug("syncAddress start:" + address.getBgTitle() + "[" + address.getAoguid() + "]");
        }
        if (Utils.isEmptyString((String)address.getAoguid()) || Utils.isEmptyString((String)address.getRegion())) {
            return;
        }
        Connection con = FiasUtil.getFiasConnection();
        try {
            Statement st = con.createStatement();
            String query = "SELECT shortname,offname,plaincode,aoguid,aolevel, postalcode, parentguid, regioncode FROM addrobj" + address.getRegion() + "  WHERE actstatus=1 AND aoguid='" + address.getAoguid() + "'";
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                FiasUtil.loadAddressFromRs(address, rs);
                if (logger.getLogger().isDebugEnabled()) {
                    logger.getLogger().debug("syncAddress load" + address.getBgTitle() + "[" + address.getAoguid() + "]");
                }
            }
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    public static void syncCityList(List<City> cityList) throws BGException {
        BGLogger logger = new BGLogger(FiasUtil.class);
        logger.getLogger().debug("syncCity");
        for (City city : cityList) {
            if (logger.getLogger().isDebugEnabled()) {
                logger.getLogger().debug("syncCity start:" + city.getBgTitle() + "[" + city.getAoguid() + "]");
            }
            if (Utils.isEmptyString((String)city.getAoguid())) {
                logger.getLogger().debug("aoguid is empty");
                continue;
            }
            FiasUtil.syncAddressObj(city);
            FiasUtil.setParentsForCity(city);
        }
    }

    public static void syncStreetList(List<Street> streetList) throws BGException {
        for (Street street : streetList) {
            if (Utils.isEmptyString((String)street.getAoguid())) continue;
            FiasUtil.syncAddressObj(street);
        }
    }
}

