/**
 * Устанавливает в выпадающем списке выбранный параметр
 * @param sel ( select ) выпадающий список
 * @param selectedOption ( string ) опция, которая должна быть выбрана
*/

function setSelctedOption(sel, selectedOption){
	var optionMas = sel[0].options;
	for (j = 0; j < optionMas.length; j++) {
		var option = optionMas[j];
		if (optionMas[j].value == selectedOption) {
			optionMas[j].selected = true;
		}
	}
}
/**
 * Проверка значения
 * @param value проверяемое значение на null
 * @param defaultValue значение по умолчанию
 * @returns если value не равен null, то вернет value, а если равен то defaultValue
 * */
function getValue(value, defaultValue){
	if (value != null) 
		return value;
	else 
		return defaultValue;
}

/**
 * Проверка строки на null и пустоту
 * @param str проверяемая строка
 * @returns true если не пустая и не равна null
 * */
function notBlankString(str){
	return str != null && str.trim().length > 0;
}

/**
 * Валидация ipv4
 * @returns true елси проверка пройдена
 * */
function validationIpV4(ip){
	ip = ip.replace(/\s/g, "")
	var re = /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;
	if (re.test(ip)) {
		var parts = ip.split(".");
		if (parseInt(parseFloat(parts[0])) == 0) {
			return false;
		}
		if (parseInt(parseFloat(parts[3])) == 0) {
			return false;
		}
		for (var i = 0; i < parts.length; i++) {
			if (parseInt(parseFloat(parts[i])) > 255) {
				return false;
			}
		}
		return true;
	}
	else {
		return false;
	}
}

/**
 * Валидация ipv6
 * @returns true если проверка пройдена
 * */
function validationIpV6(ip){
	// Test for empty address
	if (ip.length < 3) {
		return ip == "::";
	}
	// Check if part is in IPv4 format
	if (ip.indexOf('.') > 0) {
		lastcolon = ip.lastIndexOf(':');
		if (!(lastcolon && validationIpV4(ip.substr(lastcolon + 1)))) {
			return false;
		}
		// replace IPv4 part with dummy
		ip = ip.substr(0, lastcolon) + ':0:0';
	}
	// Check uncompressed
	if (ip.indexOf('::') < 0) {
		var match = ip.match(/^(?:[a-f0-9]{1,4}:){7}[a-f0-9]{1,4}$/i);
		return match != null;
	}
	// Check colon-count for compressed format
	if (substr_count(ip, ':')) {
		var match = ip.match(/^(?::|(?:[a-f0-9]{1,4}:)+):(?:(?:[a-f0-9]{1,4}:)*[a-f0-9]{1,4})?$/i);
		return match != null;
	}
	// Not a valid IPv6 address
	return false;
}


// substr_count
function substr_count(haystack, needle, offset, length){
	var pos = 0, cnt = 0;
	haystack += '';
	needle += '';
	if (isNaN(offset)) {
		offset = 0;
	}
	if (isNaN(length)) {
		length = 0;
	}
	offset--;
	
	while ((offset = haystack.indexOf(needle, offset + 1)) != -1) {
		if (length > 0 && (offset + needle.length) > length) {
			return false;
		}
		else {
			cnt++;
		}
	}
	return cnt;
}