/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean.export;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.XMLUtils;

public class ExportAbstractUtils
extends AbstarctDaoConstant {
    protected ModuleSetup moduleSetup;
    protected char csvSeparator;
    protected String saveOnServerPath;

    protected ExportAbstractUtils(Connection con, int moduleId) {
        super(con, moduleId);
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
    }

    protected void preemptBillNew(List<? extends BillDoc> payBillList, String preemptXSL, boolean saveOnServer, Writer writer, StringBuilder sb) {
        for (BillDoc billDoc : payBillList) {
            try {
                Document billDoc2 = billDoc.getDocument();
                if (billDoc2 != null) {
                    StreamResult sr = new StreamResult(writer);
                    XMLUtils.transform((Source)new DOMSource(billDoc2), (Source)new StreamSource(new File("webroot/xsl/" + preemptXSL)), (Result)sr, (String)"UTF-8");
                    if (saveOnServer) continue;
                    sb.append(((StringWriter)writer).toString());
                    ((StringWriter)writer).getBuffer().setLength(0);
                    continue;
                }
                this.getLogger().error("XML is NULL, billNumber = {}", (Object)billDoc.getNumber());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    protected void preemptBillOld(List<String[]> allLines, boolean saveOnServer, Writer writer, StringBuilder sb) {
        try {
            CSVWriter csvWriter = new CSVWriter(writer, this.csvSeparator);
            csvWriter.writeAll(allLines);
            csvWriter.flush();
            csvWriter.close();
            if (saveOnServer) {
                writer.close();
            } else {
                sb.append(writer.toString());
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

