/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Dealer;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class DealerManager {
    private Connection con;
    private int mid;

    public DealerManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<Dealer> getDealerList() throws BGException {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        try {
            String query = "SELECT * FROM dealer_" + this.mid + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(DealerManager.getDealerFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<Dealer> getDealerList(String title, Date start, Date end) throws BGException {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        title = "%" + (String)title + "%";
        try {
            StringBuffer query = new StringBuffer("SELECT * FROM ");
            query.append("dealer_" + this.mid);
            if (start != null || end != null || title != null) {
                query.append(" WHERE ");
                if (title != null) {
                    query.append("(title LIKE ?)");
                    if (start != null || end != null) {
                        query.append(" AND");
                    }
                }
                if (start != null) {
                    query.append(" (date1 IS NULL OR TO_DAYS(date1)>=TO_DAYS('");
                    query.append(TimeUtils.convertDateToSqlDate((Date)start));
                    query.append("'))");
                }
                if (start != null && end != null) {
                    query.append(" AND");
                }
                if (end != null) {
                    query.append(" (date2 IS NULL OR TO_DAYS(date2)<=TO_DAYS('");
                    query.append(TimeUtils.convertDateToSqlDate((Date)end));
                    query.append("'))");
                }
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setString(1, (String)title);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(DealerManager.getDealerFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void deleteDealer(int id) throws BGException {
        try {
            String query = "DELETE FROM dealer_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public Dealer getDealer(int id) throws BGException {
        Dealer result = null;
        try {
            String query = "SELECT * FROM dealer_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = DealerManager.getDealerFromRs(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void updateDealer(Dealer dealer) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (dealer.getId() <= 0) {
                query = "INSERT INTO dealer_" + this.mid + " (title, date1, date2, comment ) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                query = "UPDATE dealer_" + this.mid + " SET title=?, date1=?, date2=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, dealer.getId());
            }
            ps.setString(1, dealer.getTitle());
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)dealer.getDate1()));
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)dealer.getDate2()));
            ps.setString(4, dealer.getComment());
            ps.executeUpdate();
            if (dealer.getId() <= 0) {
                dealer.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private static Dealer getDealerFromRs(ResultSet rs) throws SQLException {
        Dealer result = new Dealer();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setDate1((Date)rs.getDate("date1"));
        result.setDate2((Date)rs.getDate("date2"));
        result.setComment(rs.getString("comment"));
        return result;
    }
}

