/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events;

import bitel.billing.server.contract.bean.ContractAddressParamValue;
import bitel.billing.server.contract.bean.ContractEmailParamValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamItem;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.PhoneParamValue;
import ru.bitel.bgbilling.kernel.event.common.LocalEvent;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrMultiList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

@XmlRootElement
public class ContractParamBeforeChangeEvent
extends LocalEvent {
    private int paramId;
    private Object value;
    private String error;
    private EntityAttr entityAttr;

    protected ContractParamBeforeChangeEvent() {
    }

    public ContractParamBeforeChangeEvent(int userId, int contractId, int parameterId, Object value) {
        super(0, contractId, userId);
        this.paramId = parameterId;
        if (value instanceof EntityAttr) {
            this.entityAttr = (EntityAttr)value;
            this.value = ContractParamBeforeChangeEvent.convertEntityAttrToOldValue(this.entityAttr);
        } else {
            this.value = value;
        }
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public void setError(String error) {
        this.error = error;
    }

    public int getParamId() {
        return this.paramId;
    }

    public Object getValue() {
        return this.value;
    }

    public EntityAttr getEntityAttr() {
        return this.entityAttr;
    }

    static Object convertEntityAttrToOldValue(EntityAttr entityAttr) {
        if (entityAttr == null) {
            return null;
        }
        switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entityAttr.getType()).get()) {
            case DATE: {
                return ((EntityAttrDate)entityAttr).getValue();
            }
            case TEXT: {
                return ((EntityAttrText)entityAttr).getValue();
            }
            case LIST: {
                return ((EntityAttrList)entityAttr).getValue();
            }
            case BOOLEAN: {
                return ((EntityAttrBoolean)entityAttr).getValue();
            }
            case CONTRACT: {
                return ((EntityAttrContract)entityAttr).getValue();
            }
            case ADDRESS: {
                EntityAttrAddress a = (EntityAttrAddress)entityAttr;
                return new ContractAddressParamValue().setHouseId(a.getHouseId()).setFlat(a.getFlat()).setRoom(a.getRoom()).setPod(a.getPod()).setFloor(a.getFloor()).setComment(a.getComment()).setFormatKey(a.getFormatKey()).setAddress(a.getTitle());
            }
            case EMAIL: {
                EntityAttrEmail a = (EntityAttrEmail)entityAttr;
                return new ContractEmailParamValue().setEmailId(0).setEmail(a.getData()).setMailSet(Collections.emptySet());
            }
            case PHONE: {
                EntityAttrPhone a = (EntityAttrPhone)entityAttr;
                PhoneParamValue value = new PhoneParamValue();
                if (a.getContactList() != null) {
                    a.getContactList().forEach(contact -> value.addPhoneItem(new PhoneParamItem().setPhone(contact.getPhone()).setFormat("").setComment(contact.getComment())));
                }
                value.setPhones(a.getData());
                return value;
            }
            case MULTILIST: {
                EntityAttrMultiList a = (EntityAttrMultiList)entityAttr;
                MultiListParamValues value = new MultiListParamValues();
                value.parseTitleValue(a.getTitle());
                return value;
            }
        }
        return entityAttr;
    }
}

