/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.function.Async;

public class StatusLogPanel
extends BGUPanel {
    private int objectId = 0;
    private JLabel logCount = new JLabel();
    private BGControlPanelPages pages = new BGControlPanelPages();
    private BGDataSourceTableModel statusLogTableModel = new BGDataSourceTableModel("StatusLog");
    private ContractStatusService contractStatusService = null;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanle(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(new JScrollPane((Component)new BGUTable((TableModel)((Object)this.statusLogTableModel))), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.pages.addPropertyChangeListener(a -> {
            if (a.getPropertyName().startsWith("to")) {
                this.loadStatusLogData();
            }
        });
    }

    private JPanel getTopPanle() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.logCount, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.pages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
        return panel;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public void loadStatusLogData() {
        this.statusLogTableModel.deleteRows();
        this.pages.getPage().setPageCount(0);
        if (this.objectId > -1) {
            Async.ofWithTry(() -> {
                BGUTableParams tableParams = new BGUTableParams().setContractId(((ClientContext)this.getContext()).getContractId()).addParam("objectId", this.objectId).setPage(this.pages.getPage());
                this.statusLogTableModel.loadData((ClientContext)this.getContext(), tableParams, this.pages, this.logCount);
            });
        }
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = (ContractStatusService)((ClientContext)this.getContext()).getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.pages.setPageIndex(1);
            this.loadStatusLogData();
        });
    }
}

