/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi.portal.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import ru.bitel.bgbilling.kernel.wifi.GlobalConfig;
import ru.bitel.bgbilling.kernel.wifi.WiFiManager;
import ru.bitel.bgbilling.kernel.wifi.common.WiFiUtil;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.BGNestedContext;

public class AuthFilter
implements Filter {
    ServletContext context = null;
    private WiFiManager manager = null;

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        BGNestedContext.push((String)"portal");
        try {
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            String target = request.getParameter("target");
            if (!Utils.isEmptyString((String)target)) {
                request.getSession().setAttribute("originalTarget", (Object)target);
            }
            if (!this.doAuth(request, response)) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
        finally {
            BGNestedContext.pop();
        }
    }

    private boolean doAuth(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GlobalConfig cfg = GlobalConfig.getGlobalConfig();
        String ip = ServletUtils.getIpFromHeader(request, cfg.getHeaderNameRemoteAddress());
        String uri = request.getRequestURI().toLowerCase();
        if (!(this.isUserLoged(ip) || uri.startsWith("/auth") || uri.endsWith(".css") || uri.endsWith(".jpg") || uri.endsWith(".gif") || uri.endsWith(".html") || uri.endsWith(".shtml") || uri.startsWith("/password.do") || uri.endsWith(".js") || uri.endsWith(".png") || uri.endsWith(".svg") || uri.endsWith(".woff"))) {
            response.sendRedirect("/auth.do");
            return true;
        }
        return false;
    }

    public void init(FilterConfig cfg) throws ServletException {
        this.context = cfg.getServletContext();
        this.manager = (WiFiManager)this.context.getAttribute("manager");
    }

    private boolean isUserLoged(String ip) {
        return this.manager.isIpAlive(WiFiUtil.getIp(ip), false);
    }
}

