/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.recalculate;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.RangeDayFlushingManager;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.SessionFlusher;
import ru.bitel.bgbilling.apps.voice.accounting.recalculate.RangeRecalculateFlushingManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.managed.ServerContextThreadFactory;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionAccountLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.mail.MailTaskRecalculator;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAbtractAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.TaskDistrubuter;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;

public class VoiceRecalculator
extends RunTask {
    private Date dateFrom;
    private Date dateTo;
    private Set<Integer> cids;
    private long groupMask;
    private String email;
    private String comment;
    private final int moduleId;
    private int maxSessionFetch;
    private ResultSet sessionRS;

    public VoiceRecalculator(Date dateFrom, Date dateTo, Set<Integer> cids, long groupMask, String email, String comment, int moduleId) {
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.cids = cids;
        this.groupMask = groupMask;
        this.email = email;
        this.comment = comment;
        this.moduleId = moduleId;
    }

    public VoiceRecalculator init(Setup setup) throws Exception {
        super.init(setup);
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        this.maxSessionFetch = moduleSetup.getInt("session.fetch.size", 10000);
        return this;
    }

    public String getDescription() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        VoiceTariffWorkerContext voiceTariffWorkerContext = new VoiceTariffWorkerContext(this.setup, this.moduleId);
        ServerContext parentContext = (ServerContext)ServerContext.get();
        ServerContext.push((ThreadContext)voiceTariffWorkerContext);
        long start = System.currentTimeMillis();
        try {
            this.calculate(voiceTariffWorkerContext.getConnectionSet());
        }
        catch (Exception ex) {
            this.logError("fatal error while voice recalcate sessions", ex);
        }
        finally {
            ServerContext.pop((ThreadContext)voiceTariffWorkerContext, (ThreadContext)parentContext);
        }
        long end = System.currentTimeMillis();
        if (this.email != null) {
            StringBuffer report = new StringBuffer("\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0451\u0442 \u0441\u0435\u0441\u0441\u0438\u0439 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d\n");
            report.append("\u0412\u0440\u0435\u043c\u044f: ");
            report.append(TimeUtils.formatDeltaTime((long)((end - start) / 1000L)));
            report.append("\n\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:  " + this.comment);
            try {
                new MailMsg((Preferences)this.setup).sendMessage(new MailTaskRecalculator().setModuleId(this.moduleId).setRecipients(this.email).setSubject("\u041f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0451\u0442 \u0441\u0435\u0441\u0441\u0438\u0439 \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d").addTextPart("text", report.toString()));
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    protected void calculate(ConnectionSet connectionSet) throws Exception {
        VoiceTariffContext tariffContext = new VoiceTariffContext(this.dateFrom, this.moduleId, connectionSet.getConnection());
        tariffContext.setRuntime(false);
        this.setup.set("moduleId", String.valueOf(this.moduleId));
        VoiceApplication application = new VoiceApplication(this.setup, false);
        List<VoiceSession> list = null;
        HashMap<Integer, Map<Integer, BigDecimal>> contractAccounts = new HashMap<Integer, Map<Integer, BigDecimal>>();
        int count = 0;
        try (Connection sessionCon = this.setup.getDBConnectionFromPool();){
            this.clearAccountRuntimes(sessionCon, application);
            this.initSessionRS(sessionCon);
            while ((list = this.getSessionsFromDB()).size() > 0) {
                this.doSessions(sessionCon, tariffContext, application, list, contractAccounts);
                this.updateRanges(tariffContext, list);
                count += list.size();
                if (!this.getLogger().isDebugEnabled()) continue;
                this.getLogger().info("session count=" + count);
            }
        }
        this.updateAccountAndBalance(connectionSet, contractAccounts);
    }

    private void clearAccountRuntimes(Connection connection, VoiceApplication application) throws Exception {
        VoiceAccountRuntimeMap.getInstance(connection, application, this.dateFrom).load(connection, this.dateFrom);
        VoiceOperAccountRuntimeMap.getInstance(connection, application, this.dateFrom).load(connection, this.dateFrom);
    }

    private void updateAccountAndBalance(ConnectionSet connectionSet, Map<Integer, Map<Integer, BigDecimal>> contractAccounts) throws BGException, SQLException, Exception {
        ContractRuntimeMap contractRuntimeMap = ContractRuntimeMap.getInstance();
        List serviceList = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
        Set<Integer> allServices = serviceList.stream().map(l -> l.getId()).collect(Collectors.toSet());
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
            this.updateBalanceAndAccount(connectionSet, contractRuntimeMap, allServices, contractAccounts, balanceDao);
        }
    }

    private void initSessionRS(Connection sessionCon) throws BGException {
        String sessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)this.dateFrom, (int)this.moduleId);
        if (!ServerUtils.tableExists((Connection)sessionCon, (String)sessionTable)) {
            return;
        }
        StringBuilder query = new StringBuilder("SELECT session.* ");
        query.append(" FROM " + sessionTable + " AS session");
        query.append(" LEFT JOIN contract ON session.contractId = contract.id ");
        query.append(" WHERE  1=1 ");
        query.append(" AND  session.sessionStart>=?");
        query.append(" AND session.sessionStart<?");
        if (this.groupMask != 0L) {
            query.append(" AND contract.gr & " + this.groupMask + " > 0 ");
        }
        if (Utils.notEmptyCollection(this.cids)) {
            query.append(" AND session.contractId IN (" + Utils.toString(this.cids) + ")");
        }
        query.append(" ORDER BY session.sessionStart ");
        try {
            PreparedStatement ps = sessionCon.prepareStatement(query.toString());
            ps.setFetchSize(this.maxSessionFetch);
            int index = 1;
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)this.dateFrom));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)this.dateTo));
            this.sessionRS = ps.executeQuery();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        this.getLogger().info("end reading sessions");
    }

    private void doSessions(Connection connection, VoiceTariffContext tariffContext, VoiceApplication application, List<VoiceSession> list, Map<Integer, Map<Integer, BigDecimal>> contractAccounts) throws BGException, SQLException, InterruptedException, Exception {
        VoiceAccountRuntimeMap voiceAccountRuntimeMap = VoiceAccountRuntimeMap.getInstance(connection, application, this.dateFrom);
        VoiceOperAccountRuntimeMap voiceOperAccountRuntimeMap = VoiceOperAccountRuntimeMap.getInstance(connection, application, this.dateFrom);
        try (VoiceSessionLogDao sessionDao = new VoiceSessionLogDao(connection, this.moduleId, this.dateFrom);
             VoiceSessionAccountLogDao voiceSessionAccountDAO = new VoiceSessionAccountLogDao(connection, this.moduleId, this.dateFrom);){
            ArrayList<VoiceSessionRuntime> listRuntime = new ArrayList<VoiceSessionRuntime>();
            for (VoiceSession session : list) {
                session.setSessionCost(BigDecimal.ZERO);
                VoiceAbtractAccountRuntime accountRuntime = this.getAccountRuntime(voiceAccountRuntimeMap, voiceOperAccountRuntimeMap, session);
                if (accountRuntime == null) {
                    this.getLogger().error("AccountRuntime is null for sessionId = " + session.getId());
                    continue;
                }
                VoiceSessionRuntime sessionRuntime = new VoiceSessionRuntime(session, accountRuntime);
                sessionRuntime.calculate(tariffContext, null, true);
                listRuntime.add(sessionRuntime);
                Map<Integer, BigDecimal> accountMap = contractAccounts.get(session.getContractId());
                if (accountMap == null) {
                    accountMap = new HashMap<Integer, BigDecimal>();
                    contractAccounts.put(session.getContractId(), accountMap);
                }
                for (Map.Entry<Integer, SessionAccountAmount> entry : sessionRuntime.getAccountDeltaMap().entrySet()) {
                    int serviceId = entry.getKey();
                    BigDecimal delta = entry.getValue().getAccount().setScale(5, RoundingMode.HALF_EVEN);
                    BigDecimal account = accountMap.get(serviceId);
                    if (account == null) {
                        account = BigDecimal.ZERO;
                        accountMap.put(serviceId, account);
                    }
                    account = account.add(delta, MathContext.DECIMAL64);
                    accountMap.put(serviceId, account);
                }
            }
            for (VoiceSession session : list) {
                sessionDao.update(session);
            }
            voiceSessionAccountDAO.deleteAccounts(list);
            SessionFlusher.insertAccount(voiceSessionAccountDAO, listRuntime);
        }
    }

    private void updateBalanceAndAccount(ConnectionSet connectionSet, ContractRuntimeMap contractRuntimeMap, Set<Integer> allServices, Map<Integer, Map<Integer, BigDecimal>> contractAccounts, BalanceDao balanceDao) throws BGException, SQLException {
        Calendar cal = TimeUtils.convertDateToCalendar((Date)this.dateFrom);
        int yy = cal.get(1);
        int mm = cal.get(2) + 1;
        balanceDao.removeContractAccount(yy, mm, this.cids, Utils.toString(allServices), this.groupMask);
        for (Map.Entry<Integer, Map<Integer, BigDecimal>> entry : contractAccounts.entrySet()) {
            int contractId = entry.getKey();
            Map<Integer, BigDecimal> accounts = entry.getValue();
            for (Map.Entry<Integer, BigDecimal> entry2 : accounts.entrySet()) {
                int serviceId = entry2.getKey();
                BigDecimal account = entry2.getValue();
                balanceDao.setContractAccount(contractId, yy, mm, serviceId, account);
            }
            ContractRuntime contractRuntime = contractRuntimeMap.getContractRuntime(connectionSet, Integer.valueOf(contractId));
            if (contractRuntime == null) {
                this.getLogger().error("contractRuntime is null for contractId = " + contractId);
                continue;
            }
            balanceDao.setBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm);
        }
    }

    private VoiceAbtractAccountRuntime getAccountRuntime(VoiceAccountRuntimeMap voiceAccountRuntimeMap, VoiceOperAccountRuntimeMap voiceOperAccountRuntimeMap, VoiceSession session) {
        VoiceAbtractAccountRuntime accountRuntime = voiceAccountRuntimeMap.get(session.getAccountId());
        if (accountRuntime == null) {
            accountRuntime = voiceOperAccountRuntimeMap.findById(session.getAccountId());
        }
        return accountRuntime;
    }

    private void deleteCarbage(ConnectionSet connectionSet, Set<Integer> allServices, Set<Integer> affectedContracts) throws BGException {
        try {
            String query = "DELETE FROM contract_account where sid in (" + Utils.toString(allServices) + ") ";
            if (Utils.notEmptyCollection(this.cids)) {
                query = query + " AND cid IN (" + Utils.toString(this.cids) + ")";
            }
            query = query + " AND cid NOT IN (" + Utils.toString(affectedContracts) + ")";
            PreparedStatement ps = connectionSet.getConnection().prepareStatement(query);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateRanges(VoiceTariffContext tariffContext, List<VoiceSession> list) throws InterruptedException, SQLException, BGException {
        int rangeFlushCount = 3;
        ServerContextThreadFactory flushRangeContextFactory = new ServerContextThreadFactory(this.setup, this.moduleId, null, null, true);
        TaskDistrubuter flushRangeDistrubuter = new TaskDistrubuter(rangeFlushCount, this.setup, (ThreadContextFactory)flushRangeContextFactory, "rangeFlusher");
        Calendar currentDay = null;
        HashMap<Integer, Set<Integer>> affectedDaysForContracts = new HashMap<Integer, Set<Integer>>();
        for (VoiceSession session : list) {
            Calendar sessionDay = TimeUtils.convertDateToCalendar((Date)session.getSessionStart());
            if (currentDay != null && sessionDay.get(5) != currentDay.get(5)) {
                this.flushDay(tariffContext, rangeFlushCount, (TaskDistrubuter<RangeDayFlushingManager, ServerContext>)flushRangeDistrubuter, currentDay, affectedDaysForContracts);
            }
            currentDay = sessionDay;
        }
        if (currentDay != null) {
            this.flushDay(tariffContext, rangeFlushCount, (TaskDistrubuter<RangeDayFlushingManager, ServerContext>)flushRangeDistrubuter, currentDay, affectedDaysForContracts);
        }
        flushRangeDistrubuter.finish();
        RangeRecalculateFlushingManager manager = new RangeRecalculateFlushingManager(this.setup, tariffContext, this.moduleId, affectedDaysForContracts);
        manager.flushMonthRange(this.dateFrom);
    }

    protected void flushDay(VoiceTariffContext tariffContext, int rangeFlushCount, TaskDistrubuter<RangeDayFlushingManager, ServerContext> flushRangeDistrubuter, Calendar currentDay, Map<Integer, Set<Integer>> affectedDaysForContracts) throws InterruptedException {
        for (int i = 0; i < rangeFlushCount; ++i) {
            flushRangeDistrubuter.putNextTask((Callable)new RangeDayFlushingManager(currentDay.getTime(), this.moduleId, i, rangeFlushCount, tariffContext, affectedDaysForContracts));
        }
    }

    private List<VoiceSession> getSessionsFromDB() throws SQLException, BGException {
        ArrayList<VoiceSession> result = new ArrayList<VoiceSession>();
        if (this.sessionRS == null) {
            return null;
        }
        int count = 0;
        while (this.sessionRS.next()) {
            VoiceSession session = VoiceSessionLogDao.getSessionFromRs(this.sessionRS);
            result.add(session);
            if (++count < this.maxSessionFetch) continue;
            return result;
        }
        return result;
    }
}

