/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.certificate.common.bean;

import java.nio.ByteBuffer;
import ru.bitel.bgbilling.kernel.admin.certificate.common.bean.OidMap;

public class Ans1Block {
    int blockClass;
    boolean blockSingle;
    int blockLen;
    int blockTagId;
    byte[] blockBytes;

    public Ans1Block(ByteBuffer byteBuffer) {
        int b = byteBuffer.get() & 0xFF;
        this.blockClass = (b & 0xC0) >> 6;
        this.blockSingle = ((b &= 0x3F) & 0x20) == 0;
        this.blockTagId = b & 0x1F;
        this.blockLen = this.ans1BlockLen(byteBuffer);
        this.blockBytes = new byte[this.blockLen];
        byteBuffer.get(this.blockBytes);
    }

    private int ans1BlockLen(ByteBuffer byteBuffer) {
        int b = byteBuffer.get() & 0xFF;
        if ((b & 0x80) == 0) {
            return b & 0x7F;
        }
        int len = 0;
        for (int lenBytes = b & 0x7F; lenBytes > 0; --lenBytes) {
            len = len << 8 | byteBuffer.get() & 0xFF;
        }
        return len;
    }

    public String toString() {
        try {
            if (this.blockTagId == 6) {
                String objId = null;
                int index = 0;
                while (index < this.blockBytes.length) {
                    int intVal = 0;
                    int nextByte = 0;
                    do {
                        nextByte = this.blockBytes[index++] & 0xFF;
                        intVal = intVal << 7 | nextByte & 0x7F;
                    } while ((nextByte & 0x80) > 0);
                    if (objId == null) {
                        if (intVal < 40) {
                            objId = "0." + intVal;
                            continue;
                        }
                        if (intVal < 80) {
                            objId = "1." + (intVal - 40);
                            continue;
                        }
                        objId = "2." + (intVal - 80);
                        continue;
                    }
                    objId = objId + "." + intVal;
                }
                return OidMap.oidMap.getOrDefault(objId, objId);
            }
            if (this.blockTagId == 12) {
                return new String(this.blockBytes, "UTF-8");
            }
            if (this.blockTagId == 19) {
                return new String(this.blockBytes, "Latin1");
            }
            if (this.blockTagId == 22) {
                return new String(this.blockBytes, "ASCII");
            }
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return String.valueOf(this.blockTagId);
    }

    public int getBlockClass() {
        return this.blockClass;
    }

    public boolean isBlockSingle() {
        return this.blockSingle;
    }

    public int getBlockLen() {
        return this.blockLen;
    }

    public int getBlockTagId() {
        return this.blockTagId;
    }

    public byte[] getBlockBytes() {
        return this.blockBytes;
    }
}

