/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.aots.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractAccountDetail;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.modules.aots.common.bean.AOTSContractService;
import ru.bitel.bgbilling.modules.aots.common.service.AOTSService;
import ru.bitel.bgbilling.modules.aots.server.bean.AOTSContractServiceDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.aots.common.service.AOTSService")
public class AOTSServiceImpl
extends AbstractService
implements AOTSService {
    private AOTSContractServiceDao aotsContractServiceDao;

    @PostConstruct
    protected void init() {
        this.aotsContractServiceDao = new AOTSContractServiceDao(this.getConnection(), this.moduleId);
    }

    public boolean aotsContractServiceDelete(String id) throws BGException {
        return (Boolean)this.tryReturn(() -> {
            boolean result = false;
            AOTSContractService aotsContractService = this.aotsContractServiceDao.getById(id);
            if (aotsContractService != null && (result = this.aotsContractServiceDao.deleteById(id))) {
                this.setBalanceAccount(aotsContractService);
            }
            return result;
        });
    }

    public AOTSContractService aotsContractServiceNew(int contractId) throws BGException {
        return new AOTSContractService().setContractId(contractId).setServiceTime(LocalDateTime.now()).setAmount(BigDecimal.ONE).setCost(BigDecimal.ZERO).setNdsRate(new BigDecimal(20)).setServiceSum(BigDecimal.ZERO);
    }

    public AOTSContractService aotsContractServiceGet(String data) throws BGException {
        return (AOTSContractService)this.tryReturn(() -> this.aotsContractServiceDao.getById(data));
    }

    public List<IdTitle> aotsServiceList(int serviceId) throws BGException {
        List services = ModuleCache.getInstance().getModuleServicesList(this.moduleId);
        return services.stream().filter(a -> a.isUsing() || a.getId() == serviceId).map(IdTitle::toIdTitle).toList();
    }

    public void aotsContractServiceUpdate(int contractId, AOTSContractService contractService) throws BGException {
        Objects.requireNonNull(contractService, "contractService must be not null");
        contractService.setContractId(contractId);
        if (contractService.getId() == null && contractService.getServiceTime().toLocalDate().isEqual(LocalDate.now())) {
            contractService.setServiceTime(LocalDateTime.now());
        }
        contractService.setUserId(this.userId);
        this.tryCall(() -> {
            AOTSContractService oldAotsContractService = null;
            if (contractService.getId() != null) {
                oldAotsContractService = this.aotsContractServiceDao.getById(contractService.getId());
            }
            this.aotsContractServiceDao.update(contractService);
            LocalDate newTime = contractService.getServiceTime().toLocalDate();
            if (oldAotsContractService != null) {
                LocalDate oldTime = oldAotsContractService.getServiceTime().toLocalDate();
                if (newTime.getYear() != oldTime.getYear() || newTime.getMonthValue() != oldTime.getMonthValue()) {
                    this.setBalanceAccount(oldAotsContractService);
                }
            }
            this.setBalanceAccount(contractService);
        });
    }

    private void setBalanceAccount(AOTSContractService aotsContractService) throws Exception {
        Objects.requireNonNull(aotsContractService, "aotsContractService must be not null");
        int contractId = aotsContractService.getContractId();
        int objectId = 0;
        int entityModuleId = 0;
        int entityId = 0;
        String objectTitle = "";
        int serviceId = aotsContractService.getServiceId();
        LocalDate serviceTime = aotsContractService.getServiceTime().toLocalDate();
        Contract contract = ContractDao.getContract((Connection)this.getConnection(), (int)contractId);
        int year = serviceTime.getYear();
        int month = serviceTime.getMonthValue();
        List<AOTSContractService> aotsContractServices = this.aotsContractServiceDao.list(contractId, serviceId, year, month);
        try (BalanceDao balanceDao = new BalanceDao(this.getConnection());
             BalanceUtils balanceUtils = new BalanceUtils(this.getConnection());){
            BigDecimal serviceSum = aotsContractServices.stream().map(a -> a.getServiceSum()).reduce(BigDecimal.ZERO, BigDecimal::add);
            balanceDao.setContractAccount(contractId, year, month, serviceId, serviceSum);
            balanceUtils.updateBalance(TimeUtils.convertLocalDateToDate((LocalDate)serviceTime), contract);
            balanceDao.removeContractAccountDetail(contractId, year, month, Arrays.asList(serviceId));
            List<ContractAccountDetail> contractAccountDetails = aotsContractServices.stream().map(a -> ContractAccountDetail.builder().setContractId(a.getContractId()).setObjectId(objectId).setServiceId(a.getServiceId()).setEntityModuleId(entityModuleId).setEntityId(entityId).setEntityTitle((objectId > 0 ? "\u041e\u0431\u044a\u0435\u043a\u0442: " + objectTitle + "[ID#" + objectId + "]" : "\u0414\u043e\u0433\u043e\u0432\u043e\u0440: " + contract.getTitle()) + (String)(entityModuleId > 0 ? " [" + entityModuleId + ":" + entityId + "]" : "")).setPeriod(new Period(a.getServiceTime().toLocalDate(), a.getServiceTime().toLocalDate())).setAmount(a.getAmount()).setCost(a.getCost().add(a.getCost().multiply(a.getNdsRate().divide(new BigDecimal("100"))))).setSum(a.getServiceSum()).setComment(a.getComment()).build()).toList();
            balanceDao.addContractAccountDetail(contractAccountDetails);
        }
    }
}

