/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.bill.common.bean.DocumentPosition;
import ru.bitel.bgbilling.modules.bill.common.bean.Position;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ContractIdable;

public class PositionValue
implements ContractIdable {
    private int positionId;
    private int contractId;
    private String name;
    private BigDecimal cost = BigDecimal.ZERO;
    private BigDecimal sum;
    private BigDecimal nds = BigDecimal.ZERO;
    private BigDecimal sumUnscaled;
    private BigDecimal sumScaled;
    private BigDecimal quantity;
    private int qtyNumsAfterComma = 0;
    private int qtyNumsRoundingMode = 4;
    private String unit;
    private String unitCode;
    private List<PositionValue> extractPositions;
    private Position position;
    private boolean inSumm;
    private boolean awlz;
    private Map<String, String> params = new HashMap<String, String>();

    public boolean isAddWhenLessZero() {
        return this.awlz;
    }

    public void setAddWhenLessZero(boolean awlz) {
        this.awlz = awlz;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
        if (position != null) {
            this.params = position.getParams();
        }
    }

    public List<PositionValue> getExtractPositions() {
        return this.extractPositions;
    }

    public void setExtractPositions(List<PositionValue> extractPositions) {
        this.extractPositions = extractPositions;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal val) {
        this.quantity = val;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUnitCode() {
        return this.unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal getCost() {
        return this.cost;
    }

    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    public BigDecimal getSum() {
        return this.sum;
    }

    public void setSum(BigDecimal sum) {
        this.sum = sum.setScale(2, RoundingMode.HALF_UP);
    }

    public BigDecimal getNds() {
        return this.nds;
    }

    public void setNds(BigDecimal nds) {
        this.nds = nds;
    }

    public int getPositionId() {
        return this.positionId;
    }

    public void setPositionId(int positionId) {
        this.positionId = positionId;
    }

    @Deprecated
    public int getCid() {
        return this.getContractId();
    }

    public int getContractId() {
        return this.contractId;
    }

    @Deprecated
    public void setCid(int cid) {
        this.setContractId(cid);
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public void toElement(Element el) {
        el.setAttribute("position_id", String.valueOf(this.positionId));
        el.setAttribute("name", this.name);
        el.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.sum));
        el.setAttribute("nds", String.valueOf(this.nds));
        el.setAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)(this.sumUnscaled != null ? this.sumUnscaled : this.sum), (int)5));
        el.setAttribute("unit", this.unit);
        el.setAttribute("unitCode", this.unitCode);
        el.setAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtyNumsAfterComma, this.qtyNumsRoundingMode).toString());
        el.setAttribute("qtynums", String.valueOf(this.qtyNumsAfterComma));
        el.setAttribute("qtynumsRnd", String.valueOf(this.qtyNumsRoundingMode));
        el.setAttribute("insum", this.inSumm ? "1" : "0");
        el.setAttribute("awlz", this.awlz ? "1" : "0");
        if (this.params != null) {
            for (String name : this.params.keySet()) {
                el.setAttribute(name, this.params.get(name));
            }
        }
    }

    public void toElement(XMLStreamWriter el) throws XMLStreamException {
        el.writeAttribute("position_id", String.valueOf(this.positionId));
        el.writeAttribute("name", this.name != null ? this.name : "");
        el.writeAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.sum));
        el.writeAttribute("nds", String.valueOf(this.nds));
        if (this.sumUnscaled != null) {
            el.writeAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)this.sumUnscaled, (int)5));
        } else {
            el.writeAttribute("sumUnscaled", Utils.formatBigDecimal((BigDecimal)this.sum, (int)5));
        }
        el.writeAttribute("unit", this.unit != null ? this.unit : "");
        el.writeAttribute("unitCode", this.unitCode != null ? this.unitCode : "");
        el.writeAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtyNumsAfterComma, this.qtyNumsRoundingMode).toString());
        el.writeAttribute("qtynums", String.valueOf(this.qtyNumsAfterComma));
        el.writeAttribute("qtynumsRnd", String.valueOf(this.qtyNumsRoundingMode));
        el.writeAttribute("insum", this.inSumm ? "1" : "0");
        el.writeAttribute("awlz", this.awlz ? "1" : "0");
        for (String name : this.params.keySet()) {
            String value = this.params.get(name);
            el.writeAttribute(name, value);
        }
    }

    public boolean isInSumm() {
        return this.inSumm;
    }

    public void setInSumm(boolean inSumm) {
        this.inSumm = inSumm;
    }

    public int getQtyNumsAfterComma() {
        return this.qtyNumsAfterComma;
    }

    public void setQtyNumsAfterComma(int qtyNumsAfterComma) {
        this.qtyNumsAfterComma = qtyNumsAfterComma;
    }

    public int getQtyNumsRoundingMode() {
        return this.qtyNumsRoundingMode;
    }

    public void setQtyNumsRoundingMode(int qtyNumsRoundingMode) {
        this.qtyNumsRoundingMode = qtyNumsRoundingMode;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public BigDecimal getSumUnscaled() {
        return this.sumUnscaled;
    }

    public void setSumUnscaled(BigDecimal sumUnscaled) {
        this.sumUnscaled = sumUnscaled;
    }

    public BigDecimal getSumScaled() {
        return this.sumScaled;
    }

    public void setSumScaled(BigDecimal sumRounded) {
        this.sumScaled = sumRounded;
    }

    public DocumentPosition toDocumentPosition() {
        DocumentPosition result = new DocumentPosition();
        result.setAmount(this.sum);
        result.setAmountScaled(this.sumScaled);
        result.setAmountUnscaled(this.sumUnscaled);
        result.setAwlz(this.awlz);
        result.setContractId(this.contractId);
        result.setCount(this.quantity);
        result.setCountNumsAfterComma(this.qtyNumsAfterComma);
        result.setCountNumsRoundingMode(this.qtyNumsRoundingMode);
        result.setExtractPositions(this.extractPositions == null ? null : this.extractPositions.stream().map(a -> a.toDocumentPosition()).collect(Collectors.toList()));
        result.setInTotal(this.inSumm);
        result.setName(this.name);
        result.setParams(this.params);
        result.setPositionId(this.positionId);
        result.setPositionSpec(this.position == null ? null : this.position.toDocumentPositionSpec());
        result.setUnit(this.unit);
        result.setUnitCode(this.unitCode);
        return result;
    }
}

