/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.CheckTree;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.ModTreeNode;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.NumerationPool;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.MapHolder;

public class DocTypePanel
extends BGUPanel {
    private DocumentType type = DocumentType.BILL;
    private DocTypeTableModel model;
    private BillService billService = null;
    private BGComboBox<ComboBoxItem> typeCombo = new BGComboBox();

    protected void jbInit() {
        this.model = new DocTypeTableModel(DocTypePanel.class.getName());
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("\u0412\u0438\u0434 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        filterPanel.add((Component)this.typeCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.typeCombo.addItem((Object)new ComboBoxItem((Object)DocumentType.BILL, "\u0421\u0447\u0435\u0442\u0430"));
        this.typeCombo.addItem((Object)new ComboBoxItem((Object)DocumentType.INVOICE, "\u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0430\u043a\u0442\u044b, \u0423\u041f\u0414"));
        this.typeCombo.addActionListener(e -> {
            this.type = (DocumentType)((ComboBoxItem)this.typeCombo.getSelectedItem()).getObject();
            this.performAction("refresh");
        });
        this.setLayout(new GridBagLayout());
        this.add(filterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
    }

    private BillService getBillService() {
        if (this.billService == null) {
            this.billService = (BillService)((ClientContext)this.getContext()).getPort(BillService.class);
        }
        return this.billService;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(this.getBillService().docTypeList(this.type))));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            DocType docType = DocType.builder().setDocumentType(this.type).setNpid(this.type == DocumentType.BILL ? 1 : 2).setId(-1).setCreateWhenLessOrEqZero(false).setCreateWhenStronglyLessZero(false).setSubContractPositions(false).setNSubContractPositions(false).setSetupString("").setXmlContractConsist(null).build();
            new DocTypeEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0442\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", docType).open();
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, DocTypeEditorDialog.class, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            DocType docType = (DocType)this.model.getSelectedRow();
            if (docType != null && docType.getId() >= 0 && BGSwingUtilites.confirmDelete((Object)docType)) {
                this.getBillService().docTypeDelete(docType.getId());
                this.model.deleteRow(docType);
            }
        });
    }

    class DocTypeTableModel
    extends BGTableModel<DocType> {
        public DocTypeTableModel(String name) {
            super(name, DocType.class);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0418\u043c\u044f \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", 100, 300, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("XSL \u0448\u0430\u0431\u043b\u043e\u043d", 100, 200, 300, "pattern", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class DocTypeEditorDialog
    extends BGEditorDialog<DocType> {
        private JTabbedPane tabbedPane;
        private BGTextField titleTf;
        private BGTextField patternTf;
        private JCheckBox strongLessZero;
        private JCheckBox lessOrEqualZero;
        private JCheckBox subContractPositions;
        private JCheckBox nsubContractPositions;
        private BGTextArea commentTa;
        private BGUComboBox<NumerationPool> npCombo;
        private BGUCheckList<IdTitle> posList;
        private BGConfigEditorPane configArea;
        private ModTreeNode rootNodeXmlConsist;
        private ModTreeNode contractNodeXmlConsist;
        private ModTreeNode modulesNodeXmlConsist;
        private ModTreeNode pluginsNodeXmlConsist;
        private CheckTree treeXmlConsist;

        public DocTypeEditorDialog(String title, DocType data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.titleTf = new BGTextField(50);
            this.patternTf = new BGTextField(50);
            this.strongLessZero = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0441\u0443\u043c\u043c\u0435 \u0441\u0447\u0435\u0442\u0430 < 0");
            this.lessOrEqualZero = new JCheckBox("\u0421\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u043f\u0440\u0438 \u0441\u0443\u043c\u043c\u0435 \u0441\u0447\u0435\u0442\u0430 <= 0");
            this.subContractPositions = new JCheckBox("\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            this.nsubContractPositions = new JCheckBox("\u041f\u043e\u0437\u0438\u0446\u0438\u0438 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            this.commentTa = new BGTextArea(3, 50);
            this.npCombo = new BGUComboBox();
            this.posList = new BGUCheckList();
            this.configArea = new BGConfigEditorPane();
            this.rootNodeXmlConsist = this.createNode("\u0412\u0441\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", null, 0, "0");
            this.contractNodeXmlConsist = this.createNode("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", null, 0, "0");
            this.modulesNodeXmlConsist = this.createNode("\u041c\u043e\u0434\u0443\u043b\u0438", null, 0, "0");
            this.pluginsNodeXmlConsist = this.createNode("\u041f\u043b\u0430\u0433\u0438\u043d\u044b", null, 0, "0");
            this.treeXmlConsist = new CheckTree(this.rootNodeXmlConsist);
        }

        public void doDialogPanel() {
            this.tabbedPane.add("\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435", this.getGeneralPanel());
            this.tabbedPane.add("\u041f\u043e\u0437\u0438\u0446\u0438\u0438", this.getPositionPanel());
            this.tabbedPane.addTab("\u041a\u043e\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", this.getConfigPanel());
            this.tabbedPane.addTab("\u0421\u043e\u0441\u0442\u0430\u0432 XML", this.getXmlPanel());
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            try {
                Async poolList = Async.of(() -> ((BillService)((ClientContext)DocTypePanel.this.getContext()).getWebService(BillService.class)).numerationPoolList());
                Async positionList = Async.of(() -> DocTypePanel.this.getBillService().positionList(DocTypePanel.this.type == DocumentType.BILL ? DocumentType.BILL : DocumentType.INVOICE));
                Async xmlComposition = Async.of(() -> DocTypePanel.this.getBillService().xmlComposition());
                this.npCombo.setData((List)poolList.get());
                this.posList.setData(positionList.get() != null ? (List)positionList.get() : new ArrayList());
                this.buildBranch((MapHolder<Integer, List<IdTitle>>)((MapHolder)xmlComposition.get()), 0);
                this.buildBranch((MapHolder<Integer, List<IdTitle>>)((MapHolder)xmlComposition.get()), 1);
                this.buildBranch((MapHolder<Integer, List<IdTitle>>)((MapHolder)xmlComposition.get()), 2);
                ClientUtils.expandTree((JTree)this.treeXmlConsist, (DefaultMutableTreeNode)this.rootNodeXmlConsist);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            this.titleTf.setText(((DocType)this.data).getTitle());
            this.patternTf.setText(((DocType)this.data).getPattern());
            this.npCombo.setSelectedItem((Object)((DocType)this.data).getNpid());
            this.lessOrEqualZero.setSelected(((DocType)this.data).isCreateWhenLessOrEqZero());
            this.strongLessZero.setSelected(!this.lessOrEqualZero.isSelected() && ((DocType)this.data).isCreateWhenStronglyLessZero());
            this.subContractPositions.setSelected(((DocType)this.data).isSubContractPositions());
            this.nsubContractPositions.setSelected(((DocType)this.data).isNSubContractPositions());
            this.commentTa.setText(((DocType)this.data).getComment());
            this.posList.setSelected((Collection)((DocType)this.data).getPositionList());
            this.configArea.setText(((DocType)this.data).getSetupString());
            this.setSelectedNodes();
        }

        public boolean doApply() throws Exception {
            ((DocType)this.data).setTitle(this.titleTf.getText());
            ((DocType)this.data).setPattern(this.patternTf.getText());
            ((DocType)this.data).setNpid(((NumerationPool)this.npCombo.getSelectedItem()).getId());
            ((DocType)this.data).setCreateWhenLessOrEqZero(this.lessOrEqualZero.isSelected());
            ((DocType)this.data).setCreateWhenStronglyLessZero(this.strongLessZero.isSelected());
            ((DocType)this.data).setSubContractPositions(this.subContractPositions.isSelected());
            ((DocType)this.data).setNSubContractPositions(this.nsubContractPositions.isSelected());
            ((DocType)this.data).setComment(this.commentTa.getText());
            ((DocType)this.data).setPositionList(this.posList.getSelectedIds());
            ((DocType)this.data).setSetupString(this.configArea.getText());
            ((DocType)this.data).setXmlContractConsist(Utils.toIntegerSet((String)this.treeXmlConsist.getCodes(this.contractNodeXmlConsist, true)));
            ((DocType)this.data).setXmlModulesConsist(Utils.toIntegerSet((String)this.treeXmlConsist.getCodes(this.modulesNodeXmlConsist, true)));
            ((DocType)this.data).setXmlPluginsConsist(Utils.toIntegerSet((String)this.treeXmlConsist.getCodes(this.pluginsNodeXmlConsist, true)));
            if (this.data != null) {
                DocTypePanel.this.getBillService().docTypeUpdate((DocType)this.data);
                DocTypePanel.this.performAction("refresh");
            }
            return true;
        }

        private JPanel getGeneralPanel() {
            this.strongLessZero.addActionListener(e -> {
                if (this.strongLessZero.isSelected()) {
                    this.lessOrEqualZero.setSelected(false);
                }
            });
            this.lessOrEqualZero.addActionListener(e -> {
                if (this.lessOrEqualZero.isSelected()) {
                    this.strongLessZero.setSelected(false);
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.titleTf, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("XSL \u0448\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.patternTf, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0443\u043b \u043d\u043e\u043c\u0435\u0440\u043e\u0432:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.npCombo, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            panel.add((Component)this.strongLessZero, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.lessOrEqualZero, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.subContractPositions, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)this.nsubContractPositions, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)new JScrollPane((Component)this.commentTa), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 11, 2, new Insets(2, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getPositionPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.posList, new GridBagConstraints(2, 0, 1, 7, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getConfigPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)this.configArea), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getXmlPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane((Component)this.treeXmlConsist), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            return panel;
        }

        private ModTreeNode createNode(String title, String icon, int id, String type) {
            ModTreeNode node = new ModTreeNode(title, icon);
            node.setAttribute("id", (Object)("" + id));
            node.setAttribute("type", (Object)type);
            return node;
        }

        private void buildBranch(MapHolder<Integer, List<IdTitle>> mapHolder, int key) {
            if (key == 0) {
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 2, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 1, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0411\u0430\u043b\u0430\u043d\u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", "leaf", 3, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0422\u0430\u0440\u0438\u0444\u044b", "leaf", 4, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b", "leaf", 5, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0422\u0430\u0440\u0438\u0444\u043d\u044b\u0435 \u043e\u043f\u0446\u0438\u0438", "leaf", 6, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u0423\u0441\u043b\u0443\u0433\u0438", "leaf", 7, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041e\u0431\u044a\u0435\u043a\u0442\u044b", "leaf", 9, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0438", "leaf", 8, "0"));
                this.contractNodeXmlConsist.add((MutableTreeNode)this.createNode("\u041a\u043b\u0438\u0435\u043d\u0442", "leaf", 10, "0"));
                this.rootNodeXmlConsist.add((MutableTreeNode)this.contractNodeXmlConsist);
                return;
            }
            List list = (List)mapHolder.getMap().get(key);
            if (list != null) {
                ModTreeNode node = key == 1 ? this.modulesNodeXmlConsist : this.pluginsNodeXmlConsist;
                this.rootNodeXmlConsist.add((MutableTreeNode)node);
                for (IdTitle idTitle : list) {
                    node.add((MutableTreeNode)this.createNode(idTitle.getTitle(), "leaf", idTitle.getId(), "0"));
                }
            }
        }

        private void setSelectedNodes() {
            this.treeXmlConsist.deselectNode(this.rootNodeXmlConsist);
            this.treeXmlConsist.setNodeSelect(this.contractNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)((DocType)this.data).getXmlContractConsist())));
            this.treeXmlConsist.setNodeSelect(this.modulesNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)((DocType)this.data).getXmlModulesConsist())));
            this.treeXmlConsist.setNodeSelect(this.pluginsNodeXmlConsist, Utils.toSet((String)Utils.toString((Iterable)((DocType)this.data).getXmlPluginsConsist())));
            this.treeXmlConsist.updateUI();
        }
    }
}

