/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.directory;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.bill.common.bean.AttributeType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;

public class AttributePanel
extends BGUPanel {
    private AttributeTableMaodel model = new AttributeTableMaodel();

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.model));
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)"edit");
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> Async.of(() -> this.model.setData(((BillService)((ClientContext)this.getContext()).getWebService(BillService.class)).attributeTypeList())));
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new AttributeEditor("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442", new AttributeType()).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.showEditDialog(this.model, AttributeEditor.class, "\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442"));
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            AttributeType attributeType = (AttributeType)this.model.getSelectedRow();
            if (attributeType != null && BGSwingUtilites.confirmDelete((Object)attributeType)) {
                ((BillService)((ClientContext)this.getContext()).getWebService(BillService.class)).attributeTypeDelete(attributeType.getId());
                this.performAction("refresh");
            }
        });
    }

    class AttributeTableMaodel
    extends BGTableModel<AttributeType> {
        public AttributeTableMaodel() {
            super(AttributeTableMaodel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", 60, 60, 60, "id", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430", -1, -1, -1, "check", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }

    public class AttributeEditor
    extends BGEditorDialog<AttributeType> {
        private BGTextField nameField;
        private BGTextField titleField;
        private BGTextField regexpField;

        public AttributeEditor(String title, AttributeType data) {
            super(title, (Object)data);
            this.nameField = new BGTextField(30);
            this.titleField = new BGTextField(30);
            this.regexpField = new BGTextField(30);
        }

        public void doDialogPanel() {
            int gridy = 0;
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.nameField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.titleField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 (regexp):"), new GridBagConstraints(0, gridy++, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.regexpField, new GridBagConstraints(0, gridy++, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.nameField.setText(((AttributeType)this.data).getName());
            this.titleField.setText(((AttributeType)this.data).getTitle());
            this.regexpField.setText(((AttributeType)this.data).getCheck());
            this.nameField.requestFocus();
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.nameField.getText())) {
                ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435");
                return false;
            }
            if (!this.nameField.getText().matches("^[a-zA-Z0-9_]+$")) {
                ClientUtils.showMessageDialog((Object)"\u0412 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u044b \u0442\u043e\u043b\u044c\u043a\u043e \u043b\u0430\u0442\u0438\u043d\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b, \u0446\u0438\u0444\u0440\u044b \u0438 '_'");
                return false;
            }
            if (Utils.isBlankString((String)this.titleField.getText())) {
                ClientUtils.showMessageDialog((Object)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435");
                return false;
            }
            try {
                ((AttributeType)this.data).setName(this.nameField.getText());
                ((AttributeType)this.data).setTitle(this.titleField.getText());
                ((AttributeType)this.data).setCheck(this.regexpField.getText());
                ((BillService)((ClientContext)AttributePanel.this.getContext()).getWebService(BillService.class)).attributeTypeUpdate((AttributeType)this.data);
                AttributePanel.this.performAction("refresh");
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return true;
        }
    }
}

