/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.StartElement;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.dao.AbstarctDaoConstant;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.enums.ContractFace;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.bean.DocType;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.SortMode;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.bill.server.bean.Bill;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.modules.bill.server.bean.BillUtil;
import ru.bitel.bgbilling.modules.bill.server.bean.DocTypeManager;
import ru.bitel.bgbilling.modules.bill.server.bean.ExtractorPositionValue;
import ru.bitel.bgbilling.modules.bill.server.bean.NumerationPoolManager;
import ru.bitel.bgbilling.modules.bill.server.bean.OrganizationDao;
import ru.bitel.bgbilling.modules.bill.server.bean.PositionValue;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public abstract class AbstractManager
extends AbstarctDaoConstant {
    public static final int DT_CREATED = 1;
    public static final int DT_PAYED = 2;
    public static final int BILL_NEW = 1;
    public static final int BILL_PAYED = 2;
    public static final int BILL_ALL = 3;
    public static final int USER_ALL = 1;
    public static final int USER_ADMIN = 2;
    public static final int USER_USER = 3;
    public static final int UT_NOTUNLOADED = 1;
    public static final int UT_UNLOADED = 2;
    public static final int UT_ALL = 3;
    protected Setup setup = Setup.getSetup();
    protected Preferences moduleSetup;
    private static final int NUM_MODE_SEQ = 0;
    private static final int NUM_MODE_MAX = 1;
    private int numMode = 0;
    protected final ContractManager contractManager;
    private static Object getNextNumberMutex = new Object();
    private static final long CACHE_EXPIRE_TIME = 2000L;
    private static Map<Integer, Map<Integer, NumberCache>> moduleCacheMap = new HashMap<Integer, Map<Integer, NumberCache>>();

    public AbstractManager(Connection con, String tableName, int moduleId) {
        super(con, tableName, moduleId);
        this.moduleSetup = this.setup.getModuleSetup(Integer.valueOf(moduleId));
        if (this.moduleSetup != null) {
            this.numMode = this.moduleSetup.getInt("doc.num.mode", 0);
        }
        this.contractManager = new ContractManager(con);
    }

    public final byte[] getXMLData(int contractId, int id) throws SQLException {
        byte[] xml = null;
        String query = "SELECT xml FROM " + this.tableName + " WHERE (cid=? AND id=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setInt(2, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    xml = rs.getBytes("xml");
                }
            }
        }
        return xml;
    }

    public final byte[] getXMLData(int id) throws SQLException {
        byte[] xml = null;
        String query = "SELECT xml FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    xml = rs.getBytes("xml");
                }
            }
        }
        return xml;
    }

    public final void delete(int id) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    @Deprecated
    public final void delete(String ids) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE id IN ( " + ids.substring(0, ids.length() - 1).replaceAll(";", ",") + " )";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.executeUpdate();
        }
    }

    public final void delete(Collection<?> ids) throws SQLException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        String query = "DELETE FROM " + this.tableName + " WHERE id IN (" + Utils.toString(ids, (String)",") + ")";
        try (Statement st = this.con.createStatement();){
            st.executeUpdate(query);
        }
    }

    public final void updatePositions(int id, String posList, int correction, String payDocData, String identifierGovermentContract, String shipmentDocument) throws Exception {
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(posList)));
        String[] vals = payDocData.split(":");
        String payDoc = "";
        String payDocDate = "";
        if (vals.length == 2) {
            payDoc = vals[0];
            payDocDate = vals[1];
        }
        this.updatePositions(id, XMLUtils.selectElement((Node)doc, (String)"positions"), correction, payDoc, payDocDate, identifierGovermentContract, shipmentDocument);
    }

    public final void updatePositions(int id, String posList, String identifierGovermentContract, String shipmentDocument) throws Exception {
        Document doc = XMLUtils.parseDocument((InputSource)new InputSource(new StringReader(posList)));
        this.updatePositions(id, XMLUtils.selectElement((Node)doc, (String)"positions"), -1, "", "", identifierGovermentContract, shipmentDocument);
    }

    public final void updatePositions(int id, Element positions, int correction, String payDoc, String payDocDate, String identifierGovermentContract, String shipmentDocument) throws Exception {
        Document doc = XMLUtils.parseDocument((byte[])this.getXMLData(id));
        Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
        bill.setAttribute("correction", String.valueOf(correction));
        bill.setAttribute("correction_date", TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy"));
        bill.setAttribute("paymentDocument", payDoc);
        bill.setAttribute("paymentDocumentFromDate", payDocDate);
        bill.setAttribute("shipmentDocument", shipmentDocument);
        if (identifierGovermentContract != null && !identifierGovermentContract.isEmpty()) {
            bill.setAttribute("identifierGovermentContract", identifierGovermentContract);
        }
        for (Object item : XMLUtils.selectElements((Node)bill, (String)"pos")) {
            item.getParentNode().removeChild((Node)item);
        }
        BigDecimal totalSumm = BigDecimal.ZERO;
        for (Iterator item : XMLUtils.selectElements((Node)positions, (String)"pos")) {
            BigDecimal summ = Utils.parseBigDecimal((String)item.getAttribute("summ"), (BigDecimal)BigDecimal.ZERO);
            if (!item.getAttribute("insum").equals("0")) {
                totalSumm = totalSumm.add(summ);
            }
            bill.appendChild(doc.importNode((Node)((Object)item), false));
        }
        HashMap<Integer, Element> subBillMap = new HashMap<Integer, Element>();
        for (Element item : XMLUtils.selectElements((Node)bill, (String)"sub_bill")) {
            subBillMap.put(Utils.parseInt((String)item.getAttribute("cid")), item);
        }
        for (Element sub : XMLUtils.selectElements((Node)positions, (String)"sub_bill")) {
            int cid = Utils.parseInt((String)sub.getAttribute("cid"));
            Element subBill = (Element)subBillMap.get(cid);
            for (Element item : XMLUtils.selectElements((Node)subBill, (String)"pos")) {
                item.getParentNode().removeChild(item);
            }
            for (Element item : XMLUtils.selectElements((Node)sub, (String)"pos")) {
                BigDecimal summ = Utils.parseBigDecimal((String)item.getAttribute("summ"), (BigDecimal)BigDecimal.ZERO);
                if (!item.getAttribute("insum").equals("0")) {
                    totalSumm = totalSumm.add(summ);
                }
                subBill.appendChild(doc.importNode(item, false));
            }
        }
        if (totalSumm.compareTo(BigDecimal.ZERO) <= 0) {
            BillDoc billDoc = this.getBillDocInfo(id);
            DocType docType = new DocTypeManager(this.con, this.moduleId).getType(billDoc.getTypeId());
            if (totalSumm.compareTo(BigDecimal.ZERO) == 0) {
                if (!docType.isCreateWhenLessOrEqZero()) {
                    throw new BGException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f!");
                }
            } else if (!docType.isCreateWhenLessOrEqZero() && !docType.isCreateWhenStronglyLessZero()) {
                throw new BGException("\u0421\u0443\u043c\u043c\u0430 \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u0438\u043b\u0438 \u0440\u0430\u0432\u043d\u043e \u043d\u0443\u043b\u044e!");
            }
        }
        bill.setAttribute("total_sum", Utils.formatBigDecimalSumm((BigDecimal)totalSumm));
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET summ=?, xml=? WHERE id=?");){
            ps.setBigDecimal(1, totalSumm);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            XMLUtils.serialize((Node)doc, (OutputStream)bos, (String)"UTF-8");
            ps.setBytes(2, bos.toByteArray());
            ps.setInt(3, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            this.getLogger().error("error updatePositions #" + id, (Throwable)ex);
        }
    }

    public String updateNumber(int id, int number, int numberYear, int numberMonth, Calendar date, int month, int year) throws Exception {
        String message = null;
        Document doc = XMLUtils.parseDocument((byte[])this.getXMLData(id));
        Element bill = (Element)doc.getDocumentElement().getElementsByTagName("bill").item(0);
        int npid = Utils.parseInt((String)bill.getAttribute("npid"), (int)(this instanceof BillManager ? 1 : 2));
        String query = "SELECT yy, mm, cid FROM " + this.tableName + " WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                throw new BGException("\u0421\u0447\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0431\u0430\u0437\u0435");
            }
            int yy = rs.getInt(1);
            int mm = rs.getInt(2);
            int contractId = rs.getInt(3);
            query = "SELECT id, format_number FROM " + this.tableName + " WHERE number=? AND id!=? UNION SELECT id, format_number FROM " + this.tableName + " WHERE number_in_month=? AND yy=? AND mm=? AND id!=? UNION SELECT id, format_number FROM " + this.tableName + " WHERE number_in_year=? AND yy=? AND id!=?";
            ps = this.con.prepareStatement(query);
            int index = 1;
            ps.setInt(index++, number);
            ps.setInt(index++, id);
            ps.setInt(index++, numberMonth);
            ps.setInt(index++, yy);
            ps.setInt(index++, mm);
            ps.setInt(index++, id);
            ps.setInt(index++, numberYear);
            ps.setInt(index++, yy);
            ps.setInt(index++, id);
            rs = ps.executeQuery();
            if (rs.next()) {
                message = "\u041d\u043e\u043c\u0435\u0440 \u0431\u044b\u043b \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442 \u0441\u0447\u0435\u0442\u043e\u043c " + rs.getString(2);
            }
            rs.close();
            ps.close();
            String formatNumber = NumerationPoolManager.formatNumber(npid, yy, mm, number, numberMonth, numberYear, this.con, this.moduleId, contractId);
            bill.setAttribute("bill_number", formatNumber);
            bill.setAttribute("date", TimeUtils.formatDate((Calendar)date));
            query = "UPDATE " + this.tableName + " SET number=?, number_in_month=?, number_in_year=?, format_number=?, mm=?, yy=?, create_dt=?, xml=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, number);
            ps.setInt(2, numberMonth);
            ps.setInt(3, numberYear);
            ps.setString(4, formatNumber);
            ps.setInt(5, month);
            ps.setInt(6, year);
            ps.setDate(7, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
            XMLUtils.serialize((Node)doc, (OutputStream)bos, (String)"UTF-8");
            ps.setBytes(8, bos.toByteArray());
            ps.setInt(9, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            this.getLogger().error("error updateNumber #" + id, (Throwable)ex);
        }
        return message;
    }

    protected void addPackageFilterJoin(int packageParamId, int packageId, int sortMode, StringBuffer query) {
        if (packageParamId > 0 && packageId > 0) {
            query.append(" LEFT JOIN contract_parameter_type_7 AS cp7 ON (cp7.cid=contract.id AND cp7.pid=");
            query.append(packageParamId);
            query.append(") LEFT JOIN contract_parameter_type_7 AS cp7_super ON (cp7_super.cid=contract.scid AND cp7_super.pid=");
            query.append(packageParamId);
            query.append(") ");
        } else if (sortMode == SortMode.PACKAGE.getCode()) {
            query.append(" LEFT JOIN contract_parameter_type_7 AS cp7 ON (cp7.cid=contract.id AND cp7.pid=");
            query.append(packageParamId + ")");
            query.append(" LEFT JOIN contract_parameter_type_7_values AS cp7v ON (cp7v.pid=cp7.pid and cp7.val=cp7v.id)");
        }
    }

    protected void addSortMode(int addressSortParam, String nameSortParam, int sortMode, int secondarySortMode, StringBuffer query) {
        if (sortMode == SortMode.NAME.getCode() && !Utils.isEmptyString((String)nameSortParam)) {
            query.append(" ORDER BY name_param.val ASC");
        } else if (sortMode == SortMode.CITY_QUARTER.getCode() && addressSortParam > 0) {
            query.append(" ORDER BY city.title, quarter.title ");
        } else if (sortMode == SortMode.STREET_HOUSE_ETC.getCode() && addressSortParam > 0) {
            query.append(" ORDER BY street.title, house.house, house.frac, CAST(cp2.flat AS UNSIGNED), cp2.flat, cp2.room, contract.id ");
        } else if (sortMode == SortMode.INDEX.getCode() && addressSortParam > 0) {
            query.append(" ORDER BY house.box_index, street.title, house.house, house.frac, CAST(cp2.flat AS UNSIGNED), cp2.flat, cp2.room, contract.id ");
        } else if (sortMode == SortMode.CONTRACT.getCode()) {
            query.append(" ORDER BY contract.title ASC");
        } else if (sortMode == SortMode.CONTRACT_WITH_SUB.getCode()) {
            query.append(" ORDER BY sub_sort ASC ");
        } else if (sortMode == SortMode.ID.getCode()) {
            query.append(" ORDER BY bill_data.id ASC");
        } else if (sortMode == SortMode.ID_REVERT.getCode()) {
            query.append(" ORDER BY bill_data.id DESC");
        } else if (sortMode == SortMode.NUMBER.getCode()) {
            query.append(" ORDER BY bill_data.format_number ASC");
        } else if (sortMode == SortMode.NUMBER_REVERT.getCode()) {
            query.append(" ORDER BY bill_data.format_number DESC");
        } else if (sortMode == SortMode.PATTERN.getCode()) {
            query.append(" ORDER BY " + this.moduleSetup.get("pattern.sort", "contract.title ASC, number ASC"));
        } else if (sortMode == SortMode.PACKAGE.getCode()) {
            query.append(" ORDER BY cp7v.title ASC");
        } else {
            query.append(" ORDER BY contract.title ASC, number ASC");
        }
        if (secondarySortMode == SortMode.NAME.getCode() && !Utils.isEmptyString((String)nameSortParam)) {
            query.append(", name_param.val ASC ");
        } else if (secondarySortMode == SortMode.CITY_QUARTER.getCode() && addressSortParam > 0) {
            query.append(", city.title, quarter.title ");
        }
        if (secondarySortMode == SortMode.STREET_HOUSE_ETC.getCode() && addressSortParam > 0) {
            query.append(", street.title, house.house, house.frac, CAST(cp2.flat AS UNSIGNED), cp2.flat, cp2.room, contract.id ");
        } else if (secondarySortMode == SortMode.INDEX.getCode() && addressSortParam > 0) {
            query.append(", house.box_index, street.title, house.house, house.frac, CAST(cp2.flat AS UNSIGNED), cp2.flat, cp2.room, contract.id ");
        } else if (secondarySortMode == SortMode.CONTRACT.getCode()) {
            query.append(", contract.title ASC, number ASC");
        } else if (secondarySortMode == SortMode.CONTRACT_WITH_SUB.getCode()) {
            query.append(", sub_sort ASC, number ASC");
        } else if (secondarySortMode == SortMode.ID.getCode()) {
            query.append(", bill_data.id ASC");
        } else if (secondarySortMode == SortMode.ID_REVERT.getCode()) {
            query.append(", bill_data.id DESC");
        } else if (secondarySortMode == SortMode.NUMBER.getCode()) {
            query.append(", bill_data.format_number ASC");
        } else if (secondarySortMode == SortMode.NUMBER_REVERT.getCode()) {
            query.append(", bill_data.format_number DESC");
        } else if (secondarySortMode == SortMode.CONTRACT.getCode()) {
            query.append(", contract.title ASC, number ASC");
        } else if (secondarySortMode == SortMode.PATTERN.getCode()) {
            query.append(", " + this.moduleSetup.get("pattern.sort", "contract.title ASC, number ASC"));
        }
    }

    protected void addStreetCol(int addressSortParam, int sortMode, int secSortMode, StringBuffer query, boolean forRegister) {
        boolean addressCond;
        boolean bl = addressCond = sortMode == SortMode.STREET_HOUSE_ETC.getCode() || sortMode == SortMode.INDEX.getCode() || sortMode == SortMode.CITY_QUARTER.getCode() || secSortMode == SortMode.STREET_HOUSE_ETC.getCode() || secSortMode == SortMode.INDEX.getCode() || secSortMode == SortMode.CITY_QUARTER.getCode();
        if (addressCond && addressSortParam > 0) {
            query.append(", house.box_index, street.title, house.house, house.frac ");
        }
        if (forRegister) {
            query.append(" , cp2.address ");
        }
    }

    protected void addStreetJoin(int addressSortParam, int sortMode, int secSortMode, StringBuffer query, boolean forRegister) {
        boolean addressCond;
        boolean bl = addressCond = sortMode == SortMode.STREET_HOUSE_ETC.getCode() || sortMode == SortMode.INDEX.getCode() || sortMode == SortMode.CITY_QUARTER.getCode() || secSortMode == SortMode.STREET_HOUSE_ETC.getCode() || secSortMode == SortMode.INDEX.getCode() || secSortMode == SortMode.CITY_QUARTER.getCode();
        if (addressCond && addressSortParam > 0) {
            query.append(" LEFT JOIN (SELECT cid, hid FROM contract_parameter_type_2 WHERE pid=");
            query.append(addressSortParam);
            query.append(" ) AS cp2_sub ON cp2_sub.cid=contract.id");
            query.append(" LEFT JOIN contract_parameter_type_2 AS cp2 ON cp2.cid = if (contract.scid>0 AND (IFNULL(cp2_sub.hid, 0) = 0), contract.scid, contract.id) AND cp2.pid=");
            query.append(addressSortParam);
            query.append(" LEFT JOIN address_house AS house ON cp2.hid=house.id");
            query.append(" LEFT JOIN address_street AS street ON house.streetid=street.id");
            query.append(" LEFT JOIN address_quarter AS quarter ON house.quarterid=quarter.id");
            query.append(" LEFT JOIN address_city AS city ON street.cityid=city.id ");
        } else if (forRegister) {
            query.append(" LEFT JOIN (SELECT cid, hid FROM contract_parameter_type_2 WHERE pid=").append(addressSortParam).append(" ) AS cp2_sub ON cp2_sub.cid=contract.id");
            query.append(" LEFT JOIN contract_parameter_type_2 AS cp2 ON cp2.cid = if (contract.scid>0 AND (IFNULL(cp2_sub.hid, 0) = 0), contract.scid, contract.id) AND cp2.pid=").append(addressSortParam);
        }
    }

    protected void addNameCol(String nameSortParam, int sortMode, int secSortMode, StringBuffer query) {
        boolean nameCond;
        boolean bl = nameCond = sortMode == SortMode.NAME.getCode() || secSortMode == SortMode.NAME.getCode();
        if (nameCond && !Utils.isEmptyString((String)nameSortParam)) {
            query.append(", name_param.val ");
        }
    }

    protected void addNameJoin(String nameSortParam, int sortMode, int secSortMode, StringBuffer query) {
        boolean nameCond;
        boolean bl = nameCond = sortMode == SortMode.NAME.getCode() || secSortMode == SortMode.NAME.getCode();
        if (nameCond && !Utils.isEmptyString((String)nameSortParam)) {
            int fisParam = -1;
            int urParam = -1;
            String[] val = nameSortParam.split(",");
            if (val.length == 1) {
                fisParam = urParam = Utils.parseInt((String)val[0], (int)-1);
            } else if (val.length == 2) {
                fisParam = Utils.parseInt((String)val[0], (int)-1);
                urParam = Utils.parseInt((String)val[1], (int)-1);
            }
            query.append(" LEFT JOIN contract_parameter_type_1 AS name_param ON (name_param.cid=if ( contract.scid>0, contract.scid, contract.id ))");
            query.append(" AND name_param.pid=if (contract.fc=0,");
            query.append(fisParam);
            query.append(",");
            query.append(urParam);
            query.append(") ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int[] getNextNumbers(Connection con, int numberPoolId, int yy, int mm) {
        Object object = getNextNumberMutex;
        synchronized (object) {
            Integer lastAbsNumber = null;
            Integer lastInMonthNumber = null;
            Integer lastInYearNumber = null;
            String yearKey = String.valueOf(yy);
            String monthKey = String.valueOf(yy + "_" + mm);
            NumberCache numberCache = null;
            Map<Integer, NumberCache> numPoolCache = moduleCacheMap.get(this.moduleId);
            if (numPoolCache != null) {
                numberCache = numPoolCache.get(numberPoolId);
                if (numberCache == null || System.currentTimeMillis() - numberCache.cacheTime > 2000L) {
                    numberCache = new NumberCache();
                    numPoolCache.put(numberPoolId, numberCache);
                } else {
                    lastAbsNumber = numberCache.lastAbsNumber;
                    lastInYearNumber = numberCache.lastInYearNumber.get(yearKey);
                    lastInMonthNumber = numberCache.lastInMonthNumber.get(monthKey);
                }
            } else {
                numPoolCache = new HashMap<Integer, NumberCache>();
                numberCache = new NumberCache();
                numPoolCache.put(numberPoolId, numberCache);
                moduleCacheMap.put(this.moduleId, numPoolCache);
            }
            try {
                String query = null;
                PreparedStatement ps = null;
                ResultSet rs = null;
                if (lastAbsNumber == null) {
                    query = this.numMode == 1 ? "SELECT MAX(number) FROM " + this.tableName + " WHERE npid=?" : "SELECT number FROM " + this.tableName + " WHERE npid=? ORDER BY id DESC LIMIT 1";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, numberPoolId);
                    rs = ps.executeQuery();
                    lastAbsNumber = rs.next() ? Integer.valueOf(rs.getInt(1)) : Integer.valueOf(0);
                    rs.close();
                }
                if (lastInMonthNumber == null) {
                    query = this.numMode == 1 ? "SELECT MAX(number_in_month) AS number FROM " + this.tableName + " WHERE yy=? AND mm=? AND npid=?" : "SELECT number_in_month FROM " + this.tableName + " WHERE yy=? AND mm=? AND npid=? ORDER BY id DESC LIMIT 1";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, yy);
                    ps.setInt(2, mm);
                    ps.setInt(3, numberPoolId);
                    rs = ps.executeQuery();
                    lastInMonthNumber = rs.next() ? Integer.valueOf(rs.getInt(1)) : Integer.valueOf(0);
                    rs.close();
                }
                if (lastInYearNumber == null) {
                    query = this.numMode == 1 ? "SELECT MAX(number_in_year) AS number FROM " + this.tableName + " WHERE yy=? AND npid=?" : "SELECT number_in_year FROM " + this.tableName + " WHERE yy=? AND npid=? ORDER BY id DESC LIMIT 1";
                    ps = con.prepareStatement(query);
                    ps.setInt(1, yy);
                    ps.setInt(2, numberPoolId);
                    rs = ps.executeQuery();
                    lastInYearNumber = rs.next() ? Integer.valueOf(rs.getInt(1)) : Integer.valueOf(0);
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            int absNumber = lastAbsNumber + 1;
            int inMonthNumber = lastInMonthNumber + 1;
            int inYearNumber = lastInYearNumber + 1;
            numberCache.lastAbsNumber = absNumber;
            numberCache.lastInMonthNumber.put(monthKey, inMonthNumber);
            numberCache.lastInYearNumber.put(yearKey, inYearNumber);
            numberCache.cacheTime = System.currentTimeMillis();
            return new int[]{absNumber, inMonthNumber, inYearNumber};
        }
    }

    public void addBillDocs(int userId, InputStream billsXML, int yy, int mm, Date date) throws Exception {
        this.addBillDocs(userId, billsXML, yy, mm, date, true);
    }

    public void addBillDocs(final int userId, InputStream billsXML, int yy, int mm, Date date, final boolean checkPast) throws Exception {
        if (checkPast && !BillUtil.isPast(yy, mm)) {
            return;
        }
        DocTypeManager docTypeManager = new DocTypeManager(this.con, this.moduleId);
        HashMap<String, DocType> docTypeMap = new HashMap<String, DocType>();
        XMLUtils.BGXMLEventReader reader = XMLUtils.newXMLEventReader((Reader)new InputStreamReader(billsXML, StandardCharsets.UTF_8));
        Iterable posSubBills = reader.iterable("*");
        Iterable positions = reader.iterable("pos");
        final ThreadPoolExecutor pool = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());
        final AtomicInteger taskCount = new AtomicInteger();
        for (StartElement bill : reader.iterable("/bills/bill")) {
            boolean generate;
            final BillDoc billDoc = this.getBillDoc(reader, bill);
            billDoc.setContractId(Utils.parseInt((String)reader.getAttributeValue(bill, "cid"), (int)0));
            billDoc.setTypeId(Utils.parseInt((String)reader.getAttributeValue(bill, "type"), (int)0));
            billDoc.setTypeTitle(reader.getAttributeValue(bill, "type_title"));
            billDoc.setSumm(Utils.parseBigDecimal((String)reader.getAttributeValue(bill, "summ"), (BigDecimal)BigDecimal.ZERO));
            billDoc.setCreateDate(date);
            billDoc.setYy(yy);
            billDoc.setMm(mm);
            billDoc.setUserId(userId);
            billDoc.setUserName(UserMap.getUser((Integer)userId).getName());
            DocType docType = (DocType)docTypeMap.get(reader.getAttributeValue(bill, "type"));
            if (docType == null) {
                docType = docTypeManager.getType(Utils.parseInt((String)reader.getAttributeValue(bill, "type"), (int)0));
                docTypeMap.put(reader.getAttributeValue(bill, "type"), docType);
            }
            billDoc.setNpid(docType.getNpid());
            boolean allPositionsCorrect = true;
            List checkPositionsList = Utils.toIntegerList((String)docType.getSetup().get("create.only.when.pos.positive", null));
            final ArrayList<PositionValue> posList = new ArrayList<PositionValue>();
            billDoc.setPositionList(posList);
            final ArrayList<BillDoc> subList = new ArrayList<BillDoc>();
            for (StartElement posSubBill : posSubBills) {
                String nodeName = posSubBill.getName().getLocalPart();
                if ("pos".equals(nodeName)) {
                    PositionValue positionValue = this.getPositionValue(reader, posSubBill);
                    if (checkPositionsList.contains(positionValue.getPositionId()) && positionValue.getSum().compareTo(BigDecimal.ZERO) <= 0) {
                        allPositionsCorrect = false;
                    }
                    posList.add(positionValue);
                    continue;
                }
                if (!"sub_bill".equals(nodeName)) continue;
                BillDoc subBill = this.getBillDoc(reader, bill);
                subBill.setId(Utils.parseInt((String)reader.getAttributeValue(posSubBill, "id"), (int)0));
                subBill.setContractId(Utils.parseInt((String)reader.getAttributeValue(posSubBill, "cid"), (int)0));
                subBill.setTypeId(Utils.parseInt((String)reader.getAttributeValue(posSubBill, "type"), (int)0));
                subBill.setSumm(Utils.parseBigDecimal((String)reader.getAttributeValue(posSubBill, "summ"), (BigDecimal)BigDecimal.ZERO));
                subBill.setContractTitle(reader.getAttributeValue(posSubBill, "contract"));
                ArrayList<PositionValue> subBillPosList = new ArrayList<PositionValue>();
                subBill.setPositionList(subBillPosList);
                for (StartElement pos : positions) {
                    subBillPosList.add(this.getPositionValue(reader, pos));
                }
                subList.add(subBill);
            }
            if (billDoc.getContractId() <= 0) continue;
            boolean correctPositionSumms = docType.isCreateWhenLessOrEqZero() || billDoc.getSumm().compareTo(BigDecimal.ZERO) != 0 && docType.isCreateWhenStronglyLessZero() || billDoc.getSumm().compareTo(BigDecimal.ZERO) > 0;
            boolean bl = generate = correctPositionSumms && allPositionsCorrect;
            if (generate && posList.size() == 0) {
                if (subList.size() == 0) {
                    generate = false;
                } else {
                    boolean wasPosition = false;
                    for (BillDoc doc : subList) {
                        if (doc.getPositionList() == null || doc.getPositionList().size() <= 0) continue;
                        wasPosition = true;
                        break;
                    }
                    if (!wasPosition) {
                        generate = false;
                    }
                }
            }
            if (!generate) continue;
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    int billId = AbstractManager.this.addBillDoc(userId, billDoc, posList, subList, checkPast);
                    try {
                        AbstractManager.this.publishEvent(userId, billDoc, billId);
                    }
                    catch (BGException e) {
                        AbstractManager.this.getLogger().error(e.getMessage(), (Throwable)e);
                    }
                    taskCount.decrementAndGet();
                    AbstractManager.this.getLogger().debug("Real insert document, active count: {}; queue: {}", (Object)pool.getActiveCount(), (Object)pool.getQueue().size());
                }
            });
            taskCount.incrementAndGet();
            this.getLogger().debug("Inserted document to queue, active count: {}; queue: {}", (Object)pool.getActiveCount(), (Object)pool.getQueue().size());
        }
        this.getLogger().debug("Stop adding create bill tasks, active count: {}; queue: {}", (Object)pool.getActiveCount(), (Object)pool.getQueue().size());
        while (taskCount.get() != 0) {
            try {
                this.getLogger().debug("Waiting adding threads, active count: {}; queue: {}", (Object)pool.getActiveCount(), (Object)pool.getQueue().size());
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        this.getLogger().debug("Creating bills stopped, active count: {}; queue: {}", (Object)pool.getActiveCount(), (Object)pool.getQueue().size());
    }

    private PositionValue getPositionValue(XMLUtils.BGXMLEventReader reader, StartElement pos) {
        PositionValue positionValue;
        boolean extractorPos = reader.getAttributeValue(pos, "sid") != null;
        PositionValue positionValue2 = positionValue = extractorPos ? new ExtractorPositionValue() : new PositionValue();
        if (extractorPos) {
            ((ExtractorPositionValue)positionValue).setServiceId(Utils.parseInt((String)reader.getAttributeValue(pos, "sid")));
            ((ExtractorPositionValue)positionValue).setModuleId(Utils.parseInt((String)reader.getAttributeValue(pos, "mid")));
        }
        positionValue.setName(reader.getAttributeValue(pos, "name"));
        positionValue.setPositionId(Utils.parseInt((String)reader.getAttributeValue(pos, "position_id")));
        positionValue.setSum(Utils.parseBigDecimal((String)reader.getAttributeValue(pos, "summ"), (BigDecimal)BigDecimal.ZERO));
        positionValue.setQuantity(new BigDecimal(reader.getAttributeValue(pos, "quantity")));
        positionValue.setUnit(reader.getAttributeValue(pos, "unit"));
        positionValue.setUnitCode(reader.getAttributeValue(pos, "unitCode"));
        positionValue.setInSumm(!"0".equals(reader.getAttributeValue(pos, "insum")));
        positionValue.setQtyNumsAfterComma(Utils.parseInt((String)reader.getAttributeValue(pos, "qtynums")));
        positionValue.setAddWhenLessZero("1".equals(reader.getAttributeValue(pos, "awlz")));
        positionValue.setSumUnscaled(Utils.parseBigDecimal((String)reader.getAttributeValue(pos, "sumUnscaled"), null));
        positionValue.setQtyNumsRoundingMode(Utils.parseInt((String)reader.getAttributeValue(pos, "qtynumsRnd"), (int)4));
        for (Map.Entry entry : reader.getAttributes(pos).entrySet()) {
            if (!((String)entry.getKey()).startsWith("param_")) continue;
            positionValue.getParams().put((String)entry.getKey(), (String)entry.getValue());
        }
        return positionValue;
    }

    protected void addBillDocData(Connection con, BillDoc billDoc, List<PositionValue> posList, List<BillDoc> subList, XMLStreamWriter doc, Contract contract) throws Exception {
        BankAccount bankAccount;
        doc.writeAttribute("cid", String.valueOf(billDoc.getContractId()));
        doc.writeAttribute("type", String.valueOf(billDoc.getTypeId()));
        doc.writeAttribute("type_title", String.valueOf(billDoc.getTypeTitle()));
        doc.writeAttribute("contract", contract.getTitle());
        doc.writeAttribute("contract_date1", TimeUtils.format((Date)contract.getDateFrom(), (String)"dd.MM.yyyy"));
        doc.writeAttribute("contract_date2", TimeUtils.format((Date)contract.getDateTo(), (String)"dd.MM.yyyy"));
        doc.writeAttribute("fc", String.valueOf(contract.getFace() == ContractFace.FIZIC ? 0 : 1));
        doc.writeAttribute("balance_mode", String.valueOf(contract.getBalanceMode()));
        doc.writeAttribute("yy", String.valueOf(billDoc.getYy()));
        doc.writeAttribute("mm", String.valueOf(billDoc.getMm() + 1));
        doc.writeAttribute("month", TimeUtils.monthNames[billDoc.getMm()]);
        GregorianCalendar calendar = new GregorianCalendar(billDoc.getYy(), billDoc.getMm(), 1);
        doc.writeAttribute("period_date1", TimeUtils.format((Calendar)calendar, (String)"dd.MM.yyyy"));
        calendar.set(5, ((Calendar)calendar).getActualMaximum(5));
        doc.writeAttribute("period_date2", TimeUtils.format((Calendar)calendar, (String)"dd.MM.yyyy"));
        doc.writeAttribute("date", TimeUtils.formatDate((Date)billDoc.getCreateDate()));
        doc.writeAttribute("bill_number", billDoc.getFormatNumber());
        doc.writeAttribute("payer", contract.getComment());
        doc.writeAttribute("total_sum", Utils.formatBigDecimalSumm((BigDecimal)billDoc.getSumm()));
        doc.writeAttribute("npid", String.valueOf(billDoc.getNpid()));
        doc.writeAttribute("correction", String.valueOf(billDoc.getCorrection()));
        BigDecimal sumAll = BigDecimal.ZERO.setScale(2);
        BigDecimal sumNdsAll = BigDecimal.ZERO.setScale(2);
        BigDecimal sumNoNdsAll = BigDecimal.ZERO.setScale(2);
        for (PositionValue pos : posList) {
            Iterator<BillDoc> sumNds = pos.getSum().divide(new BigDecimal(100).add(pos.getNds())).multiply(pos.getNds()).setScale(2);
            sumNoNdsAll = sumNoNdsAll.add(pos.getSum()).subtract((BigDecimal)((Object)sumNds));
            sumNdsAll = sumNdsAll.add((BigDecimal)((Object)sumNds));
            sumAll = sumAll.add(pos.getSum());
        }
        doc.writeAttribute("sum_all", Utils.formatBigDecimalSumm((BigDecimal)sumAll));
        doc.writeAttribute("sum_nds_all", Utils.formatBigDecimalSumm((BigDecimal)sumNdsAll));
        doc.writeAttribute("sum_nonds_all", Utils.formatBigDecimalSumm((BigDecimal)sumNoNdsAll));
        Organization organization = billDoc.getOrganization();
        if (organization != null) {
            doc.writeStartElement("organization");
            doc.writeAttribute("title", organization.getTitle());
            JSONObject jsonObject = new JSONObject(organization.getData());
            for (String key : jsonObject.keySet()) {
                doc.writeAttribute(key, jsonObject.optString(key, ""));
            }
            doc.writeEndElement();
        }
        if ((bankAccount = billDoc.getBankAccount()) != null) {
            doc.writeStartElement("bank");
            doc.writeAttribute("title", bankAccount.getTitle());
            doc.writeAttribute("account", bankAccount.getAccount());
            doc.writeAttribute("bik", bankAccount.getBankIdentificationCode());
            doc.writeAttribute("correspondent_account", bankAccount.getCorrespondentAccount());
            doc.writeEndElement();
        }
        for (PositionValue pos : posList) {
            if (!pos.isAddWhenLessZero() && BigDecimal.ZERO.compareTo(pos.getSum()) == 0) continue;
            doc.writeStartElement("pos");
            pos.toElement(doc);
            doc.writeEndElement();
        }
        for (BillDoc sub : subList) {
            doc.writeStartElement("sub_bill");
            doc.writeAttribute("cid", String.valueOf(sub.getContractId()));
            Contract subContract = ContractDao.getContract((Connection)con, (int)sub.getContractId());
            doc.writeAttribute("contract", subContract != null ? subContract.getTitle() : "");
            doc.writeAttribute("contract_comment", subContract != null ? subContract.getComment() : "");
            doc.writeAttribute("type", String.valueOf(sub.getTypeId()));
            doc.writeAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)sub.getSumm()));
            for (PositionValue pos : sub.getPositionList()) {
                if (!pos.isAddWhenLessZero() && BigDecimal.ZERO.compareTo(pos.getSum()) == 0) continue;
                doc.writeStartElement("pos");
                pos.toElement(doc);
                doc.writeEndElement();
            }
            doc.writeEndElement();
        }
        try {
            DocType docType = new DocTypeManager(con, this.moduleId).getType(billDoc.getTypeId());
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, billDoc.getYy());
            cal.set(2, billDoc.getMm());
            cal.set(5, 1);
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)cal);
            Date date1 = cal.getTime();
            ((Calendar)cal).add(2, 1);
            Date date2 = cal.getTime();
            BillUtil.addTariffInfo(con, doc, docType, billDoc.getContractId(), date1, date2);
            BillUtil.buildParamsAndAttributesList(con, this.moduleId, this.moduleSetup, billDoc.getContractId(), doc, docType, billDoc.getUserName());
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public int addBillDoc(int userId, BillDoc billDoc, List<PositionValue> posList, List<BillDoc> subList) {
        return this.addBillDoc(userId, billDoc, posList, subList, true);
    }

    public abstract int addBillDoc(int var1, BillDoc var2, List<PositionValue> var3, List<BillDoc> var4, boolean var5);

    protected abstract BillDoc getBillDoc(Attributes var1) throws Exception;

    protected abstract BillDoc getBillDoc(XMLUtils.BGXMLEventReader var1, StartElement var2) throws Exception;

    protected void setBankAccount(Bill bill, int bankAccountId) throws Exception {
        bill.setAccountId(bankAccountId);
        bill.setBankAccount(new AccountManager(this.con, this.moduleId).getBankAccount(bankAccountId));
    }

    protected void setOrganization(BillDoc billDoc, int organizationId) {
        try (OrganizationDao organizationDao = new OrganizationDao(this.con, this.moduleId);){
            billDoc.setOrganization(organizationDao.getOrganization(organizationId));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BillDoc getBillDocInfo(int id) throws BGException {
        BillDoc billDoc = null;
        String query = "SELECT cid, type, number, number_in_month, number_in_year, format_number, yy, mm, create_dt, summ, npid FROM " + this.tableName + " WHERE id=" + id;
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                billDoc = new BillDoc().setContractId(rs.getInt("cid")).setTypeId(rs.getInt("type")).setNumber(rs.getInt("number")).setNumberInMonth(rs.getInt("number_in_month")).setNumberInYear(rs.getInt("number_in_year")).setFormatNumber(rs.getString("format_number")).setYy(rs.getInt("yy")).setMm(rs.getInt("mm")).setCreateDate(rs.getDate("create_dt")).setSumm(rs.getBigDecimal("summ")).setNpid(rs.getInt("npid"));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return billDoc;
    }

    protected abstract void publishEvent(int var1, BillDoc var2, int var3) throws BGException;

    private static class NumberCache {
        public long cacheTime = 0L;
        public Integer lastAbsNumber;
        public Map<String, Integer> lastInYearNumber = new HashMap<String, Integer>();
        public Map<String, Integer> lastInMonthNumber = new HashMap<String, Integer>();

        private NumberCache() {
        }
    }
}

