/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.table;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.bill.common.bean.BillDocSendLog;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDocSendLogDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

public class TableBillDocumentSendMonitor
extends BGTableInfoBase {
    public TableBillDocumentSendMonitor() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnDateTime((String)"\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043a\u0438", (String)"sendTime").setWidth(150), BGUTableColumn.buildColumnTextCenter((String)"\u0422\u0438\u043f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", (String)"docType").setWidth(120), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", (String)"docId").setWidth(100), BGUTableColumn.buildColumnTextRight((String)"\u0421\u0443\u043c\u043c\u0430", (String)"docSum").setWidth(150), BGUTableColumn.buildColumnTextCenter((String)"\u0422\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442", (String)"sendMode").setWidth(100), BGUTableColumn.buildColumnTextLeft((String)"\u0414\u043e\u0433\u043e\u0432\u043e\u0440", (String)"contractTitle").setPrefWidth(150).setMaxWidth(150), BGUTableColumn.buildColumnTextLeft((String)"\u0410\u0434\u0440\u0435\u0441", (String)"senAddress").setMaxWidth(-1), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441", (String)"sendStatus").setWidth(70)};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        Connection con = serverContext.getConnection();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        SearchResult searchResult = new SearchResult(tableParams.getPeriod(), tableParams.getPage());
        new BillDocSendLogDao(con, moduleId).searchBillDocSendLog((SearchResult<BillDocSendLog>)searchResult);
        this.page = searchResult.getPage();
        this.getAttributes().clear();
        this.addAttribute("totalSum", Utils.formatBigDecimal((BigDecimal)searchResult.getSum(), (int)2));
        List<Integer> contractIds = searchResult.getList().stream().map(a -> a.getContractId()).toList();
        Map contractTitles = ContractDao.getContractTitles((Connection)con, contractIds);
        return searchResult.getList().stream().map(a -> new BGUTableRowData().addValue("id", a.getId()).addValue("contractId", String.valueOf(a.getContractId())).addValue("sendTime", a.getSendTime().format(dateTimeFormatter)).addValue("docId", String.valueOf(a.getDocumentId())).addValue("docSum", Utils.formatBigDecimal((BigDecimal)a.getDocumentSum(), (int)2)).addValue("contractTitle", (String)((Object)contractTitles.getOrDefault(a.getContractId(), "??? [ID#" + a.getContractId() + "]"))).addValue("sendMode", a.getSendMode().name()).addValue("docType", a.getDocumentType().name()).addValue("senAddress", a.getSendAddress()).addValue("sendStatus", a.getSendStatus())).toList();
    }
}

