/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.admin.TransferManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;
import ru.bitel.common.Utils;

public class ContractGroupOperationFactory
implements ContractGroupOperation.ContractGroupOperationFactory {
    public Collection<ContractGroupOperation.ContractGroupOperationItem> getContractGroupOperations(String mid, String title) {
        ArrayList<ContractGroupOperation.ContractGroupOperationItem> result = new ArrayList<ContractGroupOperation.ContractGroupOperationItem>(1);
        result.add(new AddDocumentType(mid, title));
        return result;
    }

    private class AddDocumentType
    extends ContractGroupOperation.ContractGroupOperationItem {
        private final String mid;
        private JRadioButton add;
        private JRadioButton del;
        private BGControlPanelListSelect bills;
        private BGControlPanelListSelect invoices;
        private JCheckBox ifNotExist;
        private final String moduleTitle;

        private AddDocumentType(String moduleId, String title) {
            super(title, Integer.valueOf(moduleId).intValue(), (LayoutManager)new GridBagLayout());
            this.add = new JRadioButton("\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c", true);
            this.del = new JRadioButton("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", false);
            this.bills = new BGControlPanelListSelect();
            this.invoices = new BGControlPanelListSelect();
            this.ifNotExist = new JCheckBox("<html>\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u044e\u0449\u0438\u0435<br> \u0442\u0438\u043f\u044b \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432</html>", true);
            this.mid = moduleId;
            this.moduleTitle = title;
        }

        protected void jbInit() throws Exception {
            this.bills.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430 "));
            this.bills.setMinimumSize(new Dimension(180, 200));
            this.bills.setPreferredSize(new Dimension(180, 200));
            this.invoices.setBorder((Border)new BGTitleBorder(" \u0421\u0447\u0435\u0442\u0430-\u0444\u0430\u043a\u0442\u0443\u0440\u044b, \u0410\u043a\u0442\u044b, \u0423\u041f\u0414 "));
            this.invoices.setMinimumSize(new Dimension(180, 200));
            this.invoices.setPreferredSize(new Dimension(180, 200));
            JTextArea area = this.getTextArea("\u0418\u0437\u043c\u0435\u043d\u044f\u0435\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u0430 bill_contract_doc_type_" + this.mid);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)area, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.add, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.del, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)this.ifNotExist, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)this.bills, new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 14, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this.invoices, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 14, 1, new Insets(0, 0, 5, 5), 0, 0));
            ButtonGroup group = new ButtonGroup();
            group.add(this.add);
            group.add(this.del);
            this.add.addActionListener(e -> this.sel("add"));
            this.del.addActionListener(e -> this.sel("del"));
        }

        protected void setData() {
            int moduleId = Utils.parseInt((String)this.mid);
            ClientContext context = new ClientContext("bill", moduleId, 0, (String)null);
            this.tryCall(() -> {
                List docTypes = ((BillService)context.getWebService(BillService.class, moduleId)).docTypeList(DocumentType.BILL);
                this.bills.getList().setData(ClientUtils.toBGUListItemList((List)docTypes));
            });
            this.tryCall(() -> {
                List docTypes = ((BillService)context.getWebService(BillService.class, moduleId)).docTypeList(DocumentType.INVOICE);
                this.invoices.getList().setData(ClientUtils.toBGUListItemList((List)docTypes));
            });
        }

        protected boolean doItemOperation(String cids) {
            Request request = new Request().setModule("bill").setModuleId(this.mid).setAction("ContractGroupOperation").setAttribute("bills", this.bills.getListValues()).setAttribute("invoices", this.invoices.getListValues());
            if (this.add.isSelected()) {
                request.setAttribute("type", "addDocTypes");
            }
            if (this.del.isSelected()) {
                request.setAttribute("type", "delDocTypes");
            }
            request.setAttribute("cids", cids);
            request.setAttribute("ifNotExist", this.ifNotExist.isSelected() ? "1" : "0");
            return ClientUtils.checkStatus((Document)TransferManager.getDocument((Request)request));
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435(\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435) \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432";
        }

        private void sel(String key) {
            if (key.equals("add")) {
                this.ifNotExist.setEnabled(true);
            }
            if (key.equals("del")) {
                this.ifNotExist.setEnabled(false);
            }
        }
    }
}

