/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import jakarta.jws.WebService;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.modules.bill.common.bean.BankAccount;
import ru.bitel.bgbilling.modules.bill.common.service.BillIntegrationService;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillIntegrationService")
public class BillIntegrationServiceImpl
extends AbstractService
implements BillIntegrationService {
    public String tinkoffBankStatement(String accountNumber, Period period) throws BGException {
        return (String)this.tryReturn(() -> {
            HttpRequest.Builder builder;
            User user = UserMap.getUser((Integer)this.userId);
            String tinkoffToken = user.getConfigSetup().get("tinkoff.token", System.getProperty("tinkoff.token", null));
            if (tinkoffToken == null) {
                throw new BGMessageException("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0442\u043e\u043a\u0435\u043d \u0434\u043e\u0441\u0442\u0443\u043f\u0430");
            }
            String query = "https://business.tinkoff.ru/openapi/api/v1/bank-statement?accountNumber=" + accountNumber + (String)(period != null && period.getDateFrom() != null ? "&from=" + TimeUtils.format((Date)period.getDateFrom(), (String)"yyy-MM-dd") : "") + (String)(period != null && period.getDateTo() != null ? "&till=" + TimeUtils.format((Date)period.getDateTo(), (String)"yyy-MM-dd") : "");
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            HttpResponse<String> response = httpClient.send((builder = HttpRequest.newBuilder().uri(URI.create(query)).setHeader("Content-Type", "application/json").setHeader("Authorization", "Bearer " + tinkoffToken)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new BGMessageException(response.statusCode() + " " + response.body());
            }
            return response.body();
        });
    }

    public List<IdTitle> tinkoffAccountNumber() throws BGException {
        return (List)this.tryReturn(() -> {
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            String tinkoffBIK = "044525974";
            for (BankAccount bankAccount : new AccountManager(this.getConnection(), this.moduleId).getBankAccountList(-1, true)) {
                if (!tinkoffBIK.equals(bankAccount.getBankIdentificationCode())) continue;
                list.add(new IdTitle(bankAccount.getId(), bankAccount.getAccount()));
            }
            return list;
        });
    }

    public String contractListByInn(String inn) throws BGException {
        return (String)this.tryReturn(() -> {
            JSONArray array = new JSONArray();
            ModuleSetup moduleSetup = this.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            int innParameterId = moduleSetup.getInt("contract.inn.parameter.id", 0);
            if (Utils.notBlankString((String)inn) && innParameterId > 0) {
                String sql = "SELECT c.id, c.title, c.comment, inn.val FROM contract_parameter_type_1 as inn LEFT JOIN contract as c ON c.id=inn.cid WHERE inn.pid=? and trim(inn.val)=?";
                try (PreparedStatement ps = this.getConnection().prepareStatement(sql);){
                    ps.setInt(1, innParameterId);
                    ps.setString(2, inn);
                    try (ResultSet rs = ps.executeQuery();){
                        while (rs.next()) {
                            JSONObject json = new JSONObject().put("id", rs.getInt("c.id")).put("title", (Object)rs.getString("c.title")).put("comment", (Object)rs.getString("c.comment")).put("inn", (Object)rs.getString("inn.val"));
                            array.put((Object)json);
                        }
                    }
                }
            }
            return array.toString();
        });
    }
}

