/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.util.List;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocType;
import ru.bitel.bgbilling.modules.bill.server.bean.ContractDocTypeManager;
import ru.bitel.common.Utils;

public class ActionContractGroupOperation
extends ActionBase {
    public void doAction() throws Exception {
        String type = this.getParameter("type");
        String cids = this.getParameter("cids");
        if (Utils.notBlankString((String)cids)) {
            List contracts = Utils.toIntegerList((String)cids);
            if ("addDocTypes".equals(type)) {
                this.addDocType(contracts);
            } else if ("delDocTypes".equals(type)) {
                this.delDocType(contracts);
            }
        }
    }

    private void addDocType(List<Integer> contracts) {
        String _bills = this.getParameter("bills");
        String _invoices = this.getParameter("invoices");
        boolean ifExist = !"1".equals(this.getParameter("ifNotExist"));
        List bills = Utils.toIntegerList((String)_bills);
        List invoices = Utils.toIntegerList((String)_invoices);
        ContractDocTypeManager man = new ContractDocTypeManager(this.con, this.mid);
        ContractDocType d = new ContractDocType();
        for (Integer cid : contracts) {
            if (cid == null || cid <= 0) continue;
            d.setContractId(cid);
            for (Integer bdt : bills) {
                if (bdt == null || bdt <= 0) continue;
                d.setDocTypeId(bdt);
                if (!ifExist && man.checkDocTypeExist(d)) continue;
                man.addContractType(d);
            }
            for (Integer bdt : invoices) {
                if (bdt == null || bdt <= 0) continue;
                d.setDocTypeId(bdt);
                if (!ifExist && man.checkDocTypeExist(d)) continue;
                man.addContractType(d);
            }
        }
    }

    private void delDocType(List<Integer> contracts) throws Exception {
        List bills = Utils.toIntegerList((String)this.getParameter("bills"));
        List invoices = Utils.toIntegerList((String)this.getParameter("invoices"));
        ContractDocTypeManager contractDocTypeManager = new ContractDocTypeManager(this.con, this.mid);
        for (Integer cid : contracts) {
            if (cid == null || cid <= 0) continue;
            for (Integer bdt : bills) {
                if (bdt == null || bdt <= 0) continue;
                contractDocTypeManager.deleteContractType(cid, bdt);
            }
            for (Integer bdt : invoices) {
                if (bdt == null || bdt <= 0) continue;
                contractDocTypeManager.deleteContractType(cid, bdt);
            }
        }
    }
}

